/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.io.File;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.TestBlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.AvailableSpaceBlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.PathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestAvailableSpaceBPPBalanceLocal {
    private static final int NUM_RACKS = 2;
    private static final int NODES_PER_RACK = 3;
    static final int BLOCK_SIZE = 1024;
    static final int CHOOSE_TIMES = 10000;
    static final String FILE = "/tobers/test";
    private static DatanodeStorageInfo[] storages;
    private static DatanodeDescriptor[] dataNodes;
    private static Configuration conf;
    private static NameNode namenode;
    private static NetworkTopology cluster;

    @BeforeAll
    public static void setupCluster() throws Exception {
        conf = new HdfsConfiguration();
        conf.setFloat("dfs.namenode.available-space-block-placement-policy.balanced-space-preference-fraction", 0.6f);
        conf.setBoolean("dfs.namenode.available-space-block-placement-policy.balance-local-node", true);
        String[] racks = new String[2];
        for (int i = 0; i < 2; ++i) {
            racks[i] = "/rack" + i;
        }
        String[] ownerRackOfNodes = new String[6];
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 3; ++j) {
                ownerRackOfNodes[i * 3 + j] = racks[i];
            }
        }
        storages = DFSTestUtil.createDatanodeStorageInfos(ownerRackOfNodes);
        dataNodes = DFSTestUtil.toDatanodeDescriptor(storages);
        FileSystem.setDefaultUri((Configuration)conf, (String)"hdfs://localhost:0");
        conf.set("dfs.namenode.http-address", "0.0.0.0:0");
        File baseDir = PathUtils.getTestDir(AvailableSpaceBlockPlacementPolicy.class);
        conf.set("dfs.namenode.name.dir", new File(baseDir, "name").getPath());
        conf.set("dfs.block.replicator.classname", AvailableSpaceBlockPlacementPolicy.class.getName());
        DFSTestUtil.formatNameNode(conf);
        namenode = new NameNode(conf);
        BlockManager bm = namenode.getNamesystem().getBlockManager();
        cluster = bm.getDatanodeManager().getNetworkTopology();
        for (int i = 0; i < 6; ++i) {
            cluster.add((Node)dataNodes[i]);
        }
        TestAvailableSpaceBPPBalanceLocal.setupDataNodeCapacity();
    }

    protected static void updateHeartbeatWithUsage(DatanodeDescriptor dn, long capacity, long dfsUsed, long remaining, long blockPoolUsed, long dnCacheCapacity, long dnCacheUsed, int xceiverCount, int volFailures) {
        dn.getStorageInfos()[0].setUtilizationForTesting(capacity, dfsUsed, remaining, blockPoolUsed);
        dn.updateHeartbeat(BlockManagerTestUtil.getStorageReportsForDatanode(dn), dnCacheCapacity, dnCacheUsed, xceiverCount, volFailures, null);
    }

    protected static void setupDataNodeCapacity() {
        for (int i = 0; i < 6; ++i) {
            if (i % 2 == 0) {
                TestAvailableSpaceBPPBalanceLocal.updateHeartbeatWithUsage(dataNodes[i], 4096L, 0L, 4096L, 0L, 0L, 0L, 0, 0);
                continue;
            }
            TestAvailableSpaceBPPBalanceLocal.updateHeartbeatWithUsage(dataNodes[i], 4096L, 3072L, 1024L, 0L, 0L, 0L, 0, 0);
        }
    }

    @Test
    public void testChooseLocalNode() {
        DatanodeDescriptor localNode = dataNodes[0];
        for (int i = 0; i < 10000; ++i) {
            DatanodeStorageInfo[] targets = namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget(FILE, 1, (Node)localNode, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assertions.assertEquals((int)1, (int)targets.length);
            Assertions.assertEquals((Object)localNode, (Object)targets[0].getDatanodeDescriptor());
        }
    }

    @Test
    public void testChooseLocalNodeWithLocalNodeLoaded() {
        DatanodeDescriptor localNode = dataNodes[1];
        int numLocalChosen = 0;
        for (int i = 0; i < 10000; ++i) {
            DatanodeStorageInfo[] targets = namenode.getNamesystem().getBlockManager().getBlockPlacementPolicy().chooseTarget(FILE, 1, (Node)localNode, new ArrayList(), false, null, 1024L, TestBlockStoragePolicy.DEFAULT_STORAGE_POLICY, null);
            Assertions.assertEquals((int)1, (int)targets.length);
            if (localNode != targets[0].getDatanodeDescriptor()) continue;
            ++numLocalChosen;
        }
        Assertions.assertTrue((numLocalChosen < 10000 - numLocalChosen ? 1 : 0) != 0);
    }
}

