/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.server.balancer.KeyManager;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.test.Whitebox;
import org.apache.hadoop.util.FakeTimer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

@Timeout(value=120L)
public class TestKeyManager {
    @Test
    public void testNewDataEncryptionKey() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.encrypt.data.transfer", true);
        conf.setBoolean("dfs.block.access.token.enable", true);
        long keyUpdateInterval = 2000L;
        long tokenLifeTime = 2000L;
        String blockPoolId = "bp-foo";
        FakeTimer fakeTimer = new FakeTimer();
        BlockTokenSecretManager btsm = new BlockTokenSecretManager(2000L, 2000L, 0, 1, "bp-foo", null, false);
        Whitebox.setInternalState((Object)btsm, (String)"timer", (Object)fakeTimer);
        NamenodeProtocol namenode = (NamenodeProtocol)Mockito.mock(NamenodeProtocol.class);
        Mockito.when((Object)namenode.getBlockKeys()).thenReturn((Object)btsm.exportKeys());
        KeyManager keyManager = new KeyManager("bp-foo", namenode, true, (Configuration)conf);
        Whitebox.setInternalState((Object)keyManager, (String)"timer", (Object)fakeTimer);
        Whitebox.setInternalState((Object)Whitebox.getInternalState((Object)keyManager, (String)"blockTokenSecretManager"), (String)"timer", (Object)fakeTimer);
        DataEncryptionKey dek = keyManager.newDataEncryptionKey();
        long remainingTime = dek.expiryDate - fakeTimer.now();
        Assertions.assertEquals((long)2000L, (long)remainingTime, (String)"KeyManager dataEncryptionKey should expire in 2 seconds");
        fakeTimer.advance(2001L);
        DataEncryptionKey dekAfterExpiration = keyManager.newDataEncryptionKey();
        Assertions.assertNotEquals((Object)dek, (Object)dekAfterExpiration, (String)"KeyManager should generate a new data encryption key");
        Assertions.assertTrue((dekAfterExpiration.expiryDate > fakeTimer.now() ? 1 : 0) != 0, (String)"KeyManager has an expired DataEncryptionKey!");
    }
}

