/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.hadoop.hdfs.qjournal.server.JournalNodeRpcServer;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestJournalNodeRespectsBindHostKeys {
    public static final Logger LOG = LoggerFactory.getLogger(TestJournalNodeRespectsBindHostKeys.class);
    private static final String WILDCARD_ADDRESS = "0.0.0.0";
    private static final String LOCALHOST_SERVER_ADDRESS = "127.0.0.1:0";
    private static final int NUM_JN = 1;
    private HdfsConfiguration conf;
    private MiniJournalCluster jCluster;
    private JournalNode jn;
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestJournalNodeRespectsBindHostKeys.class.getSimpleName();

    @BeforeEach
    public void setUp() {
        this.conf = new HdfsConfiguration();
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.jCluster != null) {
            this.jCluster.shutdown();
            this.jCluster = null;
        }
    }

    private static String getRpcServerAddress(JournalNode jn) {
        JournalNodeRpcServer rpcServer = jn.getRpcServer();
        return rpcServer.getRpcServer().getListenerAddress().getAddress().toString();
    }

    @Test
    @Timeout(value=300L)
    public void testRpcBindHostKey() throws IOException {
        LOG.info("Testing without dfs.journalnode.rpc-bind-host");
        this.jCluster = new MiniJournalCluster.Builder((Configuration)this.conf).format(true).numJournalNodes(1).build();
        this.jn = this.jCluster.getJournalNode(0);
        String address = TestJournalNodeRespectsBindHostKeys.getRpcServerAddress(this.jn);
        ((AbstractStringAssert)Assertions.assertThat((String)address).as("Bind address not expected to be wildcard by default.", new Object[0])).isNotEqualTo((Object)"/0.0.0.0");
        LOG.info("Testing with dfs.journalnode.rpc-bind-host");
        this.conf.set("dfs.journalnode.rpc-bind-host", WILDCARD_ADDRESS);
        this.jCluster = new MiniJournalCluster.Builder((Configuration)this.conf).format(true).numJournalNodes(1).build();
        this.jn = this.jCluster.getJournalNode(0);
        address = TestJournalNodeRespectsBindHostKeys.getRpcServerAddress(this.jn);
        ((AbstractStringAssert)Assertions.assertThat((String)address).as("Bind address " + address + " is not wildcard.", new Object[0])).isEqualTo((Object)"/0.0.0.0");
    }

    @Test
    @Timeout(value=300L)
    public void testHttpBindHostKey() throws IOException {
        LOG.info("Testing without dfs.journalnode.http-bind-host");
        this.conf.set("dfs.journalnode.http-address", LOCALHOST_SERVER_ADDRESS);
        this.jCluster = new MiniJournalCluster.Builder((Configuration)this.conf).format(true).numJournalNodes(1).build();
        this.jn = this.jCluster.getJournalNode(0);
        String address = this.jn.getHttpAddress().toString();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)address.startsWith(WILDCARD_ADDRESS), (String)"HTTP Bind address not expected to be wildcard by default.");
        LOG.info("Testing with dfs.journalnode.http-bind-host");
        this.conf.set("dfs.journalnode.http-bind-host", WILDCARD_ADDRESS);
        this.conf.set("dfs.journalnode.http-address", LOCALHOST_SERVER_ADDRESS);
        this.jCluster = new MiniJournalCluster.Builder((Configuration)this.conf).format(true).numJournalNodes(1).build();
        this.jn = this.jCluster.getJournalNode(0);
        address = this.jn.getHttpAddress().toString();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)address.startsWith(WILDCARD_ADDRESS), (String)("HTTP Bind address " + address + " is not wildcard."));
    }

    private static void setupSsl() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.journalnode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        File base = new File(BASEDIR);
        FileUtil.fullyDelete((File)base);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)base.mkdirs());
        String keystoresDir = new File(BASEDIR).getAbsolutePath();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestJournalNodeRespectsBindHostKeys.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
    }

    @Test
    @Timeout(value=300L)
    public void testHttpsBindHostKey() throws Exception {
        LOG.info("Testing behavior without dfs.journalnode.https-bind-host");
        TestJournalNodeRespectsBindHostKeys.setupSsl();
        this.conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        this.conf.set("dfs.journalnode.https-address", LOCALHOST_SERVER_ADDRESS);
        this.jCluster = new MiniJournalCluster.Builder((Configuration)this.conf).format(true).numJournalNodes(1).build();
        this.jn = this.jCluster.getJournalNode(0);
        String address = this.jn.getHttpsAddress().toString();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)address.startsWith(WILDCARD_ADDRESS), (String)"HTTP Bind address not expected to be wildcard by default.");
        LOG.info("Testing behavior with dfs.journalnode.https-bind-host");
        this.conf.set("dfs.journalnode.https-bind-host", WILDCARD_ADDRESS);
        this.conf.set("dfs.journalnode.https-address", LOCALHOST_SERVER_ADDRESS);
        this.jCluster = new MiniJournalCluster.Builder((Configuration)this.conf).format(true).numJournalNodes(1).build();
        this.jn = this.jCluster.getJournalNode(0);
        address = this.jn.getHttpsAddress().toString();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)address.startsWith(WILDCARD_ADDRESS), (String)("HTTP Bind address " + address + " is not wildcard."));
    }
}

