/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.eclipse.jetty.util.ajax.JSON;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestJournalNodeMXBean {
    private static final String NAMESERVICE = "ns1";
    private static final int NUM_JN = 1;
    private static final int NS_ID = 12345;
    private MiniJournalCluster jCluster;
    private JournalNode jn;

    @BeforeEach
    public void setup() throws IOException {
        this.jCluster = new MiniJournalCluster.Builder(new Configuration()).format(true).numJournalNodes(1).build();
        this.jCluster.waitActive();
        this.jn = this.jCluster.getJournalNode(0);
    }

    @AfterEach
    public void cleanup() throws IOException {
        if (this.jCluster != null) {
            this.jCluster.shutdown();
            this.jCluster = null;
        }
    }

    @Test
    public void testJournalNodeMXBean() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName mxbeanName = new ObjectName("Hadoop:service=JournalNode,name=JournalNodeInfo");
        String journalStatus = (String)mbs.getAttribute(mxbeanName, "JournalsStatus");
        Assertions.assertEquals((Object)this.jn.getJournalsStatus(), (Object)journalStatus);
        Assertions.assertFalse((boolean)journalStatus.contains(NAMESERVICE));
        NamespaceInfo fakeNsInfo = new NamespaceInfo(12345, "mycluster", "my-bp", 0L);
        this.jn.getOrCreateJournal(NAMESERVICE).format(fakeNsInfo, false);
        journalStatus = (String)mbs.getAttribute(mxbeanName, "JournalsStatus");
        Assertions.assertEquals((Object)this.jn.getJournalsStatus(), (Object)journalStatus);
        HashMap jMap = new HashMap();
        HashMap<String, String> infoMap = new HashMap<String, String>();
        infoMap.put("Formatted", "true");
        jMap.put(NAMESERVICE, infoMap);
        HashMap<String, String> infoMap1 = new HashMap<String, String>();
        infoMap1.put("Formatted", "false");
        jMap.put("waitactive", infoMap1);
        Assertions.assertEquals((Object)JSON.toString(jMap), (Object)journalStatus);
        String hostAndPort = (String)mbs.getAttribute(mxbeanName, "HostAndPort");
        Assertions.assertEquals((Object)this.jn.getHostAndPort(), (Object)hostAndPort);
        Assertions.assertTrue((boolean)hostAndPort.matches("localhost:\\d+"));
        String[] clusterId = (String[])mbs.getAttribute(mxbeanName, "ClusterIds");
        Assertions.assertEquals((int)this.jn.getClusterIds().size(), (int)clusterId.length);
        Assertions.assertEquals((Object)"mycluster", (Object)clusterId[0]);
        long startTime = (Long)mbs.getAttribute(mxbeanName, "JNStartedTimeInMillis");
        Assertions.assertTrue((startTime > 0L ? 1 : 0) != 0, (String)"JournalNode start time should not be 0");
        Assertions.assertEquals((long)this.jn.getJNStartedTimeInMillis(), (long)startTime);
        String version = (String)mbs.getAttribute(mxbeanName, "Version");
        Assertions.assertEquals((Object)this.jn.getVersion(), (Object)version);
        String[] journalStorageInfos = (String[])mbs.getAttribute(mxbeanName, "StorageInfos");
        Assertions.assertEquals((int)this.jn.getStorageInfos().size(), (int)journalStorageInfos.length);
        Assertions.assertTrue((boolean)journalStorageInfos[1].contains("ClusterId=mycluster"));
        Assertions.assertTrue((boolean)journalStorageInfos[1].contains("CreationTime=0"));
        Assertions.assertTrue((boolean)journalStorageInfos[1].contains("NamespaceId=12345"));
        this.jCluster = new MiniJournalCluster.Builder(new Configuration()).format(false).numJournalNodes(1).build();
        this.jCluster.waitActive();
        this.jn = this.jCluster.getJournalNode(0);
        journalStatus = (String)mbs.getAttribute(mxbeanName, "JournalsStatus");
        Assertions.assertEquals((Object)this.jn.getJournalsStatus(), (Object)journalStatus);
        Assertions.assertEquals((Object)JSON.toString(jMap), (Object)journalStatus);
    }
}

