/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.server;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.qjournal.MiniJournalCluster;
import org.apache.hadoop.hdfs.qjournal.server.JournalNode;
import org.apache.hadoop.http.HttpServer2;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJournalNodeHttpServerXFrame {
    private static final int NUM_JN = 1;
    private MiniJournalCluster cluster;

    @Test
    public void testJournalNodeXFrameOptionsEnabled() throws Exception {
        boolean xFrameEnabled = true;
        this.cluster = TestJournalNodeHttpServerXFrame.createCluster(xFrameEnabled);
        HttpURLConnection conn = TestJournalNodeHttpServerXFrame.getConn(this.cluster);
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        Assertions.assertTrue((xfoHeader != null ? 1 : 0) != 0, (String)"X-FRAME-OPTIONS is absent in the header");
        Assertions.assertTrue((boolean)xfoHeader.endsWith(HttpServer2.XFrameOption.SAMEORIGIN.toString()));
    }

    @Test
    public void testJournalNodeXFrameOptionsDisabled() throws Exception {
        boolean xFrameEnabled = false;
        this.cluster = TestJournalNodeHttpServerXFrame.createCluster(xFrameEnabled);
        HttpURLConnection conn = TestJournalNodeHttpServerXFrame.getConn(this.cluster);
        String xfoHeader = conn.getHeaderField("X-FRAME-OPTIONS");
        System.out.println(xfoHeader);
        Assertions.assertTrue((xfoHeader == null ? 1 : 0) != 0, (String)"unexpected X-FRAME-OPTION in header");
    }

    @AfterEach
    public void cleanup() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private static MiniJournalCluster createCluster(boolean enabled) throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.xframe.enabled", enabled);
        MiniJournalCluster jCluster = new MiniJournalCluster.Builder(conf).format(true).numJournalNodes(1).build();
        jCluster.waitActive();
        return jCluster;
    }

    private static HttpURLConnection getConn(MiniJournalCluster journalCluster) throws IOException {
        JournalNode journalNode = journalCluster.getJournalNode(0);
        URL newURL = new URL(journalNode.getHttpServerURI());
        HttpURLConnection conn = (HttpURLConnection)newURL.openConnection();
        conn.connect();
        return conn;
    }
}

