/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.qjournal.client;

import java.util.Map;
import org.apache.hadoop.hdfs.qjournal.client.AsyncLogger;
import org.apache.hadoop.hdfs.qjournal.client.SegmentRecoveryComparator;
import org.apache.hadoop.hdfs.qjournal.protocol.QJournalProtocolProtos;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestSegmentRecoveryComparator {
    private static Map.Entry<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> makeEntry(QJournalProtocolProtos.PrepareRecoveryResponseProto proto) {
        return Maps.immutableEntry((Object)Mockito.mock(AsyncLogger.class), (Object)proto);
    }

    @Test
    public void testComparisons() {
        Map.Entry<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> INPROGRESS_1_3 = TestSegmentRecoveryComparator.makeEntry(QJournalProtocolProtos.PrepareRecoveryResponseProto.newBuilder().setSegmentState(QJournalProtocolProtos.SegmentStateProto.newBuilder().setStartTxId(1L).setEndTxId(3L).setIsInProgress(true)).setLastWriterEpoch(0L).build());
        Map.Entry<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> INPROGRESS_1_4 = TestSegmentRecoveryComparator.makeEntry(QJournalProtocolProtos.PrepareRecoveryResponseProto.newBuilder().setSegmentState(QJournalProtocolProtos.SegmentStateProto.newBuilder().setStartTxId(1L).setEndTxId(4L).setIsInProgress(true)).setLastWriterEpoch(0L).build());
        Map.Entry<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> INPROGRESS_1_4_ACCEPTED = TestSegmentRecoveryComparator.makeEntry(QJournalProtocolProtos.PrepareRecoveryResponseProto.newBuilder().setSegmentState(QJournalProtocolProtos.SegmentStateProto.newBuilder().setStartTxId(1L).setEndTxId(4L).setIsInProgress(true)).setLastWriterEpoch(0L).setAcceptedInEpoch(1L).build());
        Map.Entry<AsyncLogger, QJournalProtocolProtos.PrepareRecoveryResponseProto> FINALIZED_1_3 = TestSegmentRecoveryComparator.makeEntry(QJournalProtocolProtos.PrepareRecoveryResponseProto.newBuilder().setSegmentState(QJournalProtocolProtos.SegmentStateProto.newBuilder().setStartTxId(1L).setEndTxId(3L).setIsInProgress(false)).setLastWriterEpoch(0L).build());
        Assertions.assertEquals((int)0, (int)SegmentRecoveryComparator.INSTANCE.compare(INPROGRESS_1_3, INPROGRESS_1_3));
        Assertions.assertEquals((int)-1, (int)SegmentRecoveryComparator.INSTANCE.compare(INPROGRESS_1_3, INPROGRESS_1_4));
        Assertions.assertEquals((int)1, (int)SegmentRecoveryComparator.INSTANCE.compare(INPROGRESS_1_4, INPROGRESS_1_3));
        Assertions.assertEquals((int)-1, (int)SegmentRecoveryComparator.INSTANCE.compare(INPROGRESS_1_4, FINALIZED_1_3));
        Assertions.assertEquals((int)1, (int)SegmentRecoveryComparator.INSTANCE.compare(FINALIZED_1_3, INPROGRESS_1_4));
        Assertions.assertEquals((int)-1, (int)SegmentRecoveryComparator.INSTANCE.compare(INPROGRESS_1_4_ACCEPTED, FINALIZED_1_3));
        Assertions.assertEquals((int)1, (int)SegmentRecoveryComparator.INSTANCE.compare(FINALIZED_1_3, INPROGRESS_1_4_ACCEPTED));
    }
}

