/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataEncryptionKeyFactory;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferClient;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferTestCase;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=300L)
public class TestSaslDataTransfer
extends SaslDataTransferTestCase {
    private static final int BLOCK_SIZE = 4096;
    private static final int NUM_BLOCKS = 3;
    private static final Path PATH = new Path("/file1");
    private MiniDFSCluster cluster;
    private FileSystem fs;

    @AfterEach
    public void shutdown() {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{this.fs});
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testAuthentication() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "authentication");
        this.doTest(clientConf);
    }

    @Test
    public void testIntegrity() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "integrity");
        this.doTest(clientConf);
    }

    @Test
    public void testPrivacy() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "privacy");
        this.doTest(clientConf);
    }

    @Test
    public void testClientAndServerDoNotHaveCommonQop() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("privacy");
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "authentication");
        IOException exception = (IOException)Assertions.assertThrows(IOException.class, () -> this.doTest(clientConf));
        Assertions.assertTrue((boolean)exception.getMessage().contains("could only be written to 0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerSaslNoClientSasl() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication,integrity,privacy");
        clusterConf.setInt("dfs.client.retry.window.base", 10);
        this.startCluster(clusterConf);
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)clusterConf);
        clientConf.set("dfs.data.transfer.protection", "");
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(DataNode.class));
        try {
            this.doTest(clientConf);
            Assertions.fail((String)"Should fail if SASL data transfer protection is not configured or not supported in client");
        }
        catch (IOException e) {
            GenericTestUtils.assertMatches((String)e.getMessage(), (String)"could only be written to 0");
        }
        finally {
            logs.stopCapturing();
        }
        GenericTestUtils.assertMatches((String)logs.getOutput(), (String)"Failed to read expected SASL data transfer protection handshake from client at");
    }

    @Test
    public void testDataNodeAbortsIfNoSasl() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("");
        Assertions.assertThrows(RuntimeException.class, () -> this.startCluster(clusterConf));
    }

    @Test
    public void testDataNodeAbortsIfNotHttpsOnly() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("authentication");
        clusterConf.set("dfs.http.policy", HttpConfig.Policy.HTTP_AND_HTTPS.name());
        Assertions.assertThrows(RuntimeException.class, () -> this.startCluster(clusterConf));
    }

    @Test
    public void testDataNodeStartIfHttpsQopPrivacy() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("privacy");
        clusterConf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        this.startCluster(clusterConf);
    }

    @Test
    public void testNoSaslAndSecurePortsIgnored() throws Exception {
        HdfsConfiguration clusterConf = this.createSecureConfig("");
        clusterConf.setBoolean("ignore.secure.ports.for.testing", true);
        this.startCluster(clusterConf);
        this.doTest(clusterConf);
    }

    private void doTest(HdfsConfiguration conf) throws IOException {
        this.fs = FileSystem.get((URI)this.cluster.getURI(), (Configuration)conf);
        FileSystemTestHelper.createFile((FileSystem)this.fs, (Path)PATH, (int)3, (int)4096);
        Assertions.assertArrayEquals((byte[])FileSystemTestHelper.getFileData((int)3, (long)4096L), (byte[])DFSTestUtil.readFile(this.fs, PATH).getBytes(StandardCharsets.UTF_8));
        BlockLocation[] blockLocations = this.fs.getFileBlockLocations(PATH, 0L, Long.MAX_VALUE);
        Assertions.assertNotNull((Object)blockLocations);
        Assertions.assertEquals((int)3, (int)blockLocations.length);
        for (BlockLocation blockLocation : blockLocations) {
            Assertions.assertNotNull((Object)blockLocation.getHosts());
            Assertions.assertEquals((int)3, (int)blockLocation.getHosts().length);
        }
    }

    private void startCluster(HdfsConfiguration conf) throws IOException {
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        this.cluster.waitActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void TestPeerFromSocketAndKeyReadTimeout() throws Exception {
        HdfsConfiguration conf = this.createSecureConfig("authentication,integrity,privacy");
        AtomicBoolean fallbackToSimpleAuth = new AtomicBoolean(false);
        SaslDataTransferClient saslClient = new SaslDataTransferClient((Configuration)conf, DataTransferSaslUtil.getSaslPropertiesResolver((Configuration)conf), TrustedChannelResolver.getInstance((Configuration)conf), fallbackToSimpleAuth);
        DatanodeID fakeDatanodeId = new DatanodeID("127.0.0.1", "localhost", "beefbeef-beef-beef-beef-beefbeefbeef", 1, 2, 3, 4);
        DataEncryptionKeyFactory dataEncKeyFactory = new DataEncryptionKeyFactory(){

            public DataEncryptionKey newDataEncryptionKey() {
                return new DataEncryptionKey(123, "456", new byte[8], new byte[8], 1234567L, "fakeAlgorithm");
            }
        };
        ServerSocket serverSocket = null;
        Socket socket = null;
        try {
            serverSocket = new ServerSocket(0, -1);
            socket = new Socket(serverSocket.getInetAddress(), serverSocket.getLocalPort());
            Peer peer = DFSUtilClient.peerFromSocketAndKey((SaslDataTransferClient)saslClient, (Socket)socket, (DataEncryptionKeyFactory)dataEncKeyFactory, (Token)new Token(), (DatanodeID)fakeDatanodeId, (int)1);
            peer.close();
            Assertions.fail((String)"Expected DFSClient#peerFromSocketAndKey to time out.");
        }
        catch (SocketTimeoutException e) {
            try {
                GenericTestUtils.assertExceptionContains((String)"Read timed out", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
                throw throwable;
            }
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaslDataTransferWithTrustedServerUntrustedClient() throws Exception {
        HdfsConfiguration conf = this.createSecureConfig("authentication,integrity,privacy");
        AtomicBoolean fallbackToSimpleAuth = new AtomicBoolean(false);
        TrustedChannelResolver trustedChannelResolver = new TrustedChannelResolver(){

            public boolean isTrusted() {
                return true;
            }

            public boolean isTrusted(InetAddress peerAddress) {
                return false;
            }
        };
        SaslDataTransferClient saslClient = new SaslDataTransferClient((Configuration)conf, DataTransferSaslUtil.getSaslPropertiesResolver((Configuration)conf), trustedChannelResolver, fallbackToSimpleAuth);
        ServerSocket serverSocket = null;
        Socket socket = null;
        DataEncryptionKeyFactory dataEncryptionKeyFactory = null;
        try {
            serverSocket = new ServerSocket(10002, 10);
            socket = new Socket(serverSocket.getInetAddress(), serverSocket.getLocalPort());
            dataEncryptionKeyFactory = (DataEncryptionKeyFactory)Mockito.mock(DataEncryptionKeyFactory.class);
            Mockito.when((Object)dataEncryptionKeyFactory.newDataEncryptionKey()).thenThrow(new Throwable[]{new IOException("Encryption enabled")});
            saslClient.socketSend(socket, null, null, dataEncryptionKeyFactory, null, null);
            Assertions.fail((String)"Expected IOException from SaslDataTransferClient#checkTrustAndSend");
        }
        catch (IOException e) {
            try {
                GenericTestUtils.assertExceptionContains((String)"Encryption enabled", (Throwable)e);
                ((DataEncryptionKeyFactory)Mockito.verify(dataEncryptionKeyFactory, (VerificationMode)Mockito.times((int)1))).newDataEncryptionKey();
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
                throw throwable;
            }
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaslDataTransferWithUntrustedServerUntrustedClient() throws Exception {
        HdfsConfiguration conf = this.createSecureConfig("authentication,integrity,privacy");
        AtomicBoolean fallbackToSimpleAuth = new AtomicBoolean(false);
        TrustedChannelResolver trustedChannelResolver = new TrustedChannelResolver(){

            public boolean isTrusted() {
                return false;
            }

            public boolean isTrusted(InetAddress peerAddress) {
                return false;
            }
        };
        SaslDataTransferClient saslClient = new SaslDataTransferClient((Configuration)conf, DataTransferSaslUtil.getSaslPropertiesResolver((Configuration)conf), trustedChannelResolver, fallbackToSimpleAuth);
        ServerSocket serverSocket = null;
        Socket socket = null;
        DataEncryptionKeyFactory dataEncryptionKeyFactory = null;
        try {
            serverSocket = new ServerSocket(10002, 10);
            socket = new Socket(serverSocket.getInetAddress(), serverSocket.getLocalPort());
            dataEncryptionKeyFactory = (DataEncryptionKeyFactory)Mockito.mock(DataEncryptionKeyFactory.class);
            Mockito.when((Object)dataEncryptionKeyFactory.newDataEncryptionKey()).thenThrow(new Throwable[]{new IOException("Encryption enabled")});
            saslClient.socketSend(socket, null, null, dataEncryptionKeyFactory, null, null);
            Assertions.fail((String)"Expected IOException from SaslDataTransferClient#checkTrustAndSend");
        }
        catch (IOException e) {
            try {
                GenericTestUtils.assertExceptionContains((String)"Encryption enabled", (Throwable)e);
                ((DataEncryptionKeyFactory)Mockito.verify(dataEncryptionKeyFactory, (VerificationMode)Mockito.times((int)1))).newDataEncryptionKey();
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
                throw throwable;
            }
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaslDataTransferWithTrustedServerTrustedClient() throws Exception {
        HdfsConfiguration conf = this.createSecureConfig("authentication,integrity,privacy");
        AtomicBoolean fallbackToSimpleAuth = new AtomicBoolean(false);
        TrustedChannelResolver trustedChannelResolver = new TrustedChannelResolver(){

            public boolean isTrusted() {
                return true;
            }

            public boolean isTrusted(InetAddress peerAddress) {
                return true;
            }
        };
        SaslDataTransferClient saslClient = new SaslDataTransferClient((Configuration)conf, DataTransferSaslUtil.getSaslPropertiesResolver((Configuration)conf), trustedChannelResolver, fallbackToSimpleAuth);
        ServerSocket serverSocket = null;
        Socket socket = null;
        DataEncryptionKeyFactory dataEncryptionKeyFactory = null;
        try {
            serverSocket = new ServerSocket(10002, 10);
            socket = new Socket(serverSocket.getInetAddress(), serverSocket.getLocalPort());
            dataEncryptionKeyFactory = (DataEncryptionKeyFactory)Mockito.mock(DataEncryptionKeyFactory.class);
            Mockito.when((Object)dataEncryptionKeyFactory.newDataEncryptionKey()).thenThrow(new Throwable[]{new IOException("Encryption enabled")});
            saslClient.socketSend(socket, null, null, dataEncryptionKeyFactory, null, null);
            ((DataEncryptionKeyFactory)Mockito.verify((Object)dataEncryptionKeyFactory, (VerificationMode)Mockito.times((int)0))).newDataEncryptionKey();
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{socket, serverSocket});
    }
}

