/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferServer;
import org.apache.hadoop.security.CustomizedCallbackHandler;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCustomizedCallbackHandler {
    static final Logger LOG = LoggerFactory.getLogger(TestCustomizedCallbackHandler.class);
    static final AtomicReference<List<Callback>> LAST_CALLBACKS = new AtomicReference();

    static void reset() {
        LAST_CALLBACKS.set(null);
        CustomizedCallbackHandler.Cache.clear();
    }

    static void runHandleCallbacks(Object caller, List<Callback> callbacks, String name) {
        LOG.info("{}: handling {} for {}", new Object[]{caller.getClass().getSimpleName(), callbacks, name});
        LAST_CALLBACKS.set(callbacks);
    }

    static void assertCallbacks(Callback[] expected) {
        List computed = LAST_CALLBACKS.getAndSet(null);
        Assertions.assertNotNull((Object)computed);
        Assertions.assertEquals((int)expected.length, (int)computed.size());
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertSame((Object)expected[i], computed.get(i));
        }
    }

    @Test
    public void testCustomizedCallbackHandler() throws Exception {
        Configuration conf = new Configuration();
        Callback[] callbacks = new Callback[]{new MyCallback()};
        TestCustomizedCallbackHandler.reset();
        LambdaTestUtils.intercept(UnsupportedCallbackException.class, () -> TestCustomizedCallbackHandler.runTest(conf, callbacks));
        TestCustomizedCallbackHandler.reset();
        conf.setClass("hadoop.security.sasl.CustomizedCallbackHandler.class", MyCallbackHandler.class, CustomizedCallbackHandler.class);
        TestCustomizedCallbackHandler.runTest(conf, callbacks);
        TestCustomizedCallbackHandler.assertCallbacks(callbacks);
        TestCustomizedCallbackHandler.reset();
        conf.setClass("hadoop.security.sasl.CustomizedCallbackHandler.class", MyCallbackHandler.class, CustomizedCallbackHandler.class);
        new SaslRpcServer.SaslDigestCallbackHandler(null, null, conf).handle(callbacks);
        TestCustomizedCallbackHandler.assertCallbacks(callbacks);
    }

    @Test
    public void testCustomizedCallbackMethod() throws Exception {
        Configuration conf = new Configuration();
        Callback[] callbacks = new Callback[]{new MyCallback()};
        TestCustomizedCallbackHandler.reset();
        LambdaTestUtils.intercept(UnsupportedCallbackException.class, () -> TestCustomizedCallbackHandler.runTest(conf, callbacks));
        TestCustomizedCallbackHandler.reset();
        conf.setClass("hadoop.security.sasl.CustomizedCallbackHandler.class", MyCallbackMethod.class, Object.class);
        TestCustomizedCallbackHandler.runTest(conf, callbacks);
        TestCustomizedCallbackHandler.assertCallbacks(callbacks);
        TestCustomizedCallbackHandler.reset();
        conf.setClass("hadoop.security.sasl.CustomizedCallbackHandler.class", MyExceptionMethod.class, Object.class);
        LambdaTestUtils.intercept(IOException.class, () -> TestCustomizedCallbackHandler.runTest(conf, callbacks));
    }

    static void runTest(Configuration conf, Callback ... callbacks) throws IOException, UnsupportedCallbackException {
        new SaslDataTransferServer.SaslServerCallbackHandler(conf, String::toCharArray).handle(callbacks);
    }

    public static class MyExceptionMethod {
        public void handleCallbacks(List<Callback> callbacks, String name, char[] password) throws UnsupportedCallbackException {
            TestCustomizedCallbackHandler.runHandleCallbacks(this, callbacks, name);
            throw new UnsupportedCallbackException(callbacks.get(0));
        }
    }

    public static class MyCallbackMethod {
        public void handleCallbacks(List<Callback> callbacks, String name, char[] password) throws UnsupportedCallbackException {
            TestCustomizedCallbackHandler.runHandleCallbacks(this, callbacks, name);
        }
    }

    public static class MyCallbackHandler
    implements CustomizedCallbackHandler {
        public void handleCallbacks(List<Callback> callbacks, String name, char[] password) {
            TestCustomizedCallbackHandler.runHandleCallbacks(this, callbacks, name);
        }
    }

    public static class MyCallback
    implements Callback {
    }
}

