/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.datatransfer.BlackListBasedTrustedChannelResolver;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBlackListBasedTrustedChannelResolver {
    private static final String FILE_NAME = "blacklistfile.txt";
    private File blacklistFile;
    private static final String BLACK_LISTED = "127.0.0.1\n216.58.216.174\n";
    private BlackListBasedTrustedChannelResolver resolver;

    @BeforeEach
    public void setup() {
        this.blacklistFile = new File(GenericTestUtils.getTestDir(), FILE_NAME);
        this.resolver = new BlackListBasedTrustedChannelResolver();
        try {
            FileUtils.write((File)this.blacklistFile, (CharSequence)BLACK_LISTED);
        }
        catch (IOException e) {
            Assertions.fail((String)"Setup for TestBlackListBasedTrustedChannelResolver failed.");
        }
    }

    @AfterEach
    public void cleanUp() {
        FileUtils.deleteQuietly((File)this.blacklistFile);
    }

    @Test
    public void testBlackListIpClient() throws IOException {
        Configuration conf = new Configuration();
        FileUtils.write((File)this.blacklistFile, (CharSequence)InetAddress.getLocalHost().getHostAddress(), (boolean)true);
        conf.set("dfs.datatransfer.client.fixedBlackList.file", this.blacklistFile.getAbsolutePath());
        this.resolver.setConf(conf);
        Assertions.assertFalse((boolean)this.resolver.isTrusted());
    }

    @Test
    public void testBlackListIpServer() throws UnknownHostException {
        Configuration conf = new Configuration();
        conf.set("dfs.datatransfer.server.fixedBlackList.file", this.blacklistFile.getAbsolutePath());
        this.resolver.setConf(conf);
        Assertions.assertTrue((boolean)this.resolver.isTrusted());
        Assertions.assertFalse((boolean)this.resolver.isTrusted(InetAddress.getByName("216.58.216.174")));
    }
}

