/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import java.io.File;
import java.util.Properties;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;

public abstract class SaslDataTransferTestCase {
    private static File baseDir;
    private static String keystoresDir;
    private static String sslConfDir;
    private static String hdfsPrincipal;
    private static String userPrincipal;
    private static MiniKdc kdc;
    private static String hdfsKeytab;
    private static String userKeyTab;
    private static String spnegoPrincipal;

    public static String getUserKeyTab() {
        return userKeyTab;
    }

    public static String getUserPrincipal() {
        return userPrincipal;
    }

    public static String getHdfsPrincipal() {
        return hdfsPrincipal;
    }

    public static String getHdfsKeytab() {
        return hdfsKeytab;
    }

    @BeforeAll
    public static void initKdc() throws Exception {
        baseDir = GenericTestUtils.getTestDir((String)SaslDataTransferTestCase.class.getSimpleName());
        FileUtil.fullyDelete((File)baseDir);
        Assertions.assertTrue((boolean)baseDir.mkdirs());
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, baseDir);
        kdc.start();
        String userName = RandomStringUtils.randomAlphabetic((int)8);
        File userKeytabFile = new File(baseDir, userName + ".keytab");
        userKeyTab = userKeytabFile.getAbsolutePath();
        kdc.createPrincipal(userKeytabFile, new String[]{userName + "/localhost"});
        userPrincipal = userName + "/localhost@" + kdc.getRealm();
        String superUserName = "hdfs";
        File hdfsKeytabFile = new File(baseDir, superUserName + ".keytab");
        hdfsKeytab = hdfsKeytabFile.getAbsolutePath();
        kdc.createPrincipal(hdfsKeytabFile, new String[]{superUserName + "/localhost", "HTTP/localhost"});
        hdfsPrincipal = superUserName + "/localhost@" + kdc.getRealm();
        spnegoPrincipal = "HTTP/localhost@" + kdc.getRealm();
    }

    @AfterAll
    public static void shutdownKdc() throws Exception {
        if (kdc != null) {
            kdc.stop();
        }
        FileUtil.fullyDelete((File)baseDir);
        KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
    }

    protected HdfsConfiguration createSecureConfig(String dataTransferProtection) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        conf.set("dfs.namenode.kerberos.principal", hdfsPrincipal);
        conf.set("dfs.namenode.keytab.file", hdfsKeytab);
        conf.set("dfs.datanode.kerberos.principal", hdfsPrincipal);
        conf.set("dfs.datanode.keytab.file", hdfsKeytab);
        conf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.data.transfer.protection", dataTransferProtection);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        conf.setInt("ipc.client.connect.max.retries.on.sasl", 10);
        keystoresDir = baseDir.getAbsolutePath();
        sslConfDir = KeyStoreTestUtil.getClasspathDir(this.getClass());
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        conf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
        return conf;
    }
}

