/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.client.impl.BlockReaderTestUtil;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestBlockReaderRemote {
    private BlockReaderTestUtil util;
    private byte[] blockData;
    private BlockReader reader;

    byte[] getBlockData() {
        int length = 0x400000;
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)(i % 133);
        }
        return data;
    }

    private BlockReader getBlockReader(LocatedBlock block) throws Exception {
        return this.util.getBlockReader(block, 0, this.blockData.length);
    }

    @BeforeEach
    public void setup() throws Exception {
        this.util = new BlockReaderTestUtil(1, new HdfsConfiguration());
        this.blockData = this.getBlockData();
        DistributedFileSystem fs = this.util.getCluster().getFileSystem();
        Path testfile = new Path("/testfile");
        FSDataOutputStream fout = fs.create(testfile);
        fout.write(this.blockData);
        fout.close();
        LocatedBlock blk = this.util.getFileBlocks(testfile, this.blockData.length).get(0);
        this.reader = this.getBlockReader(blk);
    }

    @AfterEach
    public void shutdown() throws Exception {
        this.util.shutdown();
    }

    @Test
    @Timeout(value=60L)
    public void testSkip() throws IOException {
        Random random = new Random();
        byte[] buf = new byte[1];
        for (int pos = 0; pos < this.blockData.length; ++pos) {
            long skip = random.nextInt(100) + 1;
            long skipped = this.reader.skip(skip);
            if ((long)pos + skip >= (long)this.blockData.length) {
                Assertions.assertEquals((long)this.blockData.length, (long)((long)pos + skipped));
                break;
            }
            Assertions.assertEquals((long)skip, (long)skipped);
            pos = (int)((long)pos + skipped);
            Assertions.assertEquals((int)1, (int)this.reader.read(buf, 0, 1));
            Assertions.assertEquals((byte)this.blockData[pos], (byte)buf[0]);
        }
    }
}

