/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.client.impl.metrics.BlockReaderIoProvider;
import org.apache.hadoop.hdfs.client.impl.metrics.BlockReaderLocalMetrics;
import org.apache.hadoop.util.FakeTimer;
import org.apache.hadoop.util.Timer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestBlockReaderIoProvider {
    private static final long SLOW_READ_THRESHOLD = 5000L;
    private static final FakeTimer TIMER = new FakeTimer();

    @Test
    @Timeout(value=300L)
    public void testSlowShortCircuitReadsIsRecorded() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.read.shortcircuit.metrics.sampling.percentage", 100);
        DfsClientConf clientConf = new DfsClientConf((Configuration)conf);
        BlockReaderLocalMetrics metrics = (BlockReaderLocalMetrics)Mockito.mock(BlockReaderLocalMetrics.class);
        FileChannel dataIn = (FileChannel)Mockito.mock(FileChannel.class);
        Mockito.when((Object)dataIn.read((ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), ArgumentMatchers.anyLong())).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                TIMER.advance(5000L);
                return 0;
            }
        });
        BlockReaderIoProvider blockReaderIoProvider = new BlockReaderIoProvider(clientConf.getShortCircuitConf(), metrics, (Timer)TIMER);
        blockReaderIoProvider.read(dataIn, (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class), ArgumentMatchers.anyLong());
        ((BlockReaderLocalMetrics)Mockito.verify((Object)metrics, (VerificationMode)Mockito.times((int)1))).addShortCircuitReadLatency(ArgumentMatchers.anyLong());
    }
}

