/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.client.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockReader;
import org.apache.hadoop.hdfs.ClientContext;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.RemotePeerFactory;
import org.apache.hadoop.hdfs.client.impl.BlockReaderFactory;
import org.apache.hadoop.hdfs.client.impl.BlockReaderLocal;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.server.blockmanagement.CacheReplicationMonitor;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.ShortCircuitRegistry;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetCache;
import org.apache.hadoop.hdfs.server.namenode.CacheManager;
import org.apache.hadoop.hdfs.shortcircuit.DfsClientShmManager;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitReplica;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class BlockReaderTestUtil {
    private HdfsConfiguration conf = null;
    private MiniDFSCluster cluster = null;

    public static boolean shouldTestLargeFiles() {
        String property = System.getProperty("hdfs.test.large.files");
        if (property == null) {
            return false;
        }
        if (property.isEmpty()) {
            return true;
        }
        return Boolean.parseBoolean(property);
    }

    public BlockReaderTestUtil(int replicationFactor) throws Exception {
        this(replicationFactor, new HdfsConfiguration());
    }

    public BlockReaderTestUtil(MiniDFSCluster cluster, HdfsConfiguration conf) {
        this.conf = conf;
        this.cluster = cluster;
    }

    public BlockReaderTestUtil(int replicationFactor, HdfsConfiguration config) throws Exception {
        this.conf = config;
        this.conf.setInt("dfs.replication", replicationFactor);
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).format(true).build();
        this.cluster.waitActive();
    }

    public void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    public MiniDFSCluster getCluster() {
        return this.cluster;
    }

    public HdfsConfiguration getConf() {
        return this.conf;
    }

    public byte[] writeFile(Path filepath, int sizeKB) throws IOException {
        DistributedFileSystem fs = this.cluster.getFileSystem();
        FSDataOutputStream os = fs.create(filepath);
        byte[] data = new byte[1024 * sizeKB];
        new Random().nextBytes(data);
        os.write(data);
        os.close();
        return data;
    }

    public List<LocatedBlock> getFileBlocks(Path filepath, int sizeKB) throws IOException {
        DFSClient dfsclient = this.getDFSClient();
        return dfsclient.getNamenode().getBlockLocations(filepath.toString(), 0L, (long)(sizeKB * 1024)).getLocatedBlocks();
    }

    public DFSClient getDFSClient() throws IOException {
        InetSocketAddress nnAddr = new InetSocketAddress("localhost", this.cluster.getNameNodePort());
        return new DFSClient(nnAddr, (Configuration)this.conf);
    }

    public void readAndCheckEOS(BlockReader reader, int length, boolean expectEof) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        for (int nRead = 0; nRead < length; nRead += n) {
            DFSClient.LOG.info("So far read " + nRead + " - going to read more.");
            n = reader.read(buf, 0, buf.length);
            Assertions.assertTrue((n > 0 ? 1 : 0) != 0);
        }
        if (expectEof) {
            DFSClient.LOG.info("Done reading, expect EOF for next read.");
            Assertions.assertEquals((int)-1, (int)reader.read(buf, 0, buf.length));
        }
    }

    public BlockReader getBlockReader(LocatedBlock testBlock, int offset, int lenToRead) throws IOException {
        return BlockReaderTestUtil.getBlockReader(this.cluster.getFileSystem(), testBlock, offset, lenToRead);
    }

    public static BlockReader getBlockReader(final DistributedFileSystem fs, LocatedBlock testBlock, int offset, long lenToRead) throws IOException {
        InetSocketAddress targetAddr = null;
        ExtendedBlock block = testBlock.getBlock();
        DatanodeInfoWithStorage[] nodes = testBlock.getLocations();
        targetAddr = NetUtils.createSocketAddr((String)nodes[0].getXferAddr());
        return new BlockReaderFactory(fs.getClient().getConf()).setInetSocketAddress(targetAddr).setBlock(block).setFileName(targetAddr.toString() + ":" + block.getBlockId()).setBlockToken(testBlock.getBlockToken()).setStartOffset((long)offset).setLength(lenToRead).setVerifyChecksum(true).setClientName("BlockReaderTestUtil").setDatanodeInfo((DatanodeInfo)nodes[0]).setClientCacheContext(ClientContext.getFromConf((Configuration)fs.getConf())).setCachingStrategy(CachingStrategy.newDefaultStrategy()).setConfiguration(fs.getConf()).setAllowShortCircuitLocalReads(true).setRemotePeerFactory(new RemotePeerFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Peer newConnectedPeer(InetSocketAddress addr, Token<BlockTokenIdentifier> blockToken, DatanodeID datanodeId) throws IOException {
                Peer peer = null;
                Socket sock = NetUtils.getDefaultSocketFactory((Configuration)fs.getConf()).createSocket();
                try {
                    sock.connect(addr, 60000);
                    sock.setSoTimeout(60000);
                    peer = DFSUtilClient.peerFromSocket((Socket)sock);
                }
                finally {
                    if (peer == null) {
                        IOUtils.closeStream((Closeable)sock);
                    }
                }
                return peer;
            }
        }).build();
    }

    public DataNode getDataNode(LocatedBlock testBlock) {
        DatanodeInfoWithStorage[] nodes = testBlock.getLocations();
        int ipcport = nodes[0].getIpcPort();
        return this.cluster.getDataNode(ipcport);
    }

    public static void enableHdfsCachingTracing() {
        BlockReaderTestUtil.enableTraceLog(CacheReplicationMonitor.class);
        BlockReaderTestUtil.enableTraceLog(CacheManager.class);
        BlockReaderTestUtil.enableTraceLog(FsDatasetCache.class);
    }

    public static void enableBlockReaderFactoryTracing() {
        BlockReaderTestUtil.enableTraceLog(BlockReaderFactory.class);
        BlockReaderTestUtil.enableTraceLog(ShortCircuitCache.class);
        BlockReaderTestUtil.enableTraceLog(ShortCircuitReplica.class);
        BlockReaderTestUtil.enableTraceLog(BlockReaderLocal.class);
    }

    public static void enableShortCircuitShmTracing() {
        BlockReaderTestUtil.enableTraceLog(DfsClientShmManager.class);
        BlockReaderTestUtil.enableTraceLog(ShortCircuitRegistry.class);
        BlockReaderTestUtil.enableTraceLog(ShortCircuitShm.class);
        BlockReaderTestUtil.enableTraceLog(DataNode.class);
    }

    private static void enableTraceLog(Class<?> clazz) {
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(clazz), (Level)Level.TRACE);
    }
}

