/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumFileSystem;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSeekBug {
    static final long seed = 3735928559L;
    static final int ONEMB = 0x100000;

    private void checkAndEraseData(byte[] actual, int from, byte[] expected, String message) {
        for (int idx = 0; idx < actual.length; ++idx) {
            Assertions.assertEquals((byte)actual[idx], (byte)expected[from + idx], (String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]));
            actual[idx] = 0;
        }
    }

    private void seekReadFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name, 4096);
        byte[] expected = new byte[0x100000];
        Random rand = new Random(3735928559L);
        rand.nextBytes(expected);
        byte[] actual = new byte[128];
        stm.read(actual, 0, actual.length);
        actual = new byte[100000];
        IOUtils.readFully((InputStream)stm, (byte[])actual, (int)0, (int)actual.length);
        this.checkAndEraseData(actual, 128, expected, "First Read Test");
        stm.seek(96036L);
        actual = new byte[128];
        IOUtils.readFully((InputStream)stm, (byte[])actual, (int)0, (int)actual.length);
        this.checkAndEraseData(actual, 96036, expected, "Seek Bug");
        stm.close();
    }

    private void smallReadSeek(FileSystem fileSys, Path name) throws IOException {
        if (fileSys instanceof ChecksumFileSystem) {
            fileSys = ((ChecksumFileSystem)fileSys).getRawFileSystem();
        }
        FSDataInputStream stmRaw = fileSys.open(name, 1);
        byte[] expected = new byte[0x100000];
        Random rand = new Random(3735928559L);
        rand.nextBytes(expected);
        byte[] actual = new byte[128];
        stmRaw.seek(100000L);
        stmRaw.read(actual, 0, actual.length);
        this.checkAndEraseData(actual, 100000, expected, "First Small Read Test");
        int newpos1 = 100132;
        stmRaw.seek((long)newpos1);
        stmRaw.read(actual, 0, actual.length);
        this.checkAndEraseData(actual, newpos1, expected, "Small Seek Bug 1");
        int newpos2 = newpos1 + 256;
        stmRaw.seek((long)newpos2);
        stmRaw.read(actual, 0, actual.length);
        this.checkAndEraseData(actual, newpos2, expected, "Small Seek Bug 2");
        stmRaw.close();
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assertions.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assertions.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeekBugDFS() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fileSys = cluster.getFileSystem();
        try {
            Path file1 = new Path("seektest.dat");
            DFSTestUtil.createFile((FileSystem)fileSys, file1, 0x100000, 0x100000L, fileSys.getDefaultBlockSize(file1), fileSys.getDefaultReplication(file1), 3735928559L);
            this.seekReadFile((FileSystem)fileSys, file1);
            this.smallReadSeek((FileSystem)fileSys, file1);
            this.cleanupFile((FileSystem)fileSys, file1);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    @Test
    public void testNegativeSeek() throws IOException {
        Assertions.assertThrows(IOException.class, () -> {
            HdfsConfiguration conf = new HdfsConfiguration();
            MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            try {
                Path seekFile = new Path("seekboundaries.dat");
                DFSTestUtil.createFile((FileSystem)fs, seekFile, 0x100000, 0x100000L, fs.getDefaultBlockSize(seekFile), fs.getDefaultReplication(seekFile), 3735928559L);
                FSDataInputStream stream = fs.open(seekFile);
                stream.seek(65536L);
                Assertions.assertEquals((long)65536L, (long)stream.getPos());
                stream.seek(-73L);
            }
            finally {
                fs.close();
                cluster.shutdown();
            }
        });
    }

    @Test
    public void testSeekPastFileSize() throws IOException {
        Assertions.assertThrows(IOException.class, () -> {
            HdfsConfiguration conf = new HdfsConfiguration();
            MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            try {
                Path seekFile = new Path("seekboundaries.dat");
                DFSTestUtil.createFile((FileSystem)fs, seekFile, 0x100000, 0x100000L, fs.getDefaultBlockSize(seekFile), fs.getDefaultReplication(seekFile), 3735928559L);
                FSDataInputStream stream = fs.open(seekFile);
                stream.seek(65536L);
                Assertions.assertEquals((long)65536L, (long)stream.getPos());
                stream.seek(0x300000L);
            }
            finally {
                fs.close();
                cluster.shutdown();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSeekBugLocalFS() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        try (LocalFileSystem fileSys = FileSystem.getLocal((Configuration)conf);){
            Path file1 = new Path(GenericTestUtils.getTempPath((String)"seektest.dat"));
            DFSTestUtil.createFile((FileSystem)fileSys, file1, 0x100000, 0x100000L, fileSys.getDefaultBlockSize(file1), fileSys.getDefaultReplication(file1), 3735928559L);
            this.seekReadFile((FileSystem)fileSys, file1);
            this.cleanupFile((FileSystem)fileSys, file1);
        }
    }
}

