/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsDataInputStream;
import org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class TestReadWhileWriting {
    private static final String DIR = "/" + TestReadWhileWriting.class.getSimpleName() + "/";
    private static final int BLOCK_SIZE = 8192;
    private static final long SOFT_LEASE_LIMIT = 500L;
    private static final long HARD_LEASE_LIMIT = 600000L;
    private static int userCount = 0;

    public TestReadWhileWriting() {
        GenericTestUtils.setLogLevel((Logger)FSNamesystem.LOG, (Level)Level.TRACE);
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.TRACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pipeline_02_03() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 1L);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        try {
            cluster.setLeasePeriod(500L, 600000L);
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path p = new Path(DIR, "file1");
            int half = 4096;
            FSDataOutputStream out = fs.create(p, true, fs.getConf().getInt("io.file.buffer.size", 4096), (short)3, 8192L);
            TestReadWhileWriting.write((OutputStream)out, 0, 4096);
            ((DFSOutputStream)out.getWrappedStream()).hflush();
            TestReadWhileWriting.checkFile(p, 4096, (Configuration)conf);
            AppendTestUtil.LOG.info("leasechecker.interruptAndJoin()");
            fs.dfs.getLeaseRenewer().interruptAndJoin();
            Thread.sleep(1000L);
            UserGroupInformation current = UserGroupInformation.getCurrentUser();
            UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)(current.getShortUserName() + "x"), (String[])new String[]{"supergroup"});
            DistributedFileSystem dfs = (DistributedFileSystem)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<DistributedFileSystem>((Configuration)conf){
                final /* synthetic */ Configuration val$conf;
                {
                    this.val$conf = configuration;
                }

                @Override
                public DistributedFileSystem run() throws Exception {
                    return (DistributedFileSystem)FileSystem.newInstance((Configuration)this.val$conf);
                }
            });
            FSDataOutputStream out2 = TestReadWhileWriting.append((FileSystem)dfs, p);
            TestReadWhileWriting.write((OutputStream)out2, 0, 4096);
            out2.close();
            TestReadWhileWriting.checkFile(p, 8192, (Configuration)conf);
        }
        finally {
            cluster.shutdown();
        }
    }

    private static FSDataOutputStream append(FileSystem fs, Path p) throws Exception {
        for (int i = 0; i < 10; ++i) {
            try {
                return fs.append(p);
            }
            catch (RemoteException re) {
                if (!re.getClassName().equals(RecoveryInProgressException.class.getName())) {
                    throw re;
                }
                AppendTestUtil.LOG.info("Will sleep and retry, i=" + i + ", p=" + p, (Throwable)re);
                Thread.sleep(1000L);
                continue;
            }
        }
        throw new IOException("Cannot append to " + p);
    }

    static void checkFile(Path p, int expectedsize, Configuration conf) throws IOException, InterruptedException {
        String username = UserGroupInformation.getCurrentUser().getShortUserName() + "_" + ++userCount;
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)username, (String[])new String[]{"supergroup"});
        FileSystem fs = DFSTestUtil.getFileSystemAs(ugi, conf);
        HdfsDataInputStream in = (HdfsDataInputStream)fs.open(p);
        Assertions.assertTrue((in.getVisibleLength() >= (long)expectedsize ? 1 : 0) != 0);
        for (int i = 0; i < expectedsize; ++i) {
            Assertions.assertEquals((byte)((byte)i), (byte)((byte)in.read()));
        }
        in.close();
    }

    private static void write(OutputStream out, int offset, int length) throws IOException {
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)(offset + i);
        }
        out.write(bytes);
    }
}

