/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.ReadStripedFileWithDecodingHelper;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=300L)
public class TestReadStripedFileWithDNFailure {
    static final Logger LOG = LoggerFactory.getLogger(TestReadStripedFileWithDNFailure.class);
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;
    private int fileLength;
    private int dnFailureNum;

    public static void setup() throws IOException {
        cluster = ReadStripedFileWithDecodingHelper.initializeCluster();
        dfs = cluster.getFileSystem();
    }

    @AfterAll
    public static void tearDown() throws IOException {
        ReadStripedFileWithDecodingHelper.tearDownCluster(cluster);
    }

    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (int fileLength : ReadStripedFileWithDecodingHelper.FILE_LENGTHS) {
            for (int i = 0; i < ReadStripedFileWithDecodingHelper.NUM_PARITY_UNITS; ++i) {
                params.add(new Object[]{fileLength, i + 1});
            }
        }
        return params;
    }

    public void initTestReadStripedFileWithDNFailure(int pFileLength, int pDnFailureNum) throws IOException {
        this.fileLength = this.fileLength;
        this.dnFailureNum = this.dnFailureNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"getParameters"})
    @ParameterizedTest
    public void testReadWithDNFailure(int pFileLength, int pDnFailureNum) throws Exception {
        try {
            this.initTestReadStripedFileWithDNFailure(pFileLength, pDnFailureNum);
            TestReadStripedFileWithDNFailure.setup();
            ReadStripedFileWithDecodingHelper.testReadWithDNFailure(cluster, dfs, this.fileLength, this.dnFailureNum);
        }
        catch (IOException ioe) {
            String fileType = this.fileLength < ReadStripedFileWithDecodingHelper.BLOCK_SIZE * ReadStripedFileWithDecodingHelper.NUM_DATA_UNITS ? "smallFile" : "largeFile";
            LOG.error("Failed to read file with DN failure: fileType = " + fileType + ", dnFailureNum = " + this.dnFailureNum);
        }
        finally {
            TestReadStripedFileWithDNFailure.tearDown();
        }
    }
}

