/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.TestQuota;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestQuotaAllowOwner {
    private static Configuration conf;
    private static MiniDFSCluster cluster;
    private static DistributedFileSystem dfs;

    @BeforeAll
    public static void setUpClass() throws Exception {
        conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 512L);
        conf.setBoolean("dfs.permissions.allow.owner.set.quota", true);
        TestQuotaAllowOwner.restartCluster();
    }

    @AfterAll
    public static void tearDownClass() {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
    }

    private static void restartCluster() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
        }
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        dfs = cluster.getFileSystem();
    }

    private void createDirssAndSetOwner(String parentDir, String subDir, String owner, String group) throws Exception {
        Path parentPath = new Path(parentDir);
        Assertions.assertTrue((boolean)dfs.mkdirs(parentPath));
        dfs.setOwner(parentPath, owner, group);
        Assertions.assertTrue((boolean)dfs.mkdirs(new Path(subDir)));
    }

    @Test
    public void testOwnerCanSetSubDirQuota() throws Exception {
        String userName = "user1";
        String groupName = "hadoop";
        String parentDir = "/parent_owner";
        String subDir = "/parent_owner/subdir";
        this.createDirssAndSetOwner("/parent_owner", "/parent_owner/subdir", "user1", "hadoop");
        DFSAdmin admin = new DFSAdmin(conf);
        String[] args = new String[]{"-setQuota", "10", "/parent_owner".toString()};
        TestQuota.runCommand(admin, args, false);
        args = new String[]{"-setSpaceQuota", "128", "/parent_owner".toString()};
        TestQuota.runCommand(admin, args, false);
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"hadoop"});
        ugi.doAs(() -> {
            Assertions.assertEquals((Object)"user1", (Object)UserGroupInformation.getCurrentUser().getShortUserName(), (String)"Not running as new user");
            DFSAdmin userAdmin = new DFSAdmin(conf);
            String[] args2 = new String[]{"-setQuota", "5", "/parent_owner/subdir"};
            TestQuota.runCommand(userAdmin, args2, false);
            args2 = new String[]{"-setSpaceQuota", "64", "/parent_owner/subdir"};
            TestQuota.runCommand(userAdmin, args2, false);
            ContentSummary c = dfs.getContentSummary(new Path("/parent_owner/subdir"));
            Assertions.assertEquals((long)5L, (long)c.getQuota(), (String)"Not same with setting quota");
            Assertions.assertEquals((long)64L, (long)c.getSpaceQuota(), (String)"Not same with setting space quota");
            args2 = new String[]{"-clrQuota", "/parent_owner/subdir"};
            TestQuota.runCommand(userAdmin, args2, false);
            args2 = new String[]{"-clrSpaceQuota", "/parent_owner/subdir"};
            TestQuota.runCommand(userAdmin, args2, false);
            c = dfs.getContentSummary(new Path("/parent_owner/subdir"));
            Assertions.assertEquals((long)-1L, (long)c.getQuota(), (String)"Not clean quota");
            Assertions.assertEquals((long)-1L, (long)c.getSpaceQuota(), (String)"Not clean space quota");
            return null;
        });
    }

    @Test
    public void testOwnerCanSetSubDirQuotaWithoutAdminDone() throws Exception {
        String userName = "user1";
        String groupName = "hadoop";
        String parentDir = "/parent_owner_without_Admin";
        String subDir = "/parent_owner_without_Admin/subdir";
        this.createDirssAndSetOwner("/parent_owner_without_Admin", "/parent_owner_without_Admin/subdir", "user1", "hadoop");
        UserGroupInformation ugi2 = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"hadoop"});
        ugi2.doAs(() -> {
            Assertions.assertEquals((Object)"user1", (Object)UserGroupInformation.getCurrentUser().getShortUserName(), (String)"Not running as new user");
            DFSAdmin userAdmin = new DFSAdmin(conf);
            String[] args2 = new String[]{"-setQuota", "5", "/parent_owner_without_Admin/subdir"};
            TestQuota.runCommand(userAdmin, args2, false);
            args2 = new String[]{"-setSpaceQuota", "64", "/parent_owner_without_Admin/subdir"};
            TestQuota.runCommand(userAdmin, args2, false);
            return null;
        });
    }

    @Test
    public void testOtherCanNotSetSubDirQuota() throws Exception {
        String userName = "user1";
        String groupName = "hadoop";
        String userOther = "otherUser";
        String groupOther = "otherGroup";
        String parentDir = "/parent_other_user";
        String subDir = "/parent_other_user/subdir";
        this.createDirssAndSetOwner("/parent_other_user", "/parent_other_user/subdir", "user1", "hadoop");
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"otherUser", (String[])new String[]{"otherGroup"});
        ugi.doAs(() -> {
            Assertions.assertEquals((Object)"otherUser", (Object)UserGroupInformation.getCurrentUser().getShortUserName(), (String)"Not running as new user");
            DFSAdmin userAdmin = new DFSAdmin(conf);
            String[] args2 = new String[]{"-setQuota", "5", "/parent_other_user/subdir".toString()};
            TestQuota.runCommand(userAdmin, args2, true);
            args2 = new String[]{"-setSpaceQuota", "64", "/parent_other_user/subdir".toString()};
            TestQuota.runCommand(userAdmin, args2, true);
            return null;
        });
    }

    @Test
    public void testOtherInSameGroupCanNotSetSubDirQuota() throws Exception {
        String userName = "user1";
        String groupName = "hadoop";
        String userOther = "otherUser";
        String parentDir = "/parent_other_user_in_same_group";
        String subDir = "/parent_other_user_in_same_group/subdir";
        this.createDirssAndSetOwner("/parent_other_user_in_same_group", "/parent_other_user_in_same_group/subdir", "user1", "hadoop");
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"otherUser", (String[])new String[]{"hadoop"});
        ugi.doAs(() -> {
            Assertions.assertEquals((Object)"otherUser", (Object)UserGroupInformation.getCurrentUser().getShortUserName(), (String)"Not running as new user");
            DFSAdmin userAdmin = new DFSAdmin(conf);
            String[] args2 = new String[]{"-setQuota", "5", "/parent_other_user_in_same_group/subdir".toString()};
            TestQuota.runCommand(userAdmin, args2, true);
            args2 = new String[]{"-setSpaceQuota", "64", "/parent_other_user_in_same_group/subdir".toString()};
            TestQuota.runCommand(userAdmin, args2, true);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOwnerCanNotSetIfNotEanbled() throws Exception {
        String userName = "user1";
        String groupName = "hadoop";
        String parentDir = "/parent_owner_without_Admin";
        String subDir = "/parent_owner_without_Admin/subdir";
        try {
            conf.setBoolean("dfs.permissions.allow.owner.set.quota", false);
            TestQuotaAllowOwner.restartCluster();
            this.createDirssAndSetOwner("/parent_owner_without_Admin", "/parent_owner_without_Admin/subdir", "user1", "hadoop");
            UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"user1", (String[])new String[]{"hadoop"});
            ugi.doAs(() -> {
                Assertions.assertEquals((Object)"user1", (Object)UserGroupInformation.getCurrentUser().getShortUserName(), (String)"Not running as new user");
                DFSAdmin userAdmin = new DFSAdmin(conf);
                String[] args2 = new String[]{"-setQuota", "5", "/parent_owner_without_Admin/subdir"};
                TestQuota.runCommand(userAdmin, args2, true);
                args2 = new String[]{"-setSpaceQuota", "64", "/parent_owner_without_Admin/subdir"};
                TestQuota.runCommand(userAdmin, args2, true);
                return null;
            });
        }
        finally {
            conf.setBoolean("dfs.permissions.allow.owner.set.quota", true);
            TestQuotaAllowOwner.restartCluster();
        }
    }
}

