/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockStoragePolicySpi;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockStoragePolicySuite;
import org.apache.hadoop.util.Sets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestHdfsAdmin {
    private static final Path TEST_PATH = new Path("/test");
    private static final short REPL = 1;
    private static final int SIZE = 128;
    private static final int OPEN_FILES_BATCH_SIZE = 5;
    private final Configuration conf = new Configuration();
    private MiniDFSCluster cluster;

    @BeforeEach
    public void setUpCluster() throws IOException {
        this.conf.setLong("dfs.namenode.list.openfiles.num.responses", 5L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(2).build();
        this.cluster.waitActive();
    }

    @AfterEach
    public void shutDownCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testHdfsAdminSetQuota() throws Exception {
        HdfsAdmin dfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        try (FileSystem fs = null;){
            fs = FileSystem.get((Configuration)this.conf);
            Assertions.assertTrue((boolean)fs.mkdirs(TEST_PATH));
            Assertions.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getQuota());
            Assertions.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getSpaceQuota());
            dfsAdmin.setSpaceQuota(TEST_PATH, 10L);
            Assertions.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getQuota());
            Assertions.assertEquals((long)10L, (long)fs.getContentSummary(TEST_PATH).getSpaceQuota());
            dfsAdmin.setQuota(TEST_PATH, 10L);
            Assertions.assertEquals((long)10L, (long)fs.getContentSummary(TEST_PATH).getQuota());
            Assertions.assertEquals((long)10L, (long)fs.getContentSummary(TEST_PATH).getSpaceQuota());
            dfsAdmin.clearSpaceQuota(TEST_PATH);
            Assertions.assertEquals((long)10L, (long)fs.getContentSummary(TEST_PATH).getQuota());
            Assertions.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getSpaceQuota());
            dfsAdmin.clearQuota(TEST_PATH);
            Assertions.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getQuota());
            Assertions.assertEquals((long)-1L, (long)fs.getContentSummary(TEST_PATH).getSpaceQuota());
        }
    }

    @Test
    public void testHdfsAdminWithBadUri() throws IOException, URISyntaxException {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HdfsAdmin(new URI("file:///bad-scheme"), this.conf));
    }

    @Test
    public void testHdfsAdminStoragePolicies() throws Exception {
        HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path foo = new Path("/foo");
        Path bar = new Path(foo, "bar");
        Path wow = new Path(bar, "wow");
        DFSTestUtil.createFile(fs, wow, 128L, (short)1, 0L);
        BlockStoragePolicySuite suite = BlockStoragePolicySuite.createDefaultSuite();
        BlockStoragePolicy warm = suite.getPolicy("WARM");
        BlockStoragePolicy cold = suite.getPolicy("COLD");
        BlockStoragePolicy hot = suite.getPolicy("HOT");
        hdfsAdmin.setStoragePolicy(foo, warm.getName());
        hdfsAdmin.setStoragePolicy(bar, cold.getName());
        hdfsAdmin.setStoragePolicy(wow, hot.getName());
        Assertions.assertEquals((Object)hdfsAdmin.getStoragePolicy(foo), (Object)warm);
        Assertions.assertEquals((Object)hdfsAdmin.getStoragePolicy(bar), (Object)cold);
        Assertions.assertEquals((Object)hdfsAdmin.getStoragePolicy(wow), (Object)hot);
        hdfsAdmin.unsetStoragePolicy(foo);
        hdfsAdmin.unsetStoragePolicy(bar);
        hdfsAdmin.unsetStoragePolicy(wow);
        Assertions.assertEquals((Object)hdfsAdmin.getStoragePolicy(foo), (Object)hot);
        Assertions.assertEquals((Object)hdfsAdmin.getStoragePolicy(bar), (Object)hot);
        Assertions.assertEquals((Object)hdfsAdmin.getStoragePolicy(wow), (Object)hot);
        HashSet<String> policyNamesSet1 = new HashSet<String>();
        for (BlockStoragePolicySpi policy : hdfsAdmin.getAllStoragePolicies()) {
            policyNamesSet1.add(policy.getName());
        }
        HashSet<String> policyNamesSet2 = new HashSet<String>();
        for (BlockStoragePolicy policy : suite.getAllPolicies()) {
            policyNamesSet2.add(policy.getName());
        }
        Assertions.assertTrue((boolean)Sets.difference(policyNamesSet1, policyNamesSet2).isEmpty());
        Assertions.assertTrue((boolean)Sets.difference(policyNamesSet2, policyNamesSet1).isEmpty());
    }

    private static String getKeyProviderURI() {
        FileSystemTestHelper helper = new FileSystemTestHelper();
        String testRoot = helper.getTestRootDir();
        File testRootDir = new File(testRoot).getAbsoluteFile();
        return "jceks://file" + new Path(testRootDir.toString(), "test.jks").toUri();
    }

    @Test
    public void testGetKeyProvider() throws IOException {
        HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        Assertions.assertNull((Object)hdfsAdmin.getKeyProvider(), (String)"should return null for an non-encrypted cluster");
        this.shutDownCluster();
        Configuration conf = new Configuration();
        conf.set("hadoop.security.key.provider.path", TestHdfsAdmin.getKeyProviderURI());
        this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        this.cluster.waitActive();
        hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)conf), conf);
        Assertions.assertNotNull((Object)hdfsAdmin.getKeyProvider(), (String)"should not return null for an encrypted cluster");
    }

    @Test
    @Timeout(value=120L)
    public void testListOpenFiles() throws IOException {
        HashSet<Path> closedFileSet = new HashSet<Path>();
        HashMap<Path, FSDataOutputStream> openFileMap = new HashMap<Path, FSDataOutputStream>();
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        this.verifyOpenFiles(closedFileSet, openFileMap);
        int numClosedFiles = 20;
        int numOpenFiles = 16;
        for (int i = 0; i < numClosedFiles; ++i) {
            Path filePath = new Path("/closed-file-" + i);
            DFSTestUtil.createFile(fs, filePath, 128L, (short)1, 0L);
            closedFileSet.add(filePath);
        }
        this.verifyOpenFiles(closedFileSet, openFileMap);
        this.verifyOpenFilesOld(closedFileSet, openFileMap);
        openFileMap.putAll(DFSTestUtil.createOpenFiles(fs, "open-file-1", numOpenFiles));
        this.verifyOpenFiles(closedFileSet, openFileMap);
        closedFileSet.addAll(DFSTestUtil.closeOpenFiles(openFileMap, openFileMap.size() / 2));
        this.verifyOpenFiles(closedFileSet, openFileMap);
        openFileMap.putAll(DFSTestUtil.createOpenFiles(fs, "open-file-2", 10));
        this.verifyOpenFiles(closedFileSet, openFileMap);
        while (openFileMap.size() > 0) {
            closedFileSet.addAll(DFSTestUtil.closeOpenFiles(openFileMap, 1));
            this.verifyOpenFiles(closedFileSet, openFileMap);
        }
    }

    private void verifyOpenFilesHelper(RemoteIterator<OpenFileEntry> openFilesRemoteItr, HashSet<Path> closedFiles, HashSet<Path> openFiles) throws IOException {
        while (openFilesRemoteItr.hasNext()) {
            String filePath = ((OpenFileEntry)openFilesRemoteItr.next()).getFilePath();
            Assertions.assertFalse((boolean)closedFiles.contains(new Path(filePath)), (String)(filePath + " should not be listed under open files!"));
            Assertions.assertTrue((boolean)openFiles.remove(new Path(filePath)), (String)(filePath + " is not listed under open files!"));
        }
    }

    private void verifyOpenFiles(HashSet<Path> closedFiles, HashMap<Path, FSDataOutputStream> openFileMap) throws IOException {
        HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        HashSet<Path> openFiles = new HashSet<Path>(openFileMap.keySet());
        RemoteIterator openFilesRemoteItr = hdfsAdmin.listOpenFiles(EnumSet.of(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES), "/");
        this.verifyOpenFilesHelper((RemoteIterator<OpenFileEntry>)openFilesRemoteItr, closedFiles, openFiles);
        Assertions.assertTrue((boolean)openFiles.isEmpty(), (String)"Not all open files are listed!");
    }

    private void verifyOpenFilesOld(HashSet<Path> closedFiles, HashMap<Path, FSDataOutputStream> openFileMap) throws IOException {
        HdfsAdmin hdfsAdmin = new HdfsAdmin(FileSystem.getDefaultUri((Configuration)this.conf), this.conf);
        HashSet<Path> openFiles = new HashSet<Path>(openFileMap.keySet());
        RemoteIterator openFilesRemoteItr = hdfsAdmin.listOpenFiles(EnumSet.of(OpenFilesIterator.OpenFilesType.ALL_OPEN_FILES));
        this.verifyOpenFilesHelper((RemoteIterator<OpenFileEntry>)openFilesRemoteItr, closedFiles, openFiles);
        Assertions.assertTrue((boolean)openFiles.isEmpty(), (String)"Not all open files are listed!");
    }
}

