/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHAAuxiliaryPort {
    @Test
    public void testHAAuxiliaryPort() throws Exception {
        Configuration conf = new Configuration();
        conf.set("dfs.namenode.rpc-address.auxiliary-ports", "0,0");
        conf.set("dfs.namenode.rpc-address.auxiliary-ports.ha-nn-uri-0.nn1", "9000,9001");
        conf.set("dfs.namenode.rpc-address.auxiliary-ports.ha-nn-uri-0.nn2", "9000,9001");
        conf.set("dfs.nameservices", "ha-nn-uri-0");
        conf.set("dfs.ha.namenodes.ha-nn-uri-0", "nn1,nn2");
        conf.setBoolean("fs.hdfs.impl.disable.cache", true);
        MiniDFSNNTopology topology = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf("ha-nn-uri-0").addNN(new MiniDFSNNTopology.NNConf("nn1")).addNN(new MiniDFSNNTopology.NNConf("nn2")));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(topology).numDataNodes(0).build();
        cluster.transitionToActive(0);
        cluster.waitActive();
        NameNode nn0 = cluster.getNameNode(0);
        NameNode nn1 = cluster.getNameNode(1);
        NameNodeRpcServer rpcServer0 = (NameNodeRpcServer)nn0.getRpcServer();
        InetSocketAddress server0RpcAddress = rpcServer0.getRpcAddress();
        Set auxAddrServer0 = rpcServer0.getAuxiliaryRpcAddresses();
        Assertions.assertEquals((int)2, (int)auxAddrServer0.size());
        NameNodeRpcServer rpcServer1 = (NameNodeRpcServer)nn1.getRpcServer();
        InetSocketAddress server1RpcAddress = rpcServer1.getRpcAddress();
        Set auxAddrServer1 = rpcServer1.getAuxiliaryRpcAddresses();
        Assertions.assertEquals((int)2, (int)auxAddrServer1.size());
        URI nn0URI = new URI("hdfs://localhost:" + server0RpcAddress.getPort());
        try (DFSClient client0 = new DFSClient(nn0URI, conf);){
            client0.mkdirs("/test", null, true);
            for (InetSocketAddress auxAddr : auxAddrServer0) {
                nn0URI = new URI("hdfs://localhost:" + auxAddr.getPort());
                DFSClient clientTmp = new DFSClient(nn0URI, conf);
                Throwable throwable = null;
                try {
                    Assertions.assertTrue((boolean)clientTmp.exists("/test"));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (clientTmp == null) continue;
                    if (throwable != null) {
                        try {
                            clientTmp.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    clientTmp.close();
                }
            }
        }
        cluster.shutdownNameNode(0);
        cluster.transitionToActive(1);
        URI nn1URI = new URI("hdfs://localhost:" + server1RpcAddress.getPort());
        DFSClient client1 = new DFSClient(nn1URI, conf);
        Object object = null;
        try {
            Assertions.assertTrue((boolean)client1.exists("/test"));
            for (InetSocketAddress auxAddr : auxAddrServer1) {
                nn1URI = new URI("hdfs://localhost:" + auxAddr.getPort());
                DFSClient clientTmp = new DFSClient(nn1URI, conf);
                Throwable throwable = null;
                try {
                    Assertions.assertTrue((boolean)client1.exists("/test"));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (clientTmp == null) continue;
                    if (throwable != null) {
                        try {
                            clientTmp.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    clientTmp.close();
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (client1 != null) {
                if (object != null) {
                    try {
                        client1.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    client1.close();
                }
            }
        }
    }
}

