/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.test.PathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFSInputChecker {
    static final long seed = 3735928559L;
    static final int BYTES_PER_SUM = 10;
    static final int BLOCK_SIZE = 20;
    static final int HALF_CHUNK_SIZE = 5;
    static final int FILE_SIZE = 39;
    static final short NUM_OF_DATANODES = 2;
    final byte[] expected = new byte[39];
    byte[] actual;
    FSDataInputStream stm;
    final Random rand = new Random(3735928559L);

    private void writeFile(FileSystem fileSys, Path name) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, new FsPermission(511), true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)2, 20L, null);
        stm.write(this.expected);
        stm.close();
    }

    private void checkAndEraseData(byte[] actual, int from, byte[] expected, String message) throws Exception {
        for (int idx = 0; idx < actual.length; ++idx) {
            Assertions.assertEquals((byte)actual[idx], (byte)expected[from + idx], (String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]));
            actual[idx] = 0;
        }
    }

    private void checkReadAndGetPos() throws Exception {
        int offset;
        this.actual = new byte[39];
        this.stm.seek(0L);
        for (offset = 0; offset < 30; offset += 10) {
            Assertions.assertEquals((long)this.stm.getPos(), (long)offset);
            this.stm.readFully(this.actual, offset, 10);
        }
        this.stm.readFully(this.actual, offset, 9);
        Assertions.assertEquals((long)this.stm.getPos(), (long)39L);
        this.checkAndEraseData(this.actual, 0, this.expected, "Read Sanity Test");
        this.stm.seek(0L);
        Assertions.assertEquals((long)this.stm.getPos(), (long)0L);
        this.stm.readFully(this.actual, 0, 5);
        Assertions.assertEquals((long)this.stm.getPos(), (long)5L);
        this.stm.readFully(this.actual, 5, 15);
        Assertions.assertEquals((long)this.stm.getPos(), (long)20L);
        this.stm.readFully(this.actual, 20, 15);
        Assertions.assertEquals((long)this.stm.getPos(), (long)35L);
        this.stm.readFully(this.actual, 35, 4);
        Assertions.assertEquals((long)this.stm.getPos(), (long)39L);
        this.checkAndEraseData(this.actual, 0, this.expected, "Read Sanity Test");
        this.stm.seek(0L);
        this.stm.readFully(this.actual, 0, 15);
        Assertions.assertEquals((long)this.stm.getPos(), (long)15L);
        this.stm.readFully(this.actual, 15, 10);
        Assertions.assertEquals((long)this.stm.getPos(), (long)25L);
        this.stm.readFully(this.actual, 25, 14);
        Assertions.assertEquals((long)this.stm.getPos(), (long)39L);
        this.checkAndEraseData(this.actual, 0, this.expected, "Read Sanity Test");
    }

    private void testSeek1(int offset) throws Exception {
        this.stm.seek((long)offset);
        Assertions.assertEquals((long)offset, (long)this.stm.getPos());
        this.stm.readFully(this.actual);
        this.checkAndEraseData(this.actual, offset, this.expected, "Read Sanity Test");
    }

    private void checkSeek() throws Exception {
        this.actual = new byte[5];
        this.testSeek1(0);
        this.testSeek1(10);
        this.testSeek1(20);
        this.testSeek1(25);
        this.testSeek1(5);
        this.testSeek1(2);
        this.testSeek1(7);
        this.actual = new byte[1];
        this.testSeek1(38);
        String errMsg = null;
        try {
            this.stm.seek(39L);
        }
        catch (IOException e) {
            errMsg = e.getMessage();
        }
        Assertions.assertTrue((errMsg == null ? 1 : 0) != 0);
    }

    private void testSkip1(int skippedBytes) throws Exception {
        long oldPos = this.stm.getPos();
        IOUtils.skipFully((InputStream)this.stm, (long)skippedBytes);
        long newPos = oldPos + (long)skippedBytes;
        Assertions.assertEquals((long)this.stm.getPos(), (long)newPos);
        this.stm.readFully(this.actual);
        this.checkAndEraseData(this.actual, (int)newPos, this.expected, "Read Sanity Test");
    }

    private void checkSkip() throws Exception {
        this.actual = new byte[5];
        this.stm.seek(0L);
        this.testSkip1(10);
        this.testSkip1(5);
        this.testSkip1(5);
        this.stm.seek(0L);
        this.testSkip1(6);
        this.testSkip1(10);
        this.testSkip1(5);
        this.stm.seek(0L);
        this.testSkip1(1);
        this.testSkip1(1);
        this.stm.seek(0L);
        this.actual = new byte[1];
        this.testSkip1(38);
        this.stm.seek(0L);
        IOUtils.skipFully((InputStream)this.stm, (long)39L);
        try {
            IOUtils.skipFully((InputStream)this.stm, (long)10L);
            Assertions.fail((String)"expected to get a PrematureEOFException");
        }
        catch (EOFException e) {
            Assertions.assertEquals((Object)e.getMessage(), (Object)"Premature EOF from inputStream after skipping 0 byte(s).");
        }
        this.stm.seek(0L);
        try {
            IOUtils.skipFully((InputStream)this.stm, (long)49L);
            Assertions.fail((String)"expected to get a PrematureEOFException");
        }
        catch (EOFException e) {
            Assertions.assertEquals((Object)e.getMessage(), (Object)"Premature EOF from inputStream after skipping 39 byte(s).");
        }
        this.stm.seek(10L);
        try {
            IOUtils.skipFully((InputStream)this.stm, (long)39L);
            Assertions.fail((String)"expected to get a PrematureEOFException");
        }
        catch (EOFException e) {
            Assertions.assertEquals((Object)e.getMessage(), (Object)"Premature EOF from inputStream after skipping 29 byte(s).");
        }
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assertions.assertTrue((boolean)fileSys.exists(name));
        fileSys.delete(name, true);
        Assertions.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testChecker(FileSystem fileSys, boolean readCS) throws Exception {
        Path file = new Path("try.dat");
        this.writeFile(fileSys, file);
        try {
            if (!readCS) {
                fileSys.setVerifyChecksum(false);
            }
            this.stm = fileSys.open(file);
            this.checkReadAndGetPos();
            this.checkSeek();
            this.checkSkip();
            Assertions.assertFalse((boolean)this.stm.markSupported());
            this.stm.close();
        }
        finally {
            if (!readCS) {
                fileSys.setVerifyChecksum(true);
            }
            this.cleanupFile(fileSys, file);
        }
    }

    private void testFileCorruption(LocalFileSystem fileSys) throws IOException {
        String dir = PathUtils.getTestDirName(this.getClass());
        Path file = new Path(dir + "/corruption-test.dat");
        Path crcFile = new Path(dir + "/.corruption-test.dat.crc");
        this.writeFile((FileSystem)fileSys, file);
        int fileLen = (int)fileSys.getFileStatus(file).getLen();
        byte[] buf = new byte[fileLen];
        FSDataInputStream in = fileSys.open(file);
        IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)buf.length);
        in.close();
        this.checkFileCorruption(fileSys, file, crcFile);
        fileSys.delete(file, true);
        this.writeFile((FileSystem)fileSys, file);
        this.checkFileCorruption(fileSys, file, file);
        fileSys.delete(file, true);
    }

    private void checkFileCorruption(LocalFileSystem fileSys, Path file, Path fileToCorrupt) throws IOException {
        int corruptFileLen;
        RandomAccessFile out = new RandomAccessFile(new File(fileToCorrupt.toString()), "rw");
        byte[] buf = new byte[(int)fileSys.getFileStatus(file).getLen()];
        Assertions.assertTrue((buf.length >= (corruptFileLen = (int)fileSys.getFileStatus(fileToCorrupt).getLen()) ? 1 : 0) != 0);
        this.rand.nextBytes(buf);
        out.seek(corruptFileLen / 2);
        out.write(buf, 0, corruptFileLen / 4);
        out.close();
        boolean gotException = false;
        FSDataInputStream in = fileSys.open(file);
        try {
            IOUtils.readFully((InputStream)in, (byte[])buf, (int)0, (int)buf.length);
        }
        catch (ChecksumException e) {
            gotException = true;
        }
        Assertions.assertTrue((boolean)gotException);
        in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFSInputChecker() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 20L);
        conf.setInt("dfs.bytes-per-checksum", 10);
        this.rand.nextBytes(this.expected);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fileSys = cluster.getFileSystem();
        try {
            this.testChecker((FileSystem)fileSys, true);
            this.testChecker((FileSystem)fileSys, false);
            this.testSeekAndRead((FileSystem)fileSys);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
        fileSys = FileSystem.getLocal((Configuration)conf);
        try {
            this.testChecker((FileSystem)fileSys, true);
            this.testChecker((FileSystem)fileSys, false);
            this.testFileCorruption((LocalFileSystem)fileSys);
            this.testSeekAndRead((FileSystem)fileSys);
        }
        finally {
            fileSys.close();
        }
    }

    private void testSeekAndRead(FileSystem fileSys) throws IOException {
        Path file = new Path("try.dat");
        this.writeFile(fileSys, file);
        this.stm = fileSys.open(file, fileSys.getConf().getInt("io.file.buffer.size", 4096));
        this.checkSeekAndRead();
        this.stm.close();
        this.cleanupFile(fileSys, file);
    }

    private void checkSeekAndRead() throws IOException {
        int position = 1;
        int len = 20 - position;
        this.readAndCompare(this.stm, position, len);
        position = 10;
        len = 10;
        this.readAndCompare(this.stm, position, len);
    }

    private void readAndCompare(FSDataInputStream in, int position, int len) throws IOException {
        byte[] b = new byte[len];
        in.seek((long)position);
        IOUtils.readFully((InputStream)in, (byte[])b, (int)0, (int)b.length);
        for (int i = 0; i < b.length; ++i) {
            Assertions.assertEquals((byte)this.expected[position + i], (byte)b[i]);
        }
    }
}

