/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientAdapter;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.datatransfer.TrustedChannelResolver;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.DataTransferSaslUtil;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferServer;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSecretManager;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TestEncryptedTransfer {
    private static final Logger LOG = LoggerFactory.getLogger(TestEncryptedTransfer.class);
    private static final String PLAIN_TEXT = "this is very secret plain text";
    private static final Path TEST_PATH = new Path("/non-encrypted-file");
    private MiniDFSCluster cluster;
    private Configuration conf;
    private FileSystem fs;
    String resolverClazz;

    public TestEncryptedTransfer() {
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(SaslDataTransferServer.class), (Level)Level.DEBUG);
        GenericTestUtils.setLogLevel((Logger)LoggerFactory.getLogger(DataTransferSaslUtil.class), (Level)Level.DEBUG);
        this.cluster = null;
        this.conf = null;
        this.fs = null;
    }

    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{null});
        params.add(new Object[]{"org.apache.hadoop.hdfs.TestEncryptedTransfer$TestTrustedChannelResolver"});
        return params;
    }

    private void setEncryptionConfigKeys() {
        this.conf.setBoolean("dfs.encrypt.data.transfer", true);
        this.conf.setBoolean("dfs.block.access.token.enable", true);
        if (this.resolverClazz != null) {
            this.conf.set("dfs.trustedchannel.resolver.class", this.resolverClazz);
        }
    }

    private static FileSystem getFileSystem(Configuration conf) throws IOException {
        Configuration localConf = new Configuration(conf);
        localConf.setBoolean("dfs.encrypt.data.transfer", false);
        localConf.unset("dfs.encrypt.data.transfer.algorithm");
        return FileSystem.get((Configuration)localConf);
    }

    public void initTestEncryptedTransfer(String pResolverClazz) throws IOException {
        this.resolverClazz = pResolverClazz;
        this.setup();
    }

    public void setup() throws IOException {
        this.conf = new Configuration();
    }

    @AfterEach
    public void teardown() throws IOException {
        if (this.fs != null) {
            this.fs.close();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private FileChecksum writeUnencryptedAndThenRestartEncryptedCluster() throws IOException {
        this.cluster = new MiniDFSCluster.Builder(this.conf).build();
        this.fs = TestEncryptedTransfer.getFileSystem(this.conf);
        TestEncryptedTransfer.writeTestDataToFile(this.fs);
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
        FileChecksum checksum = this.fs.getFileChecksum(TEST_PATH);
        this.fs.close();
        this.cluster.shutdown();
        this.setEncryptionConfigKeys();
        this.cluster = new MiniDFSCluster.Builder(this.conf).manageDataDfsDirs(false).manageNameDfsDirs(false).format(false).startupOption(HdfsServerConstants.StartupOption.REGULAR).build();
        this.fs = TestEncryptedTransfer.getFileSystem(this.conf);
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEncryptedRead(String algorithm, String cipherSuite, boolean matchLog, boolean readAfterRestart) throws IOException {
        this.conf.set("dfs.encrypt.data.transfer.algorithm", algorithm);
        this.conf.set("dfs.encrypt.data.transfer.cipher.suites", cipherSuite);
        FileChecksum checksum = this.writeUnencryptedAndThenRestartEncryptedCluster();
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(SaslDataTransferServer.class));
        GenericTestUtils.LogCapturer logs1 = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(DataTransferSaslUtil.class));
        try {
            Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
            Assertions.assertEquals((Object)checksum, (Object)this.fs.getFileChecksum(TEST_PATH));
        }
        finally {
            logs.stopCapturing();
            logs1.stopCapturing();
        }
        if (this.resolverClazz == null) {
            if (matchLog) {
                GenericTestUtils.assertMatches((String)logs.getOutput(), (String)"Server using cipher suite");
                GenericTestUtils.assertMatches((String)logs1.getOutput(), (String)"Creating IOStreamPair of CryptoInputStream and CryptoOutputStream.");
            } else {
                GenericTestUtils.assertDoesNotMatch((String)logs.getOutput(), (String)"Server using cipher suite");
                GenericTestUtils.assertDoesNotMatch((String)logs1.getOutput(), (String)"Creating IOStreamPair of CryptoInputStream and CryptoOutputStream.");
            }
        }
        if (readAfterRestart) {
            this.cluster.restartNameNode(new String[0]);
            this.fs = TestEncryptedTransfer.getFileSystem(this.conf);
            Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
            Assertions.assertEquals((Object)checksum, (Object)this.fs.getFileChecksum(TEST_PATH));
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testEncryptedReadDefaultAlgorithmCipherSuite(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.testEncryptedRead("", "", false, false);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testEncryptedReadWithRC4(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.testEncryptedRead("rc4", "", false, false);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testEncryptedReadWithAES(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.testEncryptedRead("", "AES/CTR/NoPadding", true, false);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testEncryptedReadAfterNameNodeRestart(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.testEncryptedRead("", "", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testClientThatDoesNotSupportEncryption(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.conf.setInt("dfs.client.retry.window.base", 10);
        this.writeUnencryptedAndThenRestartEncryptedCluster();
        DFSClient client = DFSClientAdapter.getDFSClient((DistributedFileSystem)this.fs);
        DFSClient spyClient = (DFSClient)Mockito.spy((Object)client);
        ((DFSClient)Mockito.doReturn((Object)false).when((Object)spyClient)).shouldEncryptData();
        DFSClientAdapter.setDFSClient((DistributedFileSystem)this.fs, spyClient);
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(DataNode.class));
        try {
            Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
            if (this.resolverClazz != null && !this.resolverClazz.endsWith("TestTrustedChannelResolver")) {
                Assertions.fail((String)"Should not have been able to read without encryption enabled.");
            }
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Could not obtain block:", (Throwable)ioe);
        }
        finally {
            logs.stopCapturing();
        }
        if (this.resolverClazz == null) {
            GenericTestUtils.assertMatches((String)logs.getOutput(), (String)"Failed to read expected encryption handshake from client at");
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testLongLivedReadClientAfterRestart(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        FileChecksum checksum = this.writeUnencryptedAndThenRestartEncryptedCluster();
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
        Assertions.assertEquals((Object)checksum, (Object)this.fs.getFileChecksum(TEST_PATH));
        this.cluster.restartNameNode(new String[0]);
        Assertions.assertTrue((boolean)this.cluster.restartDataNode(0));
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
        Assertions.assertEquals((Object)checksum, (Object)this.fs.getFileChecksum(TEST_PATH));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testLongLivedWriteClientAfterRestart(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.setEncryptionConfigKeys();
        this.cluster = new MiniDFSCluster.Builder(this.conf).build();
        this.fs = TestEncryptedTransfer.getFileSystem(this.conf);
        TestEncryptedTransfer.writeTestDataToFile(this.fs);
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
        this.cluster.restartNameNode(new String[0]);
        Assertions.assertTrue((boolean)this.cluster.restartDataNodes());
        this.cluster.waitActive();
        TestEncryptedTransfer.writeTestDataToFile(this.fs);
        Assertions.assertEquals((Object)"this is very secret plain textthis is very secret plain text", (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testLongLivedClient(String pResolverClazz) throws IOException, InterruptedException {
        this.initTestEncryptedTransfer(pResolverClazz);
        FileChecksum checksum = this.writeUnencryptedAndThenRestartEncryptedCluster();
        BlockTokenSecretManager btsm = this.cluster.getNamesystem().getBlockManager().getBlockTokenSecretManager();
        btsm.setKeyUpdateIntervalForTesting(2000L);
        btsm.setTokenLifetime(2000L);
        btsm.clearAllKeysForTesting();
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
        Assertions.assertEquals((Object)checksum, (Object)this.fs.getFileChecksum(TEST_PATH));
        LOG.info("Sleeping so that encryption keys expire...");
        Thread.sleep(15000L);
        LOG.info("Done sleeping.");
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
        Assertions.assertEquals((Object)checksum, (Object)this.fs.getFileChecksum(TEST_PATH));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testFileChecksumWithInvalidEncryptionKey(String pResolverClazz) throws IOException, InterruptedException, TimeoutException {
        this.initTestEncryptedTransfer(pResolverClazz);
        if (this.resolverClazz != null) {
            return;
        }
        this.setEncryptionConfigKeys();
        this.cluster = new MiniDFSCluster.Builder(this.conf).build();
        this.fs = TestEncryptedTransfer.getFileSystem(this.conf);
        DFSClient client = DFSClientAdapter.getDFSClient((DistributedFileSystem)this.fs);
        DFSClient spyClient = (DFSClient)Mockito.spy((Object)client);
        DFSClientAdapter.setDFSClient((DistributedFileSystem)this.fs, spyClient);
        TestEncryptedTransfer.writeTestDataToFile(this.fs);
        FileChecksum checksum = this.fs.getFileChecksum(TEST_PATH);
        BlockTokenSecretManager btsm = this.cluster.getNamesystem().getBlockManager().getBlockTokenSecretManager();
        btsm.setKeyUpdateIntervalForTesting(2000L);
        btsm.setTokenLifetime(2000L);
        btsm.clearAllKeysForTesting();
        LOG.info("Wait until encryption keys become invalid...");
        final DataEncryptionKey encryptionKey = spyClient.getEncryptionKey();
        ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
        for (final DataNode dn : dataNodes) {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return !dn.getBlockPoolTokenSecretManager().get(encryptionKey.blockPoolId).hasKey(encryptionKey.keyId);
                }
            }, (long)100L, (long)30000L);
        }
        LOG.info("The encryption key is invalid on all nodes now.");
        this.fs.getFileChecksum(TEST_PATH);
        Assertions.assertTrue((client.getEncryptionKey() == null ? 1 : 0) != 0);
        ((DFSClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).clearDataEncryptionKey();
        FileChecksum verifyChecksum = this.fs.getFileChecksum(TEST_PATH);
        Assertions.assertEquals((Object)checksum, (Object)verifyChecksum);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testLongLivedClientPipelineRecovery(String pResolverClazz) throws IOException, InterruptedException, TimeoutException {
        this.initTestEncryptedTransfer(pResolverClazz);
        if (this.resolverClazz != null) {
            return;
        }
        int numDataNodes = 4;
        this.setEncryptionConfigKeys();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(numDataNodes).build();
        this.fs = TestEncryptedTransfer.getFileSystem(this.conf);
        DFSClient client = DFSClientAdapter.getDFSClient((DistributedFileSystem)this.fs);
        DFSClient spyClient = (DFSClient)Mockito.spy((Object)client);
        DFSClientAdapter.setDFSClient((DistributedFileSystem)this.fs, spyClient);
        TestEncryptedTransfer.writeTestDataToFile(this.fs);
        BlockTokenSecretManager btsm = this.cluster.getNamesystem().getBlockManager().getBlockTokenSecretManager();
        btsm.setKeyUpdateIntervalForTesting(2000L);
        btsm.setTokenLifetime(2000L);
        btsm.clearAllKeysForTesting();
        LOG.info("Wait until encryption keys become invalid...");
        final DataEncryptionKey encryptionKey = spyClient.getEncryptionKey();
        ArrayList<DataNode> dataNodes = this.cluster.getDataNodes();
        for (final DataNode dn : dataNodes) {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return !dn.getBlockPoolTokenSecretManager().get(encryptionKey.blockPoolId).hasKey(encryptionKey.keyId);
                }
            }, (long)100L, (long)30000L);
        }
        LOG.info("The encryption key is invalid on all nodes now.");
        try (FSDataOutputStream out = this.fs.append(TEST_PATH);){
            DFSOutputStream dfstream = (DFSOutputStream)out.getWrappedStream();
            DatanodeInfo[] targets = dfstream.getPipeline();
            this.cluster.stopDataNode(targets[0].getXferAddr());
            out.write(PLAIN_TEXT.getBytes());
            out.hflush();
            Assertions.assertFalse((boolean)Arrays.asList(dfstream.getPipeline()).contains(targets[0]), (String)"The first datanode in the pipeline was not replaced.");
        }
        ((DFSClient)Mockito.verify((Object)spyClient, (VerificationMode)Mockito.times((int)1))).clearDataEncryptionKey();
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testEncryptedWriteWithOneDn(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.testEncryptedWrite(1);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testEncryptedWriteWithTwoDns(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.testEncryptedWrite(2);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testEncryptedWriteWithMultipleDns(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.testEncryptedWrite(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEncryptedWrite(int numDns) throws IOException {
        this.setEncryptionConfigKeys();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(numDns).build();
        this.fs = TestEncryptedTransfer.getFileSystem(this.conf);
        GenericTestUtils.LogCapturer logs = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(SaslDataTransferServer.class));
        GenericTestUtils.LogCapturer logs1 = GenericTestUtils.LogCapturer.captureLogs((Logger)LoggerFactory.getLogger(DataTransferSaslUtil.class));
        try {
            TestEncryptedTransfer.writeTestDataToFile(this.fs);
        }
        finally {
            logs.stopCapturing();
            logs1.stopCapturing();
        }
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
        if (this.resolverClazz == null) {
            GenericTestUtils.assertDoesNotMatch((String)logs.getOutput(), (String)"Server using cipher suite");
            GenericTestUtils.assertDoesNotMatch((String)logs1.getOutput(), (String)"Creating IOStreamPair of CryptoInputStream and CryptoOutputStream.");
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testEncryptedAppend(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.setEncryptionConfigKeys();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        this.fs = TestEncryptedTransfer.getFileSystem(this.conf);
        TestEncryptedTransfer.writeTestDataToFile(this.fs);
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
        TestEncryptedTransfer.writeTestDataToFile(this.fs);
        Assertions.assertEquals((Object)"this is very secret plain textthis is very secret plain text", (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testEncryptedAppendRequiringBlockTransfer(String pResolverClazz) throws IOException {
        this.initTestEncryptedTransfer(pResolverClazz);
        this.setEncryptionConfigKeys();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(4).build();
        this.fs = TestEncryptedTransfer.getFileSystem(this.conf);
        TestEncryptedTransfer.writeTestDataToFile(this.fs);
        Assertions.assertEquals((Object)PLAIN_TEXT, (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
        FSDataInputStream in = this.fs.open(TEST_PATH);
        List<LocatedBlock> locatedBlocks = DFSTestUtil.getAllBlocks(in);
        in.close();
        Assertions.assertEquals((int)1, (int)locatedBlocks.size());
        Assertions.assertEquals((int)3, (int)locatedBlocks.get(0).getLocations().length);
        DataNode dn = this.cluster.getDataNode(locatedBlocks.get(0).getLocations()[0].getIpcPort());
        dn.shutdown();
        TestEncryptedTransfer.writeTestDataToFile(this.fs);
        Assertions.assertEquals((Object)"this is very secret plain textthis is very secret plain text", (Object)DFSTestUtil.readFile(this.fs, TEST_PATH));
    }

    private static void writeTestDataToFile(FileSystem fs) throws IOException {
        FSDataOutputStream out = null;
        out = !fs.exists(TEST_PATH) ? fs.create(TEST_PATH) : fs.append(TEST_PATH);
        out.write(PLAIN_TEXT.getBytes());
        out.close();
    }

    static class TestTrustedChannelResolver
    extends TrustedChannelResolver {
        TestTrustedChannelResolver() {
        }

        public boolean isTrusted() {
            return true;
        }

        public boolean isTrusted(InetAddress peerAddress) {
            return true;
        }
    }
}

