/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDeprecatedKeys {
    @Test
    public void testDeprecatedKeys() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("topology.script.file.name", "xyz");
        String scriptFile = conf.get("net.topology.script.file.name");
        Assertions.assertTrue((boolean)scriptFile.equals("xyz"));
        conf.setInt("dfs.replication.interval", 1);
        int redundancyInterval = conf.getInt("dfs.namenode.redundancy.interval.seconds", 3);
        Assertions.assertTrue((redundancyInterval == 1 ? 1 : 0) != 0);
        int repInterval = conf.getInt("dfs.replication.interval", 3);
        Assertions.assertTrue((repInterval == 1 ? 1 : 0) != 0);
        repInterval = conf.getInt("dfs.namenode.replication.interval", 3);
        Assertions.assertTrue((repInterval == 1 ? 1 : 0) != 0);
        conf.setBoolean("dfs.replication.considerLoad", false);
        Assertions.assertFalse((boolean)conf.getBoolean("dfs.namenode.redundancy.considerLoad", true));
        Assertions.assertFalse((boolean)conf.getBoolean("dfs.replication.considerLoad", true));
        conf.setDouble("dfs.namenode.replication.considerLoad.factor", 5.0);
        Assertions.assertTrue((5.0 == conf.getDouble("dfs.namenode.redundancy.considerLoad.factor", 2.0) ? 1 : 0) != 0);
        Assertions.assertTrue((5.0 == conf.getDouble("dfs.namenode.replication.considerLoad.factor", 2.0) ? 1 : 0) != 0);
    }
}

