/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.security.token.block.InvalidBlockTokenException;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.log4j.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;

public class TestDFSInputStream {
    private void testSkipInner(MiniDFSCluster cluster) throws IOException {
        DistributedFileSystem fs = cluster.getFileSystem();
        DFSClient client = fs.dfs;
        Path file = new Path("/testfile");
        int fileLength = 0x400000;
        byte[] fileContent = new byte[fileLength];
        for (int i = 0; i < fileLength; ++i) {
            fileContent[i] = (byte)(i % 133);
        }
        FSDataOutputStream fout = fs.create(file);
        fout.write(fileContent);
        fout.close();
        Random random = new Random();
        for (int i = 3; i < 18; ++i) {
            DFSInputStream fin = client.open("/testfile");
            for (long pos = 0L; pos < (long)fileLength; ++pos) {
                long skip = random.nextInt(1 << i) + 1;
                long skipped = fin.skip(skip);
                if (pos + skip >= (long)fileLength) {
                    Assertions.assertEquals((long)fileLength, (long)(pos + skipped));
                    break;
                }
                Assertions.assertEquals((long)skip, (long)skipped);
                int data = fin.read();
                Assertions.assertEquals((long)((pos += skipped) % 133L), (long)data);
            }
            fin.close();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSkipWithRemoteBlockReader() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            this.testSkipInner(cluster);
        }
        finally {
            cluster.shutdown();
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSkipWithRemoteBlockReader2() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            this.testSkipInner(cluster);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSkipWithLocalBlockReader() throws IOException {
        Assumptions.assumeTrue((DomainSocket.getLoadingFailureReason() == null ? 1 : 0) != 0);
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        DomainSocket.disableBindPathValidation();
        Configuration conf = new Configuration();
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "TestShortCircuitLocalRead._PORT.sock").getAbsolutePath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        try {
            DFSInputStream.tcpReadsDisabledForTesting = true;
            this.testSkipInner(cluster);
        }
        finally {
            DFSInputStream.tcpReadsDisabledForTesting = false;
            cluster.shutdown();
            sockDir.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSeekToNewSource() throws IOException {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path path = new Path("/testfile");
        DFSTestUtil.createFile((FileSystem)fs, path, 1024L, (short)3, 0L);
        DFSInputStream fin = fs.dfs.open("/testfile");
        try {
            fin.seekToNewSource(100L);
            Assertions.assertEquals((long)100L, (long)fin.getPos());
            DatanodeInfo firstNode = fin.getCurrentDatanode();
            Assertions.assertNotNull((Object)firstNode);
            fin.seekToNewSource(100L);
            Assertions.assertEquals((long)100L, (long)fin.getPos());
            Assertions.assertFalse((boolean)firstNode.equals((Object)fin.getCurrentDatanode()));
        }
        finally {
            fin.close();
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testOpenInfo() throws IOException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.client.retry.times.get-last-block-length", 0);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            int chunkSize = 512;
            Random r = new Random(12345L);
            byte[] data = new byte[chunkSize];
            r.nextBytes(data);
            Path file = new Path("/testfile");
            try (FSDataOutputStream fout = fs.create(file);){
                fout.write(data);
            }
            DfsClientConf dcconf = new DfsClientConf(conf);
            int retryTimesForGetLastBlockLength = dcconf.getRetryTimesForGetLastBlockLength();
            Assertions.assertEquals((int)0, (int)retryTimesForGetLastBlockLength);
            try (DFSInputStream fin = fs.dfs.open("/testfile");){
                long flen = fin.getFileLength();
                Assertions.assertEquals((long)chunkSize, (long)flen);
                long lastBlockBeingWrittenLength = fin.getlastBlockBeingWrittenLengthForTesting();
                Assertions.assertEquals((long)0L, (long)lastBlockBeingWrittenLength);
            }
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullCheckSumWhenDNRestarted() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        conf.set("dfs.checksum.type", "NULL");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(2).build();
        cluster.waitActive();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            int chunkSize = 512;
            Random r = new Random(12345L);
            byte[] data = new byte[chunkSize];
            r.nextBytes(data);
            Path file = new Path("/testfile");
            try (FSDataOutputStream fout = fs.create(file);){
                fout.write(data);
                fout.hflush();
                cluster.restartDataNode(0, true, true);
            }
            Thread.sleep(1000L);
            ArrayList live = new ArrayList();
            cluster.getNameNode().getNamesystem().getBlockManager().getDatanodeManager().fetchDatanodes(live, null, false);
            Assertions.assertTrue((live.size() == 2 ? 1 : 0) != 0, (String)"DN start should be success and live dn should be 2");
            Assertions.assertTrue((fs.getFileStatus(file).getLen() == (long)chunkSize ? 1 : 0) != 0, (String)("File size should be " + chunkSize));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWithPreferredCachingReplica() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.client.read.use.cache.priority", true);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = null;
        Path filePath = new Path("/testReadPreferredCachingReplica");
        try {
            fs = cluster.getFileSystem();
            FSDataOutputStream out = fs.create(filePath, true, 4096, (short)3, 512L);
            DFSInputStream dfsInputStream = (DFSInputStream)fs.open(filePath).getWrappedStream();
            LocatedBlock lb = (LocatedBlock)Mockito.mock(LocatedBlock.class);
            Mockito.when((Object)lb.getCachedLocations()).thenReturn((Object)DatanodeInfo.EMPTY_ARRAY);
            DatanodeID nodeId = new DatanodeID("localhost", "localhost", "dn0", 1111, 1112, 1113, 1114);
            DatanodeDescriptor dnInfo = new DatanodeDescriptor(nodeId);
            Mockito.when((Object)lb.getCachedLocations()).thenReturn((Object)new DatanodeInfo[]{dnInfo});
            DatanodeInfo retDNInfo = dfsInputStream.getBestNodeDNAddrPair((LocatedBlock)lb, null).info;
            Assertions.assertEquals((Object)dnInfo, (Object)retDNInfo);
        }
        finally {
            fs.delete(filePath, true);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadWithoutPreferredCachingReplica() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.client.read.use.cache.priority", false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = null;
        Path filePath = new Path("/testReadWithoutPreferredCachingReplica");
        try {
            fs = cluster.getFileSystem();
            FSDataOutputStream out = fs.create(filePath, true, 4096, (short)3, 512L);
            DFSInputStream dfsInputStream = (DFSInputStream)fs.open(filePath).getWrappedStream();
            LocatedBlock lb = (LocatedBlock)Mockito.mock(LocatedBlock.class);
            Mockito.when((Object)lb.getCachedLocations()).thenReturn((Object)DatanodeInfo.EMPTY_ARRAY);
            DatanodeID nodeId = new DatanodeID("localhost", "localhost", "dn0", 1111, 1112, 1113, 1114);
            DatanodeDescriptor dnInfo = new DatanodeDescriptor(nodeId);
            DatanodeInfoWithStorage dnInfoStorage = new DatanodeInfoWithStorage((DatanodeInfo)dnInfo, "DISK", StorageType.DISK);
            Mockito.when((Object)lb.getLocations()).thenReturn((Object)new DatanodeInfoWithStorage[]{dnInfoStorage});
            DatanodeInfo retDNInfo = dfsInputStream.getBestNodeDNAddrPair((LocatedBlock)lb, null).info;
            Assertions.assertEquals((Object)dnInfo, (Object)retDNInfo);
        }
        finally {
            fs.delete(filePath, true);
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateBlockReaderWhenInvalidBlockTokenException() throws IOException, InterruptedException, TimeoutException {
        GenericTestUtils.setLogLevel((Logger)DFSClient.LOG, (Level)Level.DEBUG);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 65536L);
        conf.setInt("dfs.client-write-packet-size", 516);
        DFSClientFaultInjector oldFaultInjector = DFSClientFaultInjector.get();
        FSDataOutputStream out = null;
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            String file = "/testfile";
            Path path = new Path(file);
            out = fs.create(path, (short)3);
            int bufferLen = 5120;
            byte[] toWrite = new byte[bufferLen];
            Random rb = new Random(0L);
            rb.nextBytes(toWrite);
            out.write(toWrite, 0, bufferLen);
            GenericTestUtils.waitFor(() -> {
                try {
                    return fs.getFileBlockLocations(path, 0L, (long)bufferLen).length == 1;
                }
                catch (IOException e) {
                    return false;
                }
            }, (long)100L, (long)10000L);
            DFSClientFaultInjector.set((DFSClientFaultInjector)((DFSClientFaultInjector)Mockito.mock(DFSClientFaultInjector.class)));
            DFSClientFaultInjector injector = DFSClientFaultInjector.get();
            final AtomicInteger count = new AtomicInteger(0);
            ((DFSClientFaultInjector)Mockito.doAnswer((Answer)new Answer<Void>(){

                public Void answer(InvocationOnMock invocation) throws Throwable {
                    if (count.getAndIncrement() == 0) {
                        throw new InvalidBlockTokenException("Mock InvalidBlockTokenException");
                    }
                    return null;
                }
            }).when((Object)injector)).failCreateBlockReader();
            try (DFSInputStream in = new DFSInputStream(fs.getClient(), file, false, null);){
                int bufLen = 1024;
                byte[] buf = new byte[bufLen];
                in.seek(1024L);
                int read = in.read(buf, 0, bufLen);
                Assertions.assertEquals((int)1024, (int)read);
            }
        }
        catch (Throwable throwable) {
            DFSClientFaultInjector.set((DFSClientFaultInjector)oldFaultInjector);
            IOUtils.closeStream(out);
            throw throwable;
        }
        DFSClientFaultInjector.set((DFSClientFaultInjector)oldFaultInjector);
        IOUtils.closeStream((Closeable)out);
    }
}

