/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDFSAddressConfig {
    @Test
    public void testDFSAddressConfig() throws IOException {
        MiniDFSCluster.DataNodeProperties dnp;
        int i;
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        cluster.waitActive();
        ArrayList<DataNode> dns = cluster.getDataNodes();
        DataNode dn = dns.get(0);
        String selfSocketAddr = dn.getXferAddress().toString();
        System.out.println("DN Self Socket Addr == " + selfSocketAddr);
        Assertions.assertTrue((boolean)selfSocketAddr.contains("/127.0.0.1:"));
        for (i = 0; i < dns.size(); ++i) {
            dnp = cluster.stopDataNode(i);
            Assertions.assertNotNull((Object)dnp, (String)"Should have been able to stop simulated datanode");
        }
        conf.unset("dfs.datanode.address");
        conf.unset("dfs.datanode.http.address");
        conf.unset("dfs.datanode.ipc.address");
        cluster.startDataNodes((Configuration)conf, 1, true, HdfsServerConstants.StartupOption.REGULAR, null, null, null, false, true);
        dns = cluster.getDataNodes();
        dn = dns.get(0);
        selfSocketAddr = dn.getXferAddress().toString();
        System.out.println("DN Self Socket Addr == " + selfSocketAddr);
        Assertions.assertTrue((boolean)selfSocketAddr.contains("/127.0.0.1:"));
        for (i = 0; i < dns.size(); ++i) {
            dnp = cluster.stopDataNode(i);
            Assertions.assertNotNull((Object)dnp, (String)"Should have been able to stop simulated datanode");
        }
        conf.set("dfs.datanode.address", "0.0.0.0:0");
        conf.set("dfs.datanode.http.address", "0.0.0.0:0");
        conf.set("dfs.datanode.ipc.address", "0.0.0.0:0");
        cluster.startDataNodes((Configuration)conf, 1, true, HdfsServerConstants.StartupOption.REGULAR, null, null, null, false, true);
        dns = cluster.getDataNodes();
        dn = dns.get(0);
        selfSocketAddr = dn.getXferAddress().toString();
        System.out.println("DN Self Socket Addr == " + selfSocketAddr);
        Assertions.assertTrue((boolean)selfSocketAddr.contains("/0.0.0.0:"));
        cluster.shutdown();
    }
}

