/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslDataTransferTestCase;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.security.TestPermission;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockTokenWrappingQOP
extends SaslDataTransferTestCase {
    public static final Logger LOG = LoggerFactory.getLogger(TestPermission.class);
    private HdfsConfiguration conf;
    private MiniDFSCluster cluster;
    private DistributedFileSystem dfs;
    private String configKey;
    private String qopValue;

    public static Collection<Object[]> qopSettings() {
        return Arrays.asList({"privacy", "auth-conf"}, {"integrity", "auth-int"}, {"authentication", "auth"});
    }

    public void initTestBlockTokenWrappingQOP(String pconfigKey, String pqopValue) throws Exception {
        this.configKey = pconfigKey;
        this.qopValue = pqopValue;
        this.setup();
    }

    public void setup() throws Exception {
        this.conf = this.createSecureConfig(this.configKey);
        this.conf.set("dfs.namenode.rpc-address.auxiliary-ports", "12000");
        this.conf.set("dfs.namenode.servicerpc-address", "localhost:9020");
        this.conf.set("hadoop.security.saslproperties.resolver.class", "org.apache.hadoop.security.IngressPortBasedResolver");
        this.conf.set("ingress.port.sasl.configured.ports", "12000");
        this.conf.set("ingress.port.sasl.prop.12000", this.configKey);
        this.conf.setBoolean("dfs.block.access.token.enable", true);
        this.conf.setBoolean("dfs.namenode.send.qop.enabled", true);
        this.conf.set("hadoop.rpc.protection", this.configKey);
        this.cluster = null;
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        HdfsConfiguration clientConf = new HdfsConfiguration((Configuration)this.conf);
        clientConf.unset("hadoop.security.saslproperties.resolver.class");
        URI currentURI = this.cluster.getURI();
        URI uriAuxiliary = new URI(currentURI.getScheme() + "://" + currentURI.getHost() + ":12000");
        this.dfs = (DistributedFileSystem)FileSystem.get((URI)uriAuxiliary, (Configuration)this.conf);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    @MethodSource(value={"qopSettings"})
    @ParameterizedTest
    public void testAddBlockWrappingQOP(String pconfigKey, String pqopValue) throws Exception {
        this.initTestBlockTokenWrappingQOP(pconfigKey, pqopValue);
        String src = "/testAddBlockWrappingQOP";
        Path path = new Path("/testAddBlockWrappingQOP");
        this.dfs.create(path);
        DFSClient client = this.dfs.getClient();
        String clientName = client.getClientName();
        LocatedBlock lb = client.namenode.addBlock("/testAddBlockWrappingQOP", clientName, null, null, 0L, null, null);
        byte[] secret = ((BlockTokenIdentifier)lb.getBlockToken().decodeIdentifier()).getHandshakeMsg();
        Assertions.assertEquals((Object)this.qopValue, (Object)new String(secret));
    }

    @MethodSource(value={"qopSettings"})
    @ParameterizedTest
    public void testAppendWrappingQOP(String pconfigKey, String pqopValue) throws Exception {
        this.initTestBlockTokenWrappingQOP(pconfigKey, pqopValue);
        String src = "/testAppendWrappingQOP";
        Path path = new Path("/testAppendWrappingQOP");
        FSDataOutputStream out = this.dfs.create(path);
        out.write(0);
        out.close();
        DFSClient client = this.dfs.getClient();
        String clientName = client.getClientName();
        LastBlockWithStatus lastBlock = client.namenode.append("/testAppendWrappingQOP", clientName, new EnumSetWritable(EnumSet.of(CreateFlag.APPEND)));
        byte[] secret = ((BlockTokenIdentifier)lastBlock.getLastBlock().getBlockToken().decodeIdentifier()).getHandshakeMsg();
        Assertions.assertEquals((Object)this.qopValue, (Object)new String(secret));
    }

    @MethodSource(value={"qopSettings"})
    @ParameterizedTest
    public void testGetBlockLocationWrappingQOP(String pconfigKey, String pqopValue) throws Exception {
        this.initTestBlockTokenWrappingQOP(pconfigKey, pqopValue);
        String src = "/testGetBlockLocationWrappingQOP";
        Path path = new Path("/testGetBlockLocationWrappingQOP");
        FSDataOutputStream out = this.dfs.create(path);
        out.write(0);
        out.close();
        FileStatus status = this.dfs.getFileStatus(path);
        DFSClient client = this.dfs.getClient();
        LocatedBlocks lbs = client.namenode.getBlockLocations("/testGetBlockLocationWrappingQOP", 0L, status.getLen());
        Assertions.assertTrue((lbs.getLocatedBlocks().size() > 0 ? 1 : 0) != 0);
        for (LocatedBlock lb : lbs.getLocatedBlocks()) {
            byte[] secret = ((BlockTokenIdentifier)lb.getBlockToken().decodeIdentifier()).getHandshakeMsg();
            Assertions.assertEquals((Object)this.qopValue, (Object)new String(secret));
        }
    }
}

