/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.BlockMissingException;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBlockMissingException {
    static final Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hdfs.TestBlockMissing");
    static final int NUM_DATANODES = 3;
    Configuration conf;
    MiniDFSCluster dfs = null;
    DistributedFileSystem fileSys = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlockMissingException() throws Exception {
        LOG.info("Test testBlockMissingException started.");
        long blockSize = 1024L;
        int numBlocks = 4;
        this.conf = new HdfsConfiguration();
        this.conf.setInt("dfs.client.retry.window.base", 10);
        try {
            this.dfs = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
            this.dfs.waitActive();
            this.fileSys = this.dfs.getFileSystem();
            Path file1 = new Path("/user/dhruba/raidtest/file1");
            this.createOldFile((FileSystem)this.fileSys, file1, 1, numBlocks, blockSize);
            LocatedBlocks locations = null;
            locations = this.fileSys.dfs.getNamenode().getBlockLocations(file1.toString(), 0L, (long)numBlocks * blockSize);
            LOG.info("Remove first block of file");
            this.dfs.corruptBlockOnDataNodesByDeletingBlockFile(locations.get(0).getBlock());
            this.validateFile((FileSystem)this.fileSys, file1);
        }
        finally {
            if (this.fileSys != null) {
                this.fileSys.close();
            }
            if (this.dfs != null) {
                this.dfs.shutdown();
            }
        }
        LOG.info("Test testBlockMissingException completed.");
    }

    private void createOldFile(FileSystem fileSys, Path name, int repl, int numBlocks, long blocksize) throws IOException {
        FSDataOutputStream stm = fileSys.create(name, true, fileSys.getConf().getInt("io.file.buffer.size", 4096), (short)repl, blocksize);
        byte[] b = new byte[(int)blocksize];
        for (int i = 0; i < numBlocks; ++i) {
            stm.write(b);
        }
        stm.close();
    }

    private void validateFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name);
        byte[] b = new byte[4192];
        int num = 0;
        boolean gotException = false;
        try {
            while (num >= 0 && (num = stm.read(b)) >= 0) {
            }
        }
        catch (BlockMissingException e) {
            gotException = true;
        }
        stm.close();
        Assertions.assertTrue((boolean)gotException, (String)"Expected BlockMissingException ");
    }
}

