/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestViewFsWithAcls {
    private static MiniDFSCluster cluster;
    private static Configuration clusterConf;
    private static FileContext fc;
    private static FileContext fc2;
    private FileContext fcView;
    private FileContext fcTarget;
    private FileContext fcTarget2;
    private Configuration fsViewConf;
    private Path targetTestRoot;
    private Path targetTestRoot2;
    private Path mountOnNn1;
    private Path mountOnNn2;
    private FileContextTestHelper fileContextTestHelper = new FileContextTestHelper("/tmp/TestViewFsWithAcls");

    @BeforeAll
    public static void clusterSetupAtBeginning() throws IOException {
        clusterConf.setBoolean("dfs.namenode.acls.enabled", true);
        cluster = new MiniDFSCluster.Builder(clusterConf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(2).build();
        cluster.waitClusterUp();
        fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)clusterConf);
        fc2 = FileContext.getFileContext((URI)cluster.getURI(1), (Configuration)clusterConf);
    }

    @AfterAll
    public static void ClusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.fcTarget = fc;
        this.fcTarget2 = fc2;
        this.targetTestRoot = this.fileContextTestHelper.getAbsoluteTestRootPath(fc);
        this.targetTestRoot2 = this.fileContextTestHelper.getAbsoluteTestRootPath(fc2);
        this.fcTarget.delete(this.targetTestRoot, true);
        this.fcTarget2.delete(this.targetTestRoot2, true);
        this.fcTarget.mkdir(this.targetTestRoot, new FsPermission(488), true);
        this.fcTarget2.mkdir(this.targetTestRoot2, new FsPermission(488), true);
        this.fsViewConf = ViewFileSystemTestSetup.createConfig();
        this.setupMountPoints();
        this.fcView = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)this.fsViewConf);
    }

    private void setupMountPoints() {
        this.mountOnNn1 = new Path("/mountOnNn1");
        this.mountOnNn2 = new Path("/mountOnNn2");
        ConfigUtil.addLink((Configuration)this.fsViewConf, (String)this.mountOnNn1.toString(), (URI)this.targetTestRoot.toUri());
        ConfigUtil.addLink((Configuration)this.fsViewConf, (String)this.mountOnNn2.toString(), (URI)this.targetTestRoot2.toUri());
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.fcTarget.delete(this.fileContextTestHelper.getTestRootPath(this.fcTarget), true);
        this.fcTarget2.delete(this.fileContextTestHelper.getTestRootPath(this.fcTarget2), true);
    }

    @Test
    public void testAclOnMountEntry() throws Exception {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fcView.setAcl(this.mountOnNn1, (List)aclSpec);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(this.fcView.getAclStatus(this.mountOnNn1)));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(fc.getAclStatus(this.targetTestRoot)));
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ)});
        this.fcView.modifyAclEntries(this.mountOnNn1, (List)aclSpec);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(this.fcView.getAclStatus(this.mountOnNn1)));
        this.fcView.removeDefaultAcl(this.mountOnNn1);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(this.fcView.getAclStatus(this.mountOnNn1)));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(fc.getAclStatus(this.targetTestRoot)));
        Assertions.assertEquals((int)0, (int)this.fcView.getAclStatus(this.mountOnNn2).getEntries().size());
        Assertions.assertEquals((int)0, (int)fc2.getAclStatus(this.targetTestRoot2).getEntries().size());
        this.fcView.removeAcl(this.mountOnNn1);
        Assertions.assertEquals((int)0, (int)this.fcView.getAclStatus(this.mountOnNn1).getEntries().size());
        Assertions.assertEquals((int)0, (int)fc.getAclStatus(this.targetTestRoot).getEntries().size());
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ)});
        this.fcView.modifyAclEntries(this.mountOnNn2, (List)aclSpec);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(this.fcView.getAclStatus(this.mountOnNn2)));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(fc2.getAclStatus(this.targetTestRoot2)));
        this.fcView.removeAclEntries(this.mountOnNn2, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ)}));
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(fc2.getAclStatus(this.targetTestRoot2)));
        this.fcView.removeAcl(this.mountOnNn2);
        Assertions.assertEquals((int)0, (int)this.fcView.getAclStatus(this.mountOnNn2).getEntries().size());
        Assertions.assertEquals((int)0, (int)fc2.getAclStatus(this.targetTestRoot2).getEntries().size());
    }

    private AclEntry[] aclEntryArray(AclStatus aclStatus) {
        return aclStatus.getEntries().toArray(new AclEntry[0]);
    }

    static {
        clusterConf = new Configuration();
    }
}

