/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.util.Lists;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestViewFileSystemWithAcls {
    private static MiniDFSCluster cluster;
    private static Configuration clusterConf;
    private static FileSystem fHdfs;
    private static FileSystem fHdfs2;
    private FileSystem fsView;
    private Configuration fsViewConf;
    private FileSystem fsTarget;
    private FileSystem fsTarget2;
    private Path targetTestRoot;
    private Path targetTestRoot2;
    private Path mountOnNn1;
    private Path mountOnNn2;
    private FileSystemTestHelper fileSystemTestHelper = new FileSystemTestHelper("/tmp/TestViewFileSystemWithAcls");

    @BeforeAll
    public static void clusterSetupAtBeginning() throws IOException {
        clusterConf.setBoolean("dfs.namenode.acls.enabled", true);
        cluster = new MiniDFSCluster.Builder(clusterConf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(2).build();
        cluster.waitClusterUp();
        fHdfs = cluster.getFileSystem(0);
        fHdfs2 = cluster.getFileSystem(1);
    }

    @AfterAll
    public static void ClusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.fsTarget = fHdfs;
        this.fsTarget2 = fHdfs2;
        this.targetTestRoot = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget);
        this.targetTestRoot2 = this.fileSystemTestHelper.getAbsoluteTestRootPath(this.fsTarget2);
        this.fsTarget.delete(this.targetTestRoot, true);
        this.fsTarget2.delete(this.targetTestRoot2, true);
        this.fsTarget.mkdirs(this.targetTestRoot);
        this.fsTarget2.mkdirs(this.targetTestRoot2);
        this.fsViewConf = ViewFileSystemTestSetup.createConfig();
        this.setupMountPoints();
        this.fsView = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.fsViewConf);
    }

    private void setupMountPoints() {
        this.mountOnNn1 = new Path("/mountOnNn1");
        this.mountOnNn2 = new Path("/mountOnNn2");
        ConfigUtil.addLink((Configuration)this.fsViewConf, (String)this.mountOnNn1.toString(), (URI)this.targetTestRoot.toUri());
        ConfigUtil.addLink((Configuration)this.fsViewConf, (String)this.mountOnNn2.toString(), (URI)this.targetTestRoot2.toUri());
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
        this.fsTarget2.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget2), true);
    }

    @Test
    public void testAclOnMountEntry() throws Exception {
        ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.OTHER, FsAction.NONE)});
        this.fsView.setAcl(this.mountOnNn1, (List)aclSpec);
        Object[] expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(this.fsView.getAclStatus(this.mountOnNn1)));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(fHdfs.getAclStatus(this.targetTestRoot)));
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ)});
        this.fsView.modifyAclEntries(this.mountOnNn1, (List)aclSpec);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, FsAction.READ_WRITE), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.GROUP, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.MASK, FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.OTHER, FsAction.NONE)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(this.fsView.getAclStatus(this.mountOnNn1)));
        this.fsView.removeDefaultAcl(this.mountOnNn1);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "foo", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(this.fsView.getAclStatus(this.mountOnNn1)));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(fHdfs.getAclStatus(this.targetTestRoot)));
        Assertions.assertEquals((int)0, (int)this.fsView.getAclStatus(this.mountOnNn2).getEntries().size());
        Assertions.assertEquals((int)0, (int)fHdfs2.getAclStatus(this.targetTestRoot2).getEntries().size());
        this.fsView.removeAcl(this.mountOnNn1);
        Assertions.assertEquals((int)0, (int)this.fsView.getAclStatus(this.mountOnNn1).getEntries().size());
        Assertions.assertEquals((int)0, (int)fHdfs.getAclStatus(this.targetTestRoot).getEntries().size());
        aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ)});
        this.fsView.modifyAclEntries(this.mountOnNn2, (List)aclSpec);
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ), AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(this.fsView.getAclStatus(this.mountOnNn2)));
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(fHdfs2.getAclStatus(this.targetTestRoot2)));
        this.fsView.removeAclEntries(this.mountOnNn2, (List)Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, "bar", FsAction.READ)}));
        expected = new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.GROUP, FsAction.READ_EXECUTE)};
        Assertions.assertArrayEquals((Object[])expected, (Object[])this.aclEntryArray(fHdfs2.getAclStatus(this.targetTestRoot2)));
        this.fsView.removeAcl(this.mountOnNn2);
        Assertions.assertEquals((int)0, (int)this.fsView.getAclStatus(this.mountOnNn2).getEntries().size());
        Assertions.assertEquals((int)0, (int)fHdfs2.getAclStatus(this.targetTestRoot2).getEntries().size());
    }

    private AclEntry[] aclEntryArray(AclStatus aclStatus) {
        return aclStatus.getEntries().toArray(new AclEntry[0]);
    }

    static {
        clusterConf = new Configuration();
    }
}

