/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.EnumSet;
import java.util.HashMap;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.NflyFSystem;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.client.CreateEncryptionZoneFlag;
import org.apache.hadoop.hdfs.client.HdfsAdmin;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestViewFileSystemHdfs
extends ViewFileSystemBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestViewFileSystemHdfs.class);
    private static MiniDFSCluster cluster;
    private static Path defaultWorkingDirectory;
    private static Path defaultWorkingDirectory2;
    private static final Configuration CONF;
    private static FileSystem fHdfs;
    private static FileSystem fHdfs2;
    private FileSystem fsTarget2;
    Path targetTestRoot2;

    protected FileSystemTestHelper createFileSystemHelper() {
        return new FileSystemTestHelper("/tmp/TestViewFileSystemHdfs");
    }

    @BeforeAll
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        FileSystemTestHelper fsHelper = new FileSystemTestHelper();
        String testRoot = fsHelper.getTestRootDir();
        CONF.set("hadoop.security.key.provider.path", "jceks://file" + new Path(new File(testRoot).getAbsoluteFile().toString(), "test.jks").toUri());
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        CONF.setInt("dfs.namenode.list.encryption.zones.num.responses", 2);
        SupportsBlocks = true;
        CONF.setBoolean("dfs.namenode.delegation.token.always-use", true);
        cluster = new MiniDFSCluster.Builder(CONF).nnTopology(MiniDFSNNTopology.simpleFederatedTopology(2)).numDataNodes(2).build();
        cluster.waitClusterUp();
        fHdfs = cluster.getFileSystem(0);
        fHdfs2 = cluster.getFileSystem(1);
        fHdfs.getConf().set("fs.defaultFS", FsConstants.VIEWFS_URI.toString());
        fHdfs2.getConf().set("fs.defaultFS", FsConstants.VIEWFS_URI.toString());
        defaultWorkingDirectory = fHdfs.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        defaultWorkingDirectory2 = fHdfs2.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fHdfs.mkdirs(defaultWorkingDirectory);
        fHdfs2.mkdirs(defaultWorkingDirectory2);
    }

    @AfterAll
    public static void ClusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.fsTarget = fHdfs;
        this.fsTarget2 = fHdfs2;
        this.targetTestRoot2 = new FileSystemTestHelper().getAbsoluteTestRootPath(this.fsTarget2);
        super.setUp();
    }

    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    void setupMountPoints() {
        super.setupMountPoints();
        ConfigUtil.addLink((Configuration)this.conf, (String)"/mountOnNn2", (URI)new Path(this.targetTestRoot2, "mountOnNn2").toUri());
    }

    int getExpectedDirPaths() {
        return 8;
    }

    int getExpectedMountPoints() {
        return 9;
    }

    int getExpectedDelegationTokenCount() {
        return 2;
    }

    int getExpectedDelegationTokenCountWithCredentials() {
        return 2;
    }

    Path getTrashRootInFallBackFS() throws IOException {
        return new Path("/.Trash/" + UserGroupInformation.getCurrentUser().getShortUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTrashRootsAfterEncryptionZoneDeletion() throws Exception {
        try {
            Path zone = new Path("/EZ");
            this.fsTarget.mkdirs(zone);
            Path zone1 = new Path("/EZ/zone1");
            this.fsTarget.mkdirs(zone1);
            DFSTestUtil.createKey("test_key", cluster, CONF);
            HdfsAdmin hdfsAdmin = new HdfsAdmin(cluster.getURI(0), CONF);
            EnumSet<CreateEncryptionZoneFlag> provisionTrash = EnumSet.of(CreateEncryptionZoneFlag.PROVISION_TRASH);
            hdfsAdmin.createEncryptionZone(zone1, "test_key", provisionTrash);
            Path encFile = new Path(zone1, "encFile");
            DFSTestUtil.createFile(this.fsTarget, encFile, 10240L, (short)1, 65261L);
            Configuration clientConf = new Configuration(CONF);
            clientConf.setLong("fs.trash.interval", 1L);
            clientConf.set("fs.default.name", this.fsTarget.getUri().toString());
            FsShell shell = new FsShell(clientConf);
            DFSTestUtil.verifyDelete(shell, this.fsTarget, encFile, true);
            Assertions.assertTrue((this.fsView.getTrashRoots(true).size() == 1 ? 1 : 0) != 0, (String)"ViewFileSystem trash roots should include EZ file trash");
            DFSTestUtil.verifyDelete(shell, this.fsTarget, zone, true);
            Assertions.assertTrue((this.fsView.getTrashRoots(true).size() == 2 ? 1 : 0) != 0, (String)"ViewFileSystem trash roots should include EZ zone trash");
        }
        finally {
            DFSTestUtil.deleteKey("test_key", cluster);
        }
    }

    @Test
    public void testDf() throws Exception {
        Configuration newConf = new Configuration(this.conf);
        DFSTestUtil.FsShellRun("-df", 0, "Use%" + System.lineSeparator(), newConf);
        newConf.set("fs.default.name", "viewfs:///");
        DFSTestUtil.FsShellRun("-df /user", 0, "Mounted on", newConf);
        DFSTestUtil.FsShellRun("-df viewfs:///user", 0, "/user", newConf);
        DFSTestUtil.FsShellRun("-df /user3", 1, "/user3", newConf);
        DFSTestUtil.FsShellRun("-df /user2/abc", 1, "No such file or directory", newConf);
        DFSTestUtil.FsShellRun("-df /user2/", 0, "/user2", newConf);
        DFSTestUtil.FsShellRun("-df /internalDir", 0, "/internalDir", newConf);
        DFSTestUtil.FsShellRun("-df /", 0, null, newConf);
        DFSTestUtil.FsShellRun("-df", 0, null, newConf);
    }

    @Test
    public void testFileChecksum() throws IOException {
        ViewFileSystem viewFs = (ViewFileSystem)this.fsView;
        Path mountDataRootPath = new Path("/data");
        String fsTargetFileName = "debug.log";
        Path fsTargetFilePath = new Path(this.targetTestRoot, "data/debug.log");
        Path mountDataFilePath = new Path(mountDataRootPath, fsTargetFileName);
        FileSystemTestHelper.createFile((FileSystem)this.fsTarget, (Path)fsTargetFilePath);
        FileStatus fileStatus = viewFs.getFileStatus(mountDataFilePath);
        long fileLength = fileStatus.getLen();
        FileChecksum fileChecksumViaViewFs = viewFs.getFileChecksum(mountDataFilePath);
        FileChecksum fileChecksumViaTargetFs = this.fsTarget.getFileChecksum(fsTargetFilePath);
        Assertions.assertTrue((boolean)fileChecksumViaViewFs.equals((Object)fileChecksumViaTargetFs), (String)"File checksum not matching!");
        fileChecksumViaViewFs = viewFs.getFileChecksum(mountDataFilePath, fileLength / 2L);
        fileChecksumViaTargetFs = this.fsTarget.getFileChecksum(fsTargetFilePath, fileLength / 2L);
        Assertions.assertTrue((boolean)fileChecksumViaViewFs.equals((Object)fileChecksumViaTargetFs), (String)"File checksum not matching!");
    }

    @Test
    public void testRenameAccorssFilesystem() throws IOException {
        Path mountDataRootPath = new Path("/data");
        Path fsTargetFilePath = new Path("/mountOnNn2");
        Path filePath = new Path(mountDataRootPath + "/ttest");
        Path hdfFilepath = new Path(fsTargetFilePath + "/ttest2");
        this.fsView.create(filePath);
        try {
            this.fsView.rename(filePath, hdfFilepath);
            ContractTestUtils.fail((String)"Should thrown IOE on Renames across filesytems");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains((String)"Renames across Mount points not supported", (Throwable)e);
        }
    }

    @Test
    public void testNflyClosestRepair() throws Exception {
        this.testNflyRepair(NflyFSystem.NflyKey.repairOnRead);
    }

    @Test
    public void testNflyMostRecentRepair() throws Exception {
        this.testNflyRepair(NflyFSystem.NflyKey.readMostRecent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNflyRepair(NflyFSystem.NflyKey repairKey) throws Exception {
        block17: {
            LOG.info("Starting testNflyWriteSimpleFailover");
            URI uri1 = this.targetTestRoot.toUri();
            URI uri2 = this.targetTestRoot2.toUri();
            URI[] testUris = new URI[]{new URI(uri1.getScheme(), uri1.getAuthority(), "/", null, null), new URI(uri2.getScheme(), uri2.getAuthority(), "/", null, null)};
            String clusterName = "mycluster";
            Configuration testConf = new Configuration(this.conf);
            testConf.set("fs.viewfs.mounttable.default.name.key", clusterName);
            testConf.setInt("ipc.client.connect.max.retries", 1);
            String testString = "Hello Nfly!";
            Path nflyRoot = new Path("/nflyroot");
            ConfigUtil.addLinkNfly((Configuration)testConf, (String)clusterName, (String)nflyRoot.toString(), (String)("minReplication=2," + repairKey + "=true"), (URI[])testUris);
            FileSystem nfly = FileSystem.get((URI)URI.create("viewfs:///"), (Configuration)testConf);
            nfly.setWorkingDirectory(new Path(nflyRoot + nfly.getWorkingDirectory().toUri().getPath()));
            Path testDir = new Path("testdir1/sub1/sub3");
            Path testDir_tmp = new Path("testdir1/sub1/sub3_temp");
            Assertions.assertTrue((boolean)nfly.mkdirs(testDir), (String)(testDir + ": Failed to create!"));
            Assertions.assertTrue((boolean)nfly.rename(testDir, testDir_tmp));
            Assertions.assertTrue((boolean)nfly.rename(testDir_tmp, testDir));
            for (URI testUri : testUris) {
                FileSystem fs = FileSystem.get((URI)testUri, (Configuration)testConf);
                Assertions.assertTrue((boolean)fs.exists(testDir), (String)(testDir + " should exist!"));
            }
            Path testFile = new Path("test.txt");
            try (FSDataOutputStream fsDos = nfly.create(testFile);){
                fsDos.writeUTF("Hello Nfly!");
            }
            for (URI testUri : testUris) {
                FileSystem fs = FileSystem.get((URI)testUri, (Configuration)testConf);
                try (FSDataInputStream fsdis = fs.open(testFile);){
                    Assertions.assertEquals((Object)"Hello Nfly!", (Object)fsdis.readUTF(), (String)"Wrong file content");
                }
            }
            for (int i = 0; i < cluster.getNumNameNodes(); ++i) {
                cluster.shutdownNameNode(i);
                FSDataInputStream fsDis = null;
                try {
                    fsDis = nfly.open(testFile);
                    Assertions.assertEquals((Object)"Hello Nfly!", (Object)fsDis.readUTF(), (String)"Wrong file content");
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis});
                    cluster.restartNameNode(i);
                    throw throwable;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis});
                cluster.restartNameNode(i);
            }
            FileSystem fs1 = FileSystem.get((URI)testUris[0], (Configuration)this.conf);
            Assertions.assertTrue((boolean)fs1.delete(testFile, false));
            Assertions.assertFalse((boolean)fs1.exists(testFile));
            FSDataInputStream fsDis = null;
            try {
                fsDis = nfly.open(testFile);
                Assertions.assertEquals((Object)"Hello Nfly!", (Object)fsDis.readUTF(), (String)"Wrong file content");
                Assertions.assertTrue((boolean)fs1.exists(testFile));
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis});
                throw throwable;
            }
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis});
            if (repairKey != NflyFSystem.NflyKey.readMostRecent) break block17;
            FileSystem fs2 = FileSystem.get((URI)testUris[0], (Configuration)this.conf);
            long expectedMtime = fs2.getFileStatus(testFile).getModificationTime();
            for (URI testUri : testUris) {
                FileSystem fs = FileSystem.get((URI)testUri, (Configuration)this.conf);
                fs.setTimes(testFile, 1L, 1L);
                Assertions.assertEquals((long)1L, (long)fs.getFileStatus(testFile).getModificationTime(), (String)(testUri + "Set mtime failed!"));
                Assertions.assertEquals((long)expectedMtime, (long)nfly.getFileStatus(testFile).getModificationTime(), (String)"nfly file status wrong");
                FSDataInputStream fsDis2 = null;
                try {
                    fsDis2 = nfly.open(testFile);
                    Assertions.assertEquals((Object)"Hello Nfly!", (Object)fsDis2.readUTF(), (String)"Wrong file content");
                    Assertions.assertEquals((long)expectedMtime, (long)fs.getFileStatus(testFile).getModificationTime(), (String)"Repair most recent failed!");
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis2});
                    throw throwable;
                }
                IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fsDis2});
            }
        }
    }

    @Test
    public void testTargetFileSystemLazyInitializationWithUgi() throws Exception {
        FileSystem otherfs2;
        final HashMap map = new HashMap();
        Path user1Path = new Path("/data/user1");
        FileSystem fs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.conf);
        fs.mkdirs(user1Path);
        fs.delete(user1Path, false);
        UserGroupInformation userUgi = UserGroupInformation.createUserForTesting((String)"user1@HADOOP.COM", (String[])new String[]{"hadoop"});
        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                String doAsUserName = ugi.getUserName();
                Assertions.assertEquals((Object)doAsUserName, (Object)"user1@HADOOP.COM");
                FileSystem viewFS = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)TestViewFileSystemHdfs.this.conf);
                map.put("user1", viewFS);
                return null;
            }
        });
        try {
            otherfs2 = (FileSystem)map.get("user1");
            otherfs2.mkdirs(user1Path);
            Assertions.fail((String)"This mkdir should fail");
        }
        catch (AccessControlException otherfs2) {
            // empty catch block
        }
        this.fsTarget.setOwner(new Path(this.targetTestRoot, "data"), "user1", "test2");
        this.fsTarget.setPermission(new Path(this.targetTestRoot, "data"), new FsPermission("775"));
        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                FileSystem viewFS = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)TestViewFileSystemHdfs.this.conf);
                map.put("user1", viewFS);
                return null;
            }
        });
        otherfs2 = (FileSystem)map.get("user1");
        otherfs2.mkdirs(user1Path);
        String owner = otherfs2.getFileStatus(user1Path).getOwner();
        Assertions.assertEquals((Object)owner, (Object)userUgi.getShortUserName(), (String)"The owner did not match ");
        otherfs2.delete(user1Path, false);
    }

    @Test
    public void testInternalDirectoryPermissions() throws IOException {
        LOG.info("Starting testInternalDirectoryPermissions!");
        Configuration localConf = new Configuration(this.conf);
        ConfigUtil.addLinkFallback((Configuration)localConf, (URI)new Path(this.targetTestRoot, "fallbackDir").toUri());
        FileSystem fs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)localConf);
        Path subDirOfInternalDir = new Path("/internalDir/dir1");
        fs.mkdirs(subDirOfInternalDir);
        Path subDirOfRealDir = new Path("/internalDir/linkToDir2/dir1");
        fs.mkdirs(subDirOfRealDir);
        Assertions.assertEquals((Object)fs.getFileStatus(subDirOfInternalDir).getPermission(), (Object)fs.getFileStatus(subDirOfRealDir).getPermission());
    }

    private Path getViewFsPath(Path path, FileSystem fs) {
        return fs.makeQualified(path);
    }

    private Path getViewFsPath(String path, FileSystem fs) {
        return this.getViewFsPath(new Path(path), fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnclosingRootsBase() throws Exception {
        try {
            Path zone = new Path("/data/EZ");
            this.fsTarget.mkdirs(zone);
            Path zone1 = new Path("/data/EZ/zone1");
            this.fsTarget.mkdirs(zone1);
            DFSTestUtil.createKey("test_key", cluster, 0, CONF);
            HdfsAdmin hdfsAdmin = new HdfsAdmin(cluster.getURI(0), CONF);
            EnumSet<CreateEncryptionZoneFlag> provisionTrash = EnumSet.of(CreateEncryptionZoneFlag.PROVISION_TRASH);
            hdfsAdmin.createEncryptionZone(zone1, "test_key", provisionTrash);
            Assertions.assertEquals((Object)this.fsView.getEnclosingRoot(zone), (Object)this.getViewFsPath("/data", this.fsView));
            Assertions.assertEquals((Object)this.fsView.getEnclosingRoot(zone1), (Object)this.getViewFsPath(zone1, this.fsView));
            Path nn02Ez = new Path("/mountOnNn2/EZ");
            this.fsTarget2.mkdirs(nn02Ez);
            Assertions.assertEquals((Object)this.fsView.getEnclosingRoot(nn02Ez), (Object)this.getViewFsPath("/mountOnNn2", this.fsView));
            HdfsAdmin hdfsAdmin2 = new HdfsAdmin(cluster.getURI(1), CONF);
            DFSTestUtil.createKey("test_key", cluster, 1, CONF);
            hdfsAdmin2.createEncryptionZone(nn02Ez, "test_key", provisionTrash);
            Assertions.assertEquals((Object)this.fsView.getEnclosingRoot(nn02Ez), (Object)this.getViewFsPath(nn02Ez, this.fsView));
            Assertions.assertEquals((Object)this.fsView.getEnclosingRoot(new Path(nn02Ez, "dir/dir2/file")), (Object)this.getViewFsPath(nn02Ez, this.fsView));
            Assertions.assertEquals((Object)this.fsView.getEnclosingRoot(this.fsView.getWorkingDirectory()), (Object)this.getViewFsPath("/user", this.fsView));
        }
        finally {
            DFSTestUtil.deleteKey("test_key", cluster, 0);
        }
    }

    @Test
    public void testEnclosingRootFailure() throws Exception {
        LambdaTestUtils.intercept(NotInMountpointException.class, () -> this.fsView.getEnclosingRoot(new Path("/does/not/exist")));
        Path zone = new Path("/data/EZ");
        Path fs1 = this.fsTarget.makeQualified(zone);
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.fsView.getEnclosingRoot(fs1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> this.fsView.getEnclosingRoot(new Path("hdfs://fakeAuthority/")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnclosingRootWrapped() throws Exception {
        try {
            Path zone = new Path("/data/EZ");
            this.fsTarget.mkdirs(zone);
            Path zone1 = new Path("/data/EZ/testZone1");
            this.fsTarget.mkdirs(zone1);
            DFSTestUtil.createKey("test_key", cluster, 0, CONF);
            HdfsAdmin hdfsAdmin = new HdfsAdmin(cluster.getURI(0), CONF);
            EnumSet<CreateEncryptionZoneFlag> provisionTrash = EnumSet.of(CreateEncryptionZoneFlag.PROVISION_TRASH);
            hdfsAdmin.createEncryptionZone(zone1, "test_key", provisionTrash);
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"foo");
            Path p = (Path)ugi.doAs(() -> {
                FileSystem wFs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.conf);
                return wFs.getEnclosingRoot(zone);
            });
            Assertions.assertEquals((Object)p, (Object)this.getViewFsPath("/data", this.fsView));
            p = (Path)ugi.doAs(() -> {
                FileSystem wFs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)this.conf);
                return wFs.getEnclosingRoot(zone1);
            });
            Assertions.assertEquals((Object)p, (Object)this.getViewFsPath(zone1, this.fsView));
        }
        finally {
            DFSTestUtil.deleteKey("test_key", cluster, 0);
        }
    }

    static {
        CONF = new Configuration();
    }
}

