/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.permission;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStickyBit {
    static final UserGroupInformation user1 = UserGroupInformation.createUserForTesting((String)"theDoctor", (String[])new String[]{"tardis"});
    static final UserGroupInformation user2 = UserGroupInformation.createUserForTesting((String)"rose", (String[])new String[]{"powellestates"});
    static final Logger LOG = LoggerFactory.getLogger(TestStickyBit.class);
    private static MiniDFSCluster cluster;
    private static Configuration conf;
    private static FileSystem hdfs;
    private static FileSystem hdfsAsUser1;
    private static FileSystem hdfsAsUser2;

    @BeforeAll
    public static void init() throws Exception {
        conf = new HdfsConfiguration();
        conf.setBoolean("dfs.permissions.enabled", true);
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        TestStickyBit.initCluster(true);
    }

    private static void initCluster(boolean format) throws Exception {
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(4).format(format).build();
        hdfs = cluster.getFileSystem();
        Assertions.assertTrue((boolean)(hdfs instanceof DistributedFileSystem));
        hdfsAsUser1 = DFSTestUtil.getFileSystemAs(user1, conf);
        Assertions.assertTrue((boolean)(hdfsAsUser1 instanceof DistributedFileSystem));
        hdfsAsUser2 = DFSTestUtil.getFileSystemAs(user2, conf);
        Assertions.assertTrue((boolean)(hdfsAsUser2 instanceof DistributedFileSystem));
    }

    @BeforeEach
    public void setup() throws Exception {
        if (hdfs != null) {
            for (FileStatus stat : hdfs.listStatus(new Path("/"))) {
                hdfs.delete(stat.getPath(), true);
            }
        }
    }

    @AfterAll
    public static void shutdown() throws Exception {
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{hdfs, hdfsAsUser1, hdfsAsUser2});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmCanAppend(Configuration conf, Path p) throws Exception {
        Path file = new Path(p, "foo");
        TestStickyBit.writeFile(hdfsAsUser1, file);
        hdfsAsUser1.setPermission(file, new FsPermission(511));
        Path file2 = new Path(p, "foo");
        FSDataOutputStream h = null;
        try {
            h = hdfsAsUser2.append(file2);
            h.write("Some more data".getBytes());
            h.close();
            h = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{h});
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{h});
    }

    private void confirmDeletingFiles(Configuration conf, Path p) throws Exception {
        Path file = new Path(p, "foo");
        TestStickyBit.writeFile(hdfsAsUser1, file);
        Assertions.assertEquals((Object)user1.getShortUserName(), (Object)hdfsAsUser1.getFileStatus(file).getOwner());
        try {
            hdfsAsUser2.delete(file, false);
            Assertions.fail((String)"Shouldn't be able to delete someone else's file with SB on");
        }
        catch (IOException ioe) {
            Assertions.assertTrue((boolean)(ioe instanceof AccessControlException));
            Assertions.assertTrue((boolean)ioe.getMessage().contains("sticky bit"));
            Assertions.assertTrue((boolean)ioe.getMessage().contains("user=" + user2.getUserName()));
            Assertions.assertTrue((boolean)ioe.getMessage().contains("path=\"" + file + "\""));
            Assertions.assertTrue((boolean)ioe.getMessage().contains("parent=\"" + file.getParent() + "\""));
        }
    }

    private void confirmStickyBitDoesntPropagate(FileSystem hdfs, Path p) throws IOException {
        Path p2 = new Path(p, "bar");
        hdfs.mkdirs(p2);
        Assertions.assertFalse((boolean)hdfs.getFileStatus(p2).getPermission().getStickyBit());
    }

    private void confirmSettingAndGetting(FileSystem hdfs, Path p, Path baseDir) throws IOException {
        Assertions.assertFalse((boolean)hdfs.getFileStatus(p).getPermission().getStickyBit());
        short withSB = (short)(hdfs.getFileStatus(p).getPermission().toShort() | 0x200);
        Assertions.assertTrue((boolean)new FsPermission(withSB).getStickyBit());
        hdfs.setPermission(p, new FsPermission(withSB));
        Assertions.assertTrue((boolean)hdfs.getFileStatus(p).getPermission().getStickyBit());
        Path f = new Path(baseDir, "somefile");
        TestStickyBit.writeFile(hdfs, f);
        Assertions.assertFalse((boolean)hdfs.getFileStatus(f).getPermission().getStickyBit());
        withSB = (short)(hdfs.getFileStatus(f).getPermission().toShort() | 0x200);
        hdfs.setPermission(f, new FsPermission(withSB));
        Assertions.assertTrue((boolean)hdfs.getFileStatus(f).getPermission().getStickyBit());
    }

    @Test
    public void testGeneralSBBehavior() throws Exception {
        Path baseDir = new Path("/mcgann");
        hdfs.mkdirs(baseDir);
        Path p = new Path(baseDir, "tmp");
        hdfs.mkdirs(p);
        hdfs.setPermission(p, new FsPermission(1023));
        this.confirmCanAppend(conf, p);
        baseDir = new Path("/eccleston");
        hdfs.mkdirs(baseDir);
        p = new Path(baseDir, "roguetraders");
        hdfs.mkdirs(p);
        this.confirmSettingAndGetting(hdfs, p, baseDir);
        baseDir = new Path("/tennant");
        hdfs.mkdirs(baseDir);
        p = new Path(baseDir, "contemporary");
        hdfs.mkdirs(p);
        hdfs.setPermission(p, new FsPermission(1023));
        this.confirmDeletingFiles(conf, p);
        baseDir = new Path("/smith");
        hdfs.mkdirs(baseDir);
        p = new Path(baseDir, "scissorsisters");
        hdfs.mkdirs(p, new FsPermission(950));
        this.confirmStickyBitDoesntPropagate(hdfs, baseDir);
    }

    @Test
    public void testAclGeneralSBBehavior() throws Exception {
        Path baseDir = new Path("/mcgann");
        hdfs.mkdirs(baseDir);
        Path p = new Path(baseDir, "tmp");
        hdfs.mkdirs(p);
        hdfs.setPermission(p, new FsPermission(1023));
        TestStickyBit.applyAcl(p);
        this.confirmCanAppend(conf, p);
        baseDir = new Path("/eccleston");
        hdfs.mkdirs(baseDir);
        p = new Path(baseDir, "roguetraders");
        hdfs.mkdirs(p);
        TestStickyBit.applyAcl(p);
        this.confirmSettingAndGetting(hdfs, p, baseDir);
        baseDir = new Path("/tennant");
        hdfs.mkdirs(baseDir);
        p = new Path(baseDir, "contemporary");
        hdfs.mkdirs(p);
        hdfs.setPermission(p, new FsPermission(1023));
        TestStickyBit.applyAcl(p);
        this.confirmDeletingFiles(conf, p);
        baseDir = new Path("/smith");
        hdfs.mkdirs(baseDir);
        p = new Path(baseDir, "scissorsisters");
        hdfs.mkdirs(p, new FsPermission(950));
        TestStickyBit.applyAcl(p);
        this.confirmStickyBitDoesntPropagate(hdfs, p);
    }

    @Test
    public void testMovingFiles() throws Exception {
        this.testMovingFiles(false);
    }

    @Test
    public void testAclMovingFiles() throws Exception {
        this.testMovingFiles(true);
    }

    private void testMovingFiles(boolean useAcl) throws Exception {
        Path tmpPath = new Path("/tmp");
        Path tmpPath2 = new Path("/tmp2");
        hdfs.mkdirs(tmpPath);
        hdfs.mkdirs(tmpPath2);
        hdfs.setPermission(tmpPath, new FsPermission(1023));
        if (useAcl) {
            TestStickyBit.applyAcl(tmpPath);
        }
        hdfs.setPermission(tmpPath2, new FsPermission(1023));
        if (useAcl) {
            TestStickyBit.applyAcl(tmpPath2);
        }
        Path file = new Path(tmpPath, "foo");
        TestStickyBit.writeFile(hdfsAsUser1, file);
        try {
            hdfsAsUser2.rename(file, new Path(tmpPath2, "renamed"));
            Assertions.fail((String)"Shouldn't be able to rename someone else's file with SB on");
        }
        catch (IOException ioe) {
            Assertions.assertTrue((boolean)(ioe instanceof AccessControlException));
            Assertions.assertTrue((boolean)ioe.getMessage().contains("sticky bit"));
        }
    }

    @Test
    public void testStickyBitPersistence() throws Exception {
        Path sbSet = new Path("/Housemartins");
        Path sbNotSpecified = new Path("/INXS");
        Path sbSetOff = new Path("/Easyworld");
        for (Path p : new Path[]{sbSet, sbNotSpecified, sbSetOff}) {
            hdfs.mkdirs(p);
        }
        hdfs.setPermission(sbSet, new FsPermission(1023));
        hdfs.setPermission(sbSetOff, new FsPermission(511));
        TestStickyBit.shutdown();
        TestStickyBit.initCluster(false);
        Assertions.assertTrue((boolean)hdfs.exists(sbSet));
        Assertions.assertTrue((boolean)hdfs.getFileStatus(sbSet).getPermission().getStickyBit());
        Assertions.assertTrue((boolean)hdfs.exists(sbNotSpecified));
        Assertions.assertFalse((boolean)hdfs.getFileStatus(sbNotSpecified).getPermission().getStickyBit());
        Assertions.assertTrue((boolean)hdfs.exists(sbSetOff));
        Assertions.assertFalse((boolean)hdfs.getFileStatus(sbSetOff).getPermission().getStickyBit());
    }

    @Test
    public void testStickyBitReset() throws Exception {
        Path sbExplicitTestDir = new Path("/DirToTestExplicitStickyBit");
        Path sbOmittedTestDir = new Path("/DirToTestOmittedStickyBit");
        hdfs.mkdirs(sbExplicitTestDir);
        hdfs.mkdirs(sbOmittedTestDir);
        Assertions.assertTrue((boolean)hdfs.exists(sbExplicitTestDir));
        Assertions.assertTrue((boolean)hdfs.exists(sbOmittedTestDir));
        hdfs.setPermission(sbExplicitTestDir, new FsPermission(1023));
        LOG.info("Dir: {}, permission: {}", (Object)sbExplicitTestDir.getName(), (Object)hdfs.getFileStatus(sbExplicitTestDir).getPermission());
        Assertions.assertTrue((boolean)hdfs.getFileStatus(sbExplicitTestDir).getPermission().getStickyBit());
        hdfs.setPermission(sbOmittedTestDir, new FsPermission(511));
        LOG.info("Dir: {}, permission: {}", (Object)sbOmittedTestDir.getName(), (Object)hdfs.getFileStatus(sbOmittedTestDir).getPermission());
        Assertions.assertFalse((boolean)hdfs.getFileStatus(sbOmittedTestDir).getPermission().getStickyBit());
        hdfs.setPermission(sbExplicitTestDir, new FsPermission(511));
        LOG.info("Dir: {}, permission: {}", (Object)sbExplicitTestDir.getName(), (Object)hdfs.getFileStatus(sbExplicitTestDir).getPermission());
        Assertions.assertFalse((boolean)hdfs.getFileStatus(sbExplicitTestDir).getPermission().getStickyBit());
        hdfs.setPermission(sbOmittedTestDir, new FsPermission(1023));
        hdfs.setPermission(sbOmittedTestDir, new FsPermission(511));
        LOG.info("Dir: {}, permission: {}", (Object)sbOmittedTestDir.getName(), (Object)hdfs.getFileStatus(sbOmittedTestDir).getPermission());
        Assertions.assertFalse((boolean)hdfs.getFileStatus(sbOmittedTestDir).getPermission().getStickyBit());
    }

    @Test
    public void testAclStickyBitPersistence() throws Exception {
        Path sbSet = new Path("/Housemartins");
        Path sbNotSpecified = new Path("/INXS");
        Path sbSetOff = new Path("/Easyworld");
        for (Path p : new Path[]{sbSet, sbNotSpecified, sbSetOff}) {
            hdfs.mkdirs(p);
        }
        hdfs.setPermission(sbSet, new FsPermission(1023));
        TestStickyBit.applyAcl(sbSet);
        hdfs.setPermission(sbSetOff, new FsPermission(511));
        TestStickyBit.applyAcl(sbSetOff);
        TestStickyBit.shutdown();
        TestStickyBit.initCluster(false);
        Assertions.assertTrue((boolean)hdfs.exists(sbSet));
        Assertions.assertTrue((boolean)hdfs.getFileStatus(sbSet).getPermission().getStickyBit());
        Assertions.assertTrue((boolean)hdfs.exists(sbNotSpecified));
        Assertions.assertFalse((boolean)hdfs.getFileStatus(sbNotSpecified).getPermission().getStickyBit());
        Assertions.assertTrue((boolean)hdfs.exists(sbSetOff));
        Assertions.assertFalse((boolean)hdfs.getFileStatus(sbSetOff).getPermission().getStickyBit());
    }

    @Test
    public void testStickyBitRecursiveDeleteFile() throws Exception {
        Path root = new Path("/" + GenericTestUtils.getMethodName());
        Path tmp = new Path(root, "tmp");
        Path file = new Path(tmp, "file");
        hdfs.mkdirs(tmp);
        hdfs.setPermission(root, new FsPermission(511));
        hdfs.setPermission(tmp, new FsPermission(1023));
        TestStickyBit.writeFile(hdfsAsUser1, file);
        hdfs.setPermission(file, new FsPermission(438));
        try {
            hdfsAsUser2.delete(tmp, true);
            Assertions.fail((String)"Non-owner can not delete a file protected by sticky bit recursively");
        }
        catch (AccessControlException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied by sticky bit", (Throwable)e);
        }
        hdfsAsUser1.delete(tmp, true);
    }

    @Test
    public void testStickyBitRecursiveDeleteDir() throws Exception {
        Path root = new Path("/" + GenericTestUtils.getMethodName());
        Path tmp = new Path(root, "tmp");
        Path dir = new Path(tmp, "dir");
        Path file = new Path(dir, "file");
        hdfs.mkdirs(tmp);
        hdfs.setPermission(root, new FsPermission(511));
        hdfs.setPermission(tmp, new FsPermission(1023));
        hdfsAsUser1.mkdirs(dir);
        hdfsAsUser1.setPermission(dir, new FsPermission(511));
        TestStickyBit.writeFile(hdfsAsUser1, file);
        hdfs.setPermission(file, new FsPermission(438));
        try {
            hdfsAsUser2.delete(tmp, true);
            Assertions.fail((String)"Non-owner can not delete a directory protected by sticky bit recursively");
        }
        catch (AccessControlException e) {
            GenericTestUtils.assertExceptionContains((String)"Permission denied by sticky bit", (Throwable)e);
        }
        hdfsAsUser1.delete(tmp, true);
    }

    private static void writeFile(FileSystem hdfs, Path p) throws IOException {
        FSDataOutputStream o = null;
        try {
            o = hdfs.create(p);
            o.write("some file contents".getBytes());
            o.close();
            o = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{o});
            throw throwable;
        }
        IOUtils.cleanupWithLogger(null, (Closeable[])new Closeable[]{o});
    }

    private static void applyAcl(Path p) throws IOException {
        hdfs.modifyAclEntries(p, Arrays.asList(AclTestHelpers.aclEntry(AclEntryScope.ACCESS, AclEntryType.USER, user2.getShortUserName(), FsAction.ALL), AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, user2.getShortUserName(), FsAction.ALL)));
    }
}

