/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextPermissionBase;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class TestFcHdfsPermission
extends FileContextPermissionBase {
    private static final FileContextTestHelper fileContextTestHelper = new FileContextTestHelper("/tmp/TestFcHdfsPermission");
    private static FileContext fc;
    private static MiniDFSCluster cluster;
    private static Path defaultWorkingDirectory;

    protected FileContextTestHelper getFileContextHelper() {
        return fileContextTestHelper;
    }

    protected FileContext getFileContext() {
        return fc;
    }

    @BeforeAll
    public static void clusterSetupAtBegining() throws IOException, LoginException, URISyntaxException {
        HdfsConfiguration conf = new HdfsConfiguration();
        cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        fc = FileContext.getFileContext((URI)cluster.getURI(0), (Configuration)conf);
        defaultWorkingDirectory = fc.makeQualified(new Path("/user/" + UserGroupInformation.getCurrentUser().getShortUserName()));
        fc.mkdir(defaultWorkingDirectory, FileContext.DEFAULT_PERM, true);
    }

    @AfterAll
    public static void ClusterShutdownAtEnd() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

