/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop;

import java.io.IOException;
import java.net.BindException;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.NameNodeRpcServer;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.ipc.FairCallQueue;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRefreshCallQueue {
    private MiniDFSCluster cluster;
    private Configuration config;
    static int mockQueueConstructions;
    static int mockQueuePuts;
    private int nnPort = 0;

    private void setUp(Class<?> queueClass) throws IOException {
        int portRetries;
        Random rand = new Random();
        for (portRetries = 5; portRetries > 0; --portRetries) {
            this.nnPort = 30000 + rand.nextInt(30000);
            this.config = new Configuration();
            String callQueueConfigKey = "ipc." + this.nnPort + ".callqueue.impl";
            this.config.setClass(callQueueConfigKey, queueClass, BlockingQueue.class);
            this.config.set("hadoop.security.authorization", "true");
            FileSystem.setDefaultUri((Configuration)this.config, (String)("hdfs://localhost:" + this.nnPort));
            try {
                this.cluster = new MiniDFSCluster.Builder(this.config).nameNodePort(this.nnPort).build();
                this.cluster.waitActive();
                break;
            }
            catch (BindException bindException) {
                continue;
            }
        }
        if (portRetries == 0) {
            Assertions.fail((String)"Failed to pick an ephemeral port for the NameNode RPC server.");
        }
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    public boolean canPutInMockQueue() throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.config);
        int putsBefore = mockQueuePuts;
        fs.exists(new Path("/"));
        fs.close();
        return mockQueuePuts > putsBefore;
    }

    @Test
    public void testRefresh() throws Exception {
        mockQueueConstructions = 0;
        mockQueuePuts = 0;
        this.setUp(MockCallQueue.class);
        Assertions.assertTrue((mockQueueConstructions > 0 ? 1 : 0) != 0, (String)"Mock queue should have been constructed");
        Assertions.assertTrue((boolean)this.canPutInMockQueue(), (String)"Puts are routed through MockQueue");
        int lastMockQueueConstructions = mockQueueConstructions;
        DFSAdmin admin = new DFSAdmin(this.config);
        String[] args = new String[]{"-refreshCallQueue"};
        int exitCode = admin.run(args);
        Assertions.assertEquals((int)0, (int)exitCode, (String)"DFSAdmin should return 0");
        Assertions.assertEquals((int)lastMockQueueConstructions, (int)mockQueueConstructions, (String)"Mock queue should have no additional constructions");
        try {
            Assertions.assertFalse((boolean)this.canPutInMockQueue(), (String)"Puts are routed through LBQ instead of MockQueue");
        }
        catch (IOException ioe) {
            Assertions.fail((String)"Could not put into queue at all");
        }
    }

    @Test
    public void testRefreshCallQueueWithFairCallQueue() throws Exception {
        this.setUp(FairCallQueue.class);
        boolean oldValue = DefaultMetricsSystem.inMiniClusterMode();
        DefaultMetricsSystem.setMiniClusterMode((boolean)false);
        int serviceHandlerCount = this.config.getInt("dfs.namenode.service.handler.count", 10);
        NameNodeRpcServer rpcServer = (NameNodeRpcServer)this.cluster.getNameNodeRpc();
        Assertions.assertEquals((int)(100 * serviceHandlerCount), (int)rpcServer.getClientRpcServer().getMaxQueueSize());
        this.config.setInt("ipc.server.handler.queue.size", 150);
        try {
            rpcServer.getClientRpcServer().refreshCallQueue(this.config);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof MetricsException && cause.getMessage().contains("Metrics source DecayRpcSchedulerMetrics2.ipc." + this.nnPort + " already exists!")) {
                Assertions.fail((String)"DecayRpcScheduler metrics should be unregistered before reregister");
            }
            throw e;
        }
        finally {
            DefaultMetricsSystem.setMiniClusterMode((boolean)oldValue);
        }
        Assertions.assertEquals((int)(150 * serviceHandlerCount), (int)rpcServer.getClientRpcServer().getMaxQueueSize());
    }

    public static class MockCallQueue<E>
    extends LinkedBlockingQueue<E> {
        public MockCallQueue(int levels, int cap, String ns, int[] capacityWeights, boolean serverFailOverEnabled, Configuration conf) {
            super(cap);
            ++mockQueueConstructions;
        }

        @Override
        public void put(E e) throws InterruptedException {
            super.put(e);
            ++mockQueuePuts;
        }
    }
}

