/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.tools.DFSAdmin;
import org.apache.hadoop.ipc.RefreshHandler;
import org.apache.hadoop.ipc.RefreshRegistry;
import org.apache.hadoop.ipc.RefreshResponse;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestGenericRefresh {
    private static MiniDFSCluster cluster;
    private static Configuration config;
    private static RefreshHandler firstHandler;
    private static RefreshHandler secondHandler;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        config = new Configuration();
        config.set("hadoop.security.authorization", "true");
        FileSystem.setDefaultUri((Configuration)config, (String)"hdfs://localhost:0");
        cluster = new MiniDFSCluster.Builder(config).build();
        cluster.waitActive();
    }

    @AfterAll
    public static void tearDownBeforeClass() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        firstHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)firstHandler.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenReturn((Object)RefreshResponse.successResponse());
        RefreshRegistry.defaultRegistry().register("firstHandler", firstHandler);
        secondHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)secondHandler.handleRefresh("secondHandler", new String[]{"one", "two"})).thenReturn((Object)new RefreshResponse(3, "three"));
        Mockito.when((Object)secondHandler.handleRefresh("secondHandler", new String[]{"one"})).thenReturn((Object)new RefreshResponse(2, "two"));
        RefreshRegistry.defaultRegistry().register("secondHandler", secondHandler);
    }

    @AfterEach
    public void tearDown() throws Exception {
        RefreshRegistry.defaultRegistry().unregisterAll("firstHandler");
        RefreshRegistry.defaultRegistry().unregisterAll("secondHandler");
    }

    @Test
    public void testInvalidCommand() throws Exception {
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "nn"};
        int exitCode = admin.run(args);
        Assertions.assertEquals((int)-1, (int)exitCode, (String)"DFSAdmin should fail due to bad args");
    }

    @Test
    public void testInvalidIdentifier() throws Exception {
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:" + cluster.getNameNodePort(), "unregisteredIdentity"};
        int exitCode = admin.run(args);
        Assertions.assertEquals((int)-1, (int)exitCode, (String)"DFSAdmin should fail due to no handler registered");
    }

    @Test
    public void testValidIdentifier() throws Exception {
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:" + cluster.getNameNodePort(), "firstHandler"};
        int exitCode = admin.run(args);
        Assertions.assertEquals((int)0, (int)exitCode, (String)"DFSAdmin should succeed");
        ((RefreshHandler)Mockito.verify((Object)firstHandler)).handleRefresh("firstHandler", new String[0]);
        ((RefreshHandler)Mockito.verify((Object)secondHandler, (VerificationMode)Mockito.never())).handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class));
    }

    @Test
    public void testVariableArgs() throws Exception {
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:" + cluster.getNameNodePort(), "secondHandler", "one"};
        int exitCode = admin.run(args);
        Assertions.assertEquals((int)2, (int)exitCode, (String)"DFSAdmin should return 2");
        exitCode = admin.run(new String[]{"-refresh", "localhost:" + cluster.getNameNodePort(), "secondHandler", "one", "two"});
        Assertions.assertEquals((int)3, (int)exitCode, (String)"DFSAdmin should now return 3");
        ((RefreshHandler)Mockito.verify((Object)secondHandler)).handleRefresh("secondHandler", new String[]{"one"});
        ((RefreshHandler)Mockito.verify((Object)secondHandler)).handleRefresh("secondHandler", new String[]{"one", "two"});
    }

    @Test
    public void testUnregistration() throws Exception {
        RefreshRegistry.defaultRegistry().unregisterAll("firstHandler");
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:" + cluster.getNameNodePort(), "firstHandler"};
        int exitCode = admin.run(args);
        Assertions.assertEquals((int)-1, (int)exitCode, (String)"DFSAdmin should return -1");
    }

    @Test
    public void testUnregistrationReturnValue() {
        RefreshHandler mockHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        RefreshRegistry.defaultRegistry().register("test", mockHandler);
        boolean ret = RefreshRegistry.defaultRegistry().unregister("test", mockHandler);
        Assertions.assertTrue((boolean)ret);
    }

    @Test
    public void testMultipleRegistration() throws Exception {
        RefreshRegistry.defaultRegistry().register("sharedId", firstHandler);
        RefreshRegistry.defaultRegistry().register("sharedId", secondHandler);
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:" + cluster.getNameNodePort(), "sharedId", "one"};
        int exitCode = admin.run(args);
        Assertions.assertEquals((int)-1, (int)exitCode);
        ((RefreshHandler)Mockito.verify((Object)firstHandler)).handleRefresh("sharedId", new String[]{"one"});
        ((RefreshHandler)Mockito.verify((Object)secondHandler)).handleRefresh("sharedId", new String[]{"one"});
        RefreshRegistry.defaultRegistry().unregisterAll("sharedId");
    }

    @Test
    public void testMultipleReturnCodeMerging() throws Exception {
        RefreshHandler handlerOne = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)handlerOne.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenReturn((Object)new RefreshResponse(23, "Twenty Three"));
        RefreshHandler handlerTwo = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)handlerTwo.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenReturn((Object)new RefreshResponse(10, "Ten"));
        RefreshRegistry.defaultRegistry().register("shared", handlerOne);
        RefreshRegistry.defaultRegistry().register("shared", handlerTwo);
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:" + cluster.getNameNodePort(), "shared"};
        int exitCode = admin.run(args);
        Assertions.assertEquals((int)-1, (int)exitCode);
        ((RefreshHandler)Mockito.verify((Object)handlerOne)).handleRefresh("shared", new String[0]);
        ((RefreshHandler)Mockito.verify((Object)handlerTwo)).handleRefresh("shared", new String[0]);
        RefreshRegistry.defaultRegistry().unregisterAll("shared");
    }

    @Test
    public void testExceptionResultsInNormalError() throws Exception {
        RefreshHandler exceptionalHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)exceptionalHandler.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenThrow(new Throwable[]{new RuntimeException("Exceptional Handler Throws Exception")});
        RefreshHandler otherExceptionalHandler = (RefreshHandler)Mockito.mock(RefreshHandler.class);
        Mockito.when((Object)otherExceptionalHandler.handleRefresh(Mockito.anyString(), (String[])Mockito.any(String[].class))).thenThrow(new Throwable[]{new RuntimeException("More Exceptions")});
        RefreshRegistry.defaultRegistry().register("exceptional", exceptionalHandler);
        RefreshRegistry.defaultRegistry().register("exceptional", otherExceptionalHandler);
        DFSAdmin admin = new DFSAdmin(config);
        String[] args = new String[]{"-refresh", "localhost:" + cluster.getNameNodePort(), "exceptional"};
        int exitCode = admin.run(args);
        Assertions.assertEquals((int)-1, (int)exitCode);
        ((RefreshHandler)Mockito.verify((Object)exceptionalHandler)).handleRefresh("exceptional", new String[0]);
        ((RefreshHandler)Mockito.verify((Object)otherExceptionalHandler)).handleRefresh("exceptional", new String[0]);
        RefreshRegistry.defaultRegistry().unregisterAll("exceptional");
    }
}

