/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.tools.DFSZKFailoverController;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Preconditions;

@InterfaceAudience.Private
public class NNHAServiceTarget
extends HAServiceTarget {
    private static final String NAMESERVICE_ID_KEY = "nameserviceid";
    private static final String NAMENODE_ID_KEY = "namenodeid";
    private final InetSocketAddress addr;
    private final InetSocketAddress lifelineAddr;
    private InetSocketAddress zkfcAddr;
    private NodeFencer fencer;
    private BadFencingConfigurationException fenceConfigError;
    private HdfsConfiguration targetConf;
    private String nnId;
    private String nsId;
    private boolean autoFailoverEnabled;

    public NNHAServiceTarget(Configuration conf, String nsId, String nnId) {
        this.initializeNnConfig(conf, nsId, nnId);
        String serviceAddr = DFSUtil.getNamenodeServiceAddr((Configuration)this.targetConf, nsId, nnId);
        if (serviceAddr == null) {
            throw new IllegalArgumentException("Unable to determine service address for namenode '" + nnId + "'");
        }
        this.addr = NetUtils.createSocketAddr((String)serviceAddr, (int)8020);
        String lifelineAddrStr = DFSUtil.getNamenodeLifelineAddr((Configuration)this.targetConf, nsId, nnId);
        this.lifelineAddr = lifelineAddrStr != null ? NetUtils.createSocketAddr((String)lifelineAddrStr) : null;
        this.initializeFailoverConfig();
    }

    public NNHAServiceTarget(Configuration conf, String nsId, String nnId, String addr, String lifelineAddr) {
        this.initializeNnConfig(conf, nsId, nnId);
        this.addr = NetUtils.createSocketAddr((String)addr);
        this.lifelineAddr = NetUtils.createSocketAddr((String)lifelineAddr);
        this.initializeFailoverConfig();
    }

    private void initializeNnConfig(Configuration conf, String providedNsId, String providedNnId) {
        Preconditions.checkNotNull((Object)providedNnId);
        if (providedNsId == null && (providedNsId = DFSUtil.getOnlyNameServiceIdOrNull(conf)) == null) {
            Object errorString = "Unable to determine the name service ID.";
            Object[] dfsNames = conf.getStrings("dfs.nameservices");
            if (dfsNames != null && dfsNames.length > 1) {
                errorString = "Unable to determine the name service ID. This is an HA configuration with multiple name services configured. dfs.nameservices is set to " + Arrays.toString(dfsNames) + ". Please re-run with the -ns option.";
            }
            throw new IllegalArgumentException((String)errorString);
        }
        this.targetConf = new HdfsConfiguration(conf);
        NameNode.initializeGenericKeys((Configuration)this.targetConf, providedNsId, providedNnId);
        this.nsId = providedNsId;
        this.nnId = providedNnId;
    }

    private void initializeFailoverConfig() {
        int port;
        this.autoFailoverEnabled = this.targetConf.getBoolean("dfs.ha.automatic-failover.enabled", false);
        if (this.autoFailoverEnabled && (port = DFSZKFailoverController.getZkfcPort((Configuration)this.targetConf)) != 0) {
            this.setZkfcPort(port);
        }
        try {
            this.fencer = NodeFencer.create((Configuration)this.targetConf, (String)"dfs.ha.fencing.methods");
        }
        catch (BadFencingConfigurationException e) {
            this.fenceConfigError = e;
        }
    }

    public InetSocketAddress getAddress() {
        return this.addr;
    }

    public InetSocketAddress getHealthMonitorAddress() {
        return this.lifelineAddr;
    }

    public InetSocketAddress getZKFCAddress() {
        Preconditions.checkState((boolean)this.autoFailoverEnabled, (Object)"ZKFC address not relevant when auto failover is off");
        assert (this.zkfcAddr != null);
        return this.zkfcAddr;
    }

    void setZkfcPort(int port) {
        assert (this.autoFailoverEnabled);
        this.zkfcAddr = new InetSocketAddress(this.addr.getAddress(), port);
    }

    public void checkFencingConfigured() throws BadFencingConfigurationException {
        if (this.fenceConfigError != null) {
            throw this.fenceConfigError;
        }
        if (this.fencer == null) {
            throw new BadFencingConfigurationException("No fencer configured for " + this);
        }
    }

    public NodeFencer getFencer() {
        return this.fencer;
    }

    public String toString() {
        return "NameNode at " + (this.lifelineAddr != null ? this.lifelineAddr : this.addr);
    }

    public String getNameServiceId() {
        return this.nsId;
    }

    public String getNameNodeId() {
        return this.nnId;
    }

    protected void addFencingParameters(Map<String, String> ret) {
        super.addFencingParameters(ret);
        ret.put(NAMESERVICE_ID_KEY, this.getNameServiceId());
        ret.put(NAMENODE_ID_KEY, this.getNameNodeId());
    }

    public boolean isAutoFailoverEnabled() {
        return this.autoFailoverEnabled;
    }

    public boolean supportObserver() {
        return true;
    }
}

