/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.fgl;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystemLock;
import org.apache.hadoop.hdfs.server.namenode.fgl.FSNLockManager;
import org.apache.hadoop.hdfs.util.RwLockMode;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;

public class FineGrainedFSNamesystemLock
implements FSNLockManager {
    private final FSNamesystemLock fsLock;
    private final FSNamesystemLock bmLock;

    public FineGrainedFSNamesystemLock(Configuration conf, MutableRatesWithAggregation aggregation) {
        this.fsLock = new FSNamesystemLock(conf, "FS", aggregation);
        this.bmLock = new FSNamesystemLock(conf, "BM", aggregation);
    }

    @Override
    public void readLock(RwLockMode lockMode) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            this.fsLock.readLock();
            this.bmLock.readLock();
        } else if (lockMode.equals((Object)RwLockMode.FS)) {
            this.fsLock.readLock();
        } else if (lockMode.equals((Object)RwLockMode.BM)) {
            this.bmLock.readLock();
        }
    }

    @Override
    public void readLockInterruptibly(RwLockMode lockMode) throws InterruptedException {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            this.fsLock.readLockInterruptibly();
            try {
                this.bmLock.readLockInterruptibly();
            }
            catch (InterruptedException e) {
                this.fsLock.readUnlock("BMReadLockInterruptiblyFailed");
                throw e;
            }
        } else if (lockMode.equals((Object)RwLockMode.FS)) {
            this.fsLock.readLockInterruptibly();
        } else if (lockMode.equals((Object)RwLockMode.BM)) {
            this.bmLock.readLockInterruptibly();
        }
    }

    @Override
    public void readUnlock(RwLockMode lockMode, String opName) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            this.bmLock.readUnlock(opName);
            this.fsLock.readUnlock(opName);
        } else if (lockMode.equals((Object)RwLockMode.FS)) {
            this.fsLock.readUnlock(opName);
        } else if (lockMode.equals((Object)RwLockMode.BM)) {
            this.bmLock.readUnlock(opName);
        }
    }

    @Override
    public void readUnlock(RwLockMode lockMode, String opName, Supplier<String> lockReportInfoSupplier) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            this.bmLock.readUnlock(opName, lockReportInfoSupplier);
            this.fsLock.readUnlock(opName, lockReportInfoSupplier);
        } else if (lockMode.equals((Object)RwLockMode.FS)) {
            this.fsLock.readUnlock(opName, lockReportInfoSupplier);
        } else if (lockMode.equals((Object)RwLockMode.BM)) {
            this.bmLock.readUnlock(opName, lockReportInfoSupplier);
        }
    }

    @Override
    public void writeLock(RwLockMode lockMode) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            this.fsLock.writeLock();
            this.bmLock.writeLock();
        } else if (lockMode.equals((Object)RwLockMode.FS)) {
            this.fsLock.writeLock();
        } else if (lockMode.equals((Object)RwLockMode.BM)) {
            this.bmLock.writeLock();
        }
    }

    @Override
    public void writeUnlock(RwLockMode lockMode, String opName) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            this.bmLock.writeUnlock(opName);
            this.fsLock.writeUnlock(opName);
        } else if (lockMode.equals((Object)RwLockMode.FS)) {
            this.fsLock.writeUnlock(opName);
        } else if (lockMode.equals((Object)RwLockMode.BM)) {
            this.bmLock.writeUnlock(opName);
        }
    }

    @Override
    public void writeUnlock(RwLockMode lockMode, String opName, boolean suppressWriteLockReport) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            this.bmLock.writeUnlock(opName, suppressWriteLockReport);
            this.fsLock.writeUnlock(opName, suppressWriteLockReport);
        } else if (lockMode.equals((Object)RwLockMode.FS)) {
            this.fsLock.writeUnlock(opName, suppressWriteLockReport);
        } else if (lockMode.equals((Object)RwLockMode.BM)) {
            this.bmLock.writeUnlock(opName, suppressWriteLockReport);
        }
    }

    @Override
    public void writeUnlock(RwLockMode lockMode, String opName, Supplier<String> lockReportInfoSupplier) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            this.bmLock.writeUnlock(opName, lockReportInfoSupplier);
            this.fsLock.writeUnlock(opName, lockReportInfoSupplier);
        } else if (lockMode.equals((Object)RwLockMode.FS)) {
            this.fsLock.writeUnlock(opName, lockReportInfoSupplier);
        } else if (lockMode.equals((Object)RwLockMode.BM)) {
            this.bmLock.writeUnlock(opName, lockReportInfoSupplier);
        }
    }

    @Override
    public void writeLockInterruptibly(RwLockMode lockMode) throws InterruptedException {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            this.fsLock.writeLockInterruptibly();
            try {
                this.bmLock.writeLockInterruptibly();
            }
            catch (InterruptedException e) {
                this.fsLock.writeUnlock("BMWriteLockInterruptiblyFailed");
                throw e;
            }
        } else if (lockMode.equals((Object)RwLockMode.FS)) {
            this.fsLock.writeLockInterruptibly();
        } else if (lockMode.equals((Object)RwLockMode.BM)) {
            this.bmLock.writeLockInterruptibly();
        }
    }

    @Override
    public boolean hasWriteLock(RwLockMode lockMode) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            return this.fsLock.isWriteLockedByCurrentThread() && this.bmLock.isWriteLockedByCurrentThread();
        }
        if (lockMode.equals((Object)RwLockMode.FS)) {
            return this.fsLock.isWriteLockedByCurrentThread();
        }
        if (lockMode.equals((Object)RwLockMode.BM)) {
            return this.bmLock.isWriteLockedByCurrentThread();
        }
        return false;
    }

    @Override
    public boolean hasReadLock(RwLockMode lockMode) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            return this.hasWriteLock(RwLockMode.GLOBAL) || this.fsLock.getReadHoldCount() > 0 && this.bmLock.getReadHoldCount() > 0;
        }
        if (lockMode.equals((Object)RwLockMode.FS)) {
            return this.fsLock.getReadHoldCount() > 0 || this.fsLock.isWriteLockedByCurrentThread();
        }
        if (lockMode.equals((Object)RwLockMode.BM)) {
            return this.bmLock.getReadHoldCount() > 0 || this.bmLock.isWriteLockedByCurrentThread();
        }
        return false;
    }

    @Override
    public int getReadHoldCount(RwLockMode lockMode) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            return this.fsLock.getReadHoldCount();
        }
        if (lockMode.equals((Object)RwLockMode.FS)) {
            return this.fsLock.getReadHoldCount();
        }
        if (lockMode.equals((Object)RwLockMode.BM)) {
            return this.bmLock.getReadHoldCount();
        }
        return -1;
    }

    @Override
    public int getQueueLength(RwLockMode lockMode) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            return -1;
        }
        if (lockMode.equals((Object)RwLockMode.FS)) {
            return this.fsLock.getQueueLength();
        }
        if (lockMode.equals((Object)RwLockMode.BM)) {
            return this.bmLock.getQueueLength();
        }
        return -1;
    }

    @Override
    public long getNumOfReadLockLongHold(RwLockMode lockMode) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            return -1L;
        }
        if (lockMode.equals((Object)RwLockMode.FS)) {
            return this.fsLock.getNumOfReadLockLongHold();
        }
        if (lockMode.equals((Object)RwLockMode.BM)) {
            return this.bmLock.getNumOfReadLockLongHold();
        }
        return -1L;
    }

    @Override
    public long getNumOfWriteLockLongHold(RwLockMode lockMode) {
        if (lockMode.equals((Object)RwLockMode.GLOBAL)) {
            return -1L;
        }
        if (lockMode.equals((Object)RwLockMode.FS)) {
            return this.fsLock.getNumOfWriteLockLongHold();
        }
        if (lockMode.equals((Object)RwLockMode.BM)) {
            return this.bmLock.getNumOfWriteLockLongHold();
        }
        return -1L;
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.fsLock.isMetricsEnabled();
    }

    @Override
    public void setMetricsEnabled(boolean metricsEnabled) {
        this.fsLock.setMetricsEnabled(metricsEnabled);
        this.bmLock.setMetricsEnabled(metricsEnabled);
    }

    @Override
    public void setReadLockReportingThresholdMs(long readLockReportingThresholdMs) {
        this.fsLock.setReadLockReportingThresholdMs(readLockReportingThresholdMs);
        this.bmLock.setReadLockReportingThresholdMs(readLockReportingThresholdMs);
    }

    @Override
    public long getReadLockReportingThresholdMs() {
        return this.fsLock.getReadLockReportingThresholdMs();
    }

    @Override
    public void setWriteLockReportingThresholdMs(long writeLockReportingThresholdMs) {
        this.fsLock.setWriteLockReportingThresholdMs(writeLockReportingThresholdMs);
        this.bmLock.setWriteLockReportingThresholdMs(writeLockReportingThresholdMs);
    }

    @Override
    public long getWriteLockReportingThresholdMs() {
        return this.fsLock.getWriteLockReportingThresholdMs();
    }

    @Override
    public void setLockForTests(ReentrantReadWriteLock lock) {
        throw new UnsupportedOperationException("SetLockTests is unsupported");
    }

    @Override
    public ReentrantReadWriteLock getLockForTests() {
        throw new UnsupportedOperationException("SetLockTests is unsupported");
    }
}

