/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import java.io.PrintStream;
import java.util.Collections;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.TextStringBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.tools.DiskBalancerCLI;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Preconditions;

public class QueryCommand
extends Command {
    public QueryCommand(Configuration conf) {
        this(conf, System.out);
    }

    public QueryCommand(Configuration conf, PrintStream ps) {
        super(conf, ps);
        this.addValidCommandParameters("query", "Queries the status of disk plan running on given datanode(s).");
        this.addValidCommandParameters("v", "Prints verbose results.");
    }

    @Override
    public void execute(CommandLine cmd) throws Exception {
        LOG.info("Executing \"query plan\" command.");
        TextStringBuilder result = new TextStringBuilder();
        Preconditions.checkState((boolean)cmd.hasOption("query"));
        this.verifyCommandOptions("query", cmd);
        String nodeVal = cmd.getOptionValue("query");
        if (StringUtils.isBlank((CharSequence)nodeVal)) {
            String warnMsg = "The number of input nodes is 0. Please input the valid nodes.";
            throw new DiskBalancerException(warnMsg, DiskBalancerException.Result.INVALID_NODE);
        }
        nodeVal = nodeVal.trim();
        TreeSet resultSet = new TreeSet();
        String[] nodes = nodeVal.split(",");
        Collections.addAll(resultSet, nodes);
        String outputLine = String.format("Get current status of the diskbalancer for DataNode(s). These DataNode(s) are parsed from '%s'.", nodeVal);
        this.recordOutput(result, outputLine);
        for (String nodeName : resultSet) {
            Object nodeAddress = nodeName;
            if (!nodeName.matches("[^\\:]+:[0-9]{2,5}")) {
                int defaultIPC = NetUtils.createSocketAddr((String)this.getConf().getTrimmed("dfs.datanode.ipc.address", "0.0.0.0:9867")).getPort();
                nodeAddress = nodeName + ":" + defaultIPC;
                LOG.debug("Using default data node port :  {}", nodeAddress);
            }
            ClientDatanodeProtocol dataNode = this.getDataNodeProxy((String)nodeAddress);
            try {
                DiskBalancerWorkStatus workStatus = dataNode.queryDiskBalancerPlan();
                outputLine = String.format("DataNode: %s%nPlan File: %s%nPlan ID: %s%nResult: %s%n", nodeAddress, workStatus.getPlanFile(), workStatus.getPlanID(), workStatus.getResult().toString());
                result.append(outputLine);
                if (cmd.hasOption("v")) {
                    outputLine = String.format("%s", workStatus.currentStateString());
                    result.append(outputLine);
                }
                result.append(System.lineSeparator());
            }
            catch (DiskBalancerException ex) {
                LOG.error("Query plan failed by {}", nodeAddress, (Object)ex);
                throw ex;
            }
        }
        this.getPrintStream().println(result);
    }

    @Override
    public void printHelp() {
        String header = "Query Plan queries given datanode(s) about the current state of disk balancer execution.\n\n";
        String footer = "\nQuery command retrievs the plan ID and the current running state. ";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("hdfs diskbalancer -query <hostname,hostname,...>  [options]", header, DiskBalancerCLI.getQueryOptions(), footer);
    }
}

