/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.metrics;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.metrics.OutlierDetector;
import org.apache.hadoop.hdfs.server.protocol.OutlierMetrics;
import org.apache.hadoop.metrics2.MetricsJsonBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableRollingAverages;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DataNodePeerMetrics {
    public static final Logger LOG = LoggerFactory.getLogger(DataNodePeerMetrics.class);
    private final MutableRollingAverages sendPacketDownstreamRollingAverages;
    private final String name;
    private Map<String, OutlierMetrics> testOutlier = null;
    private final OutlierDetector slowNodeDetector;
    private volatile long minOutlierDetectionSamples;
    private volatile long lowThresholdMs;
    private volatile long minOutlierDetectionNodes;

    public DataNodePeerMetrics(String name, Configuration conf) {
        this.name = name;
        this.minOutlierDetectionSamples = conf.getLong("dfs.datanode.peer.metrics.min.outlier.detection.samples", 1000L);
        this.lowThresholdMs = conf.getLong("dfs.datanode.slowpeer.low.threshold.ms", 5L);
        this.minOutlierDetectionNodes = conf.getLong("dfs.datanode.min.outlier.detection.nodes", 10L);
        this.slowNodeDetector = new OutlierDetector(this.minOutlierDetectionNodes, this.lowThresholdMs);
        this.sendPacketDownstreamRollingAverages = new MutableRollingAverages("Time");
    }

    public String name() {
        return this.name;
    }

    public long getMinOutlierDetectionSamples() {
        return this.minOutlierDetectionSamples;
    }

    public static DataNodePeerMetrics create(String dnName, Configuration conf) {
        String name = "DataNodePeerActivity-" + (String)(dnName.isEmpty() ? "UndefinedDataNodeName" + ThreadLocalRandom.current().nextInt() : dnName.replace(':', '-'));
        return new DataNodePeerMetrics(name, conf);
    }

    public void addSendPacketDownstream(String peerAddr, long elapsedMs) {
        this.sendPacketDownstreamRollingAverages.add(peerAddr, elapsedMs);
    }

    public String dumpSendPacketDownstreamAvgInfoAsJson() {
        MetricsJsonBuilder builder = new MetricsJsonBuilder(null);
        this.sendPacketDownstreamRollingAverages.snapshot((MetricsRecordBuilder)builder, true);
        return builder.toString();
    }

    public void collectThreadLocalStates() {
        this.sendPacketDownstreamRollingAverages.collectThreadLocalStates();
    }

    public Map<String, OutlierMetrics> getOutliers() {
        if (this.testOutlier == null) {
            Map stats = this.sendPacketDownstreamRollingAverages.getStats(this.minOutlierDetectionSamples);
            LOG.trace("DataNodePeerMetrics: Got stats: {}", (Object)stats);
            return this.slowNodeDetector.getOutlierMetrics(stats);
        }
        return this.testOutlier;
    }

    public void setTestOutliers(Map<String, OutlierMetrics> outlier) {
        this.testOutlier = outlier;
    }

    public MutableRollingAverages getSendPacketDownstreamRollingAverages() {
        return this.sendPacketDownstreamRollingAverages;
    }

    public void setMinOutlierDetectionNodes(long minNodes) {
        Preconditions.checkArgument((minNodes > 0L ? 1 : 0) != 0, (Object)"dfs.datanode.min.outlier.detection.nodes should be larger than 0");
        this.minOutlierDetectionNodes = minNodes;
        this.slowNodeDetector.setMinNumResources(minNodes);
    }

    public long getMinOutlierDetectionNodes() {
        return this.minOutlierDetectionNodes;
    }

    public void setLowThresholdMs(long thresholdMs) {
        Preconditions.checkArgument((thresholdMs > 0L ? 1 : 0) != 0, (Object)"dfs.datanode.slowpeer.low.threshold.ms should be larger than 0");
        this.lowThresholdMs = thresholdMs;
        this.slowNodeDetector.setLowThresholdMs(thresholdMs);
    }

    public long getLowThresholdMs() {
        return this.lowThresholdMs;
    }

    public void setMinOutlierDetectionSamples(long minSamples) {
        Preconditions.checkArgument((minSamples > 0L ? 1 : 0) != 0, (Object)"dfs.datanode.peer.metrics.min.outlier.detection.samples should be larger than 0");
        this.minOutlierDetectionSamples = minSamples;
    }

    @VisibleForTesting
    public OutlierDetector getSlowNodeDetector() {
        return this.slowNodeDetector;
    }
}

