/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.common.blockaliasmap.impl;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ProvidedStorageLocation;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMap;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class LevelDBFileRegionAliasMap
extends BlockAliasMap<FileRegion>
implements Configurable {
    private Configuration conf;
    private LevelDBOptions opts = new LevelDBOptions();
    public static final Logger LOG = LoggerFactory.getLogger(LevelDBFileRegionAliasMap.class);

    public void setConf(Configuration conf) {
        this.opts.setConf(conf);
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public BlockAliasMap.Reader<FileRegion> getReader(BlockAliasMap.Reader.Options opts, String blockPoolID) throws IOException {
        if (null == opts) {
            opts = this.opts;
        }
        if (!(opts instanceof LevelDBOptions)) {
            throw new IllegalArgumentException("Invalid options " + opts.getClass());
        }
        LevelDBOptions o = (LevelDBOptions)opts;
        return new LevelDBReader(LevelDBFileRegionAliasMap.createDB(o.levelDBPath, false, blockPoolID));
    }

    @Override
    public BlockAliasMap.Writer<FileRegion> getWriter(BlockAliasMap.Writer.Options opts, String blockPoolID) throws IOException {
        if (null == opts) {
            opts = this.opts;
        }
        if (!(opts instanceof LevelDBOptions)) {
            throw new IllegalArgumentException("Invalid options " + opts.getClass());
        }
        LevelDBOptions o = (LevelDBOptions)opts;
        return new LevelDBWriter(LevelDBFileRegionAliasMap.createDB(o.levelDBPath, true, blockPoolID));
    }

    private static DB createDB(String levelDBPath, boolean createIfMissing, String blockPoolID) throws IOException {
        if (levelDBPath == null || levelDBPath.length() == 0) {
            throw new IllegalArgumentException("A valid path needs to be specified for " + LevelDBFileRegionAliasMap.class + " using the parameter dfs.provided.aliasmap.leveldb.path");
        }
        Options options = new Options();
        options.createIfMissing(createIfMissing);
        File dbFile = blockPoolID != null ? new File(levelDBPath, blockPoolID) : new File(levelDBPath);
        if (createIfMissing && !dbFile.exists() && !dbFile.mkdirs()) {
            throw new IOException("Unable to create " + dbFile);
        }
        return JniDBFactory.factory.open(dbFile, options);
    }

    @Override
    public void refresh() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    public static class LevelDBOptions
    implements LevelDBReader.Options,
    LevelDBWriter.Options,
    Configurable {
        private Configuration conf;
        private String levelDBPath;

        public void setConf(Configuration conf) {
            this.conf = conf;
            this.levelDBPath = conf.get("dfs.provided.aliasmap.leveldb.path");
        }

        public Configuration getConf() {
            return this.conf;
        }

        @Override
        public LevelDBOptions filename(String levelDBPath) {
            this.levelDBPath = levelDBPath;
            return this;
        }
    }

    public static class LevelDBReader
    extends BlockAliasMap.Reader<FileRegion> {
        private DB db;

        LevelDBReader(DB db) {
            this.db = db;
        }

        @Override
        public Optional<FileRegion> resolve(Block block) throws IOException {
            if (this.db == null) {
                return Optional.empty();
            }
            byte[] key = InMemoryAliasMap.toProtoBufBytes(block);
            byte[] value = this.db.get(key);
            ProvidedStorageLocation psl = InMemoryAliasMap.fromProvidedStorageLocationBytes(value);
            return Optional.of(new FileRegion(block, psl));
        }

        @Override
        public Iterator<FileRegion> iterator() {
            if (this.db == null) {
                return null;
            }
            DBIterator iterator = this.db.iterator();
            iterator.seekToFirst();
            return new FRIterator(iterator);
        }

        @Override
        public void close() throws IOException {
            if (this.db != null) {
                this.db.close();
            }
        }

        static class FRIterator
        implements Iterator<FileRegion> {
            private final DBIterator internal;

            FRIterator(DBIterator internal) {
                this.internal = internal;
            }

            @Override
            public boolean hasNext() {
                return this.internal.hasNext();
            }

            @Override
            public FileRegion next() {
                Map.Entry entry = (Map.Entry)this.internal.next();
                if (entry == null) {
                    return null;
                }
                try {
                    Block block = InMemoryAliasMap.fromBlockBytes((byte[])entry.getKey());
                    ProvidedStorageLocation psl = InMemoryAliasMap.fromProvidedStorageLocationBytes((byte[])entry.getValue());
                    return new FileRegion(block, psl);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        public static interface Options
        extends BlockAliasMap.Reader.Options {
            public Options filename(String var1);
        }
    }

    public static class LevelDBWriter
    extends BlockAliasMap.Writer<FileRegion> {
        private final DB db;

        LevelDBWriter(DB db) {
            this.db = db;
        }

        @Override
        public void store(FileRegion token) throws IOException {
            byte[] key = InMemoryAliasMap.toProtoBufBytes(token.getBlock());
            byte[] value = InMemoryAliasMap.toProtoBufBytes(token.getProvidedStorageLocation());
            this.db.put(key, value);
        }

        @Override
        public void close() throws IOException {
            if (this.db != null) {
                this.db.close();
            }
        }

        public static interface Options
        extends BlockAliasMap.Writer.Options {
            public Options filename(String var1);
        }
    }
}

