/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.thirdparty.com.google.common.primitives.Doubles;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SlowDiskTracker {
    public static final Logger LOG = LoggerFactory.getLogger(SlowDiskTracker.class);
    private long reportValidityMs;
    private final Timer timer;
    private static final ObjectWriter WRITER = new ObjectMapper().writer();
    private final int maxDisksToReport;
    private static final String DATANODE_DISK_SEPARATOR = ":";
    private final long reportGenerationIntervalMs;
    private volatile long lastUpdateTime;
    private AtomicBoolean isUpdateInProgress = new AtomicBoolean(false);
    private final Map<String, DiskLatency> diskIDLatencyMap;
    private volatile ArrayList<DiskLatency> slowDisksReport = Lists.newArrayList();
    private volatile ArrayList<DiskLatency> oldSlowDisksCheck;

    public SlowDiskTracker(Configuration conf, Timer timer) {
        this.timer = timer;
        this.lastUpdateTime = timer.monotonicNow();
        this.diskIDLatencyMap = new ConcurrentHashMap<String, DiskLatency>();
        this.reportGenerationIntervalMs = conf.getTimeDuration("dfs.datanode.outliers.report.interval", "30m", TimeUnit.MILLISECONDS);
        this.maxDisksToReport = conf.getInt("dfs.datanode.max.disks.to.report", 5);
        this.reportValidityMs = this.reportGenerationIntervalMs * 3L;
    }

    @VisibleForTesting
    public static String getSlowDiskIDForReport(String datanodeID, String slowDisk) {
        return datanodeID + DATANODE_DISK_SEPARATOR + slowDisk;
    }

    public void addSlowDiskReport(String dataNodeID, SlowDiskReports dnSlowDiskReport) {
        Map slowDisks = dnSlowDiskReport.getSlowDisks();
        long now = this.timer.monotonicNow();
        for (Map.Entry slowDiskEntry : slowDisks.entrySet()) {
            String diskID = SlowDiskTracker.getSlowDiskIDForReport(dataNodeID, (String)slowDiskEntry.getKey());
            Map latencies = (Map)slowDiskEntry.getValue();
            DiskLatency diskLatency = new DiskLatency(diskID, latencies, now);
            this.diskIDLatencyMap.put(diskID, diskLatency);
        }
    }

    public void checkAndUpdateReportIfNecessary() {
        long now = this.timer.monotonicNow();
        if (now - this.lastUpdateTime > this.reportGenerationIntervalMs) {
            this.updateSlowDiskReportAsync(now);
        }
    }

    @VisibleForTesting
    public void updateSlowDiskReportAsync(final long now) {
        if (this.isUpdateInProgress.compareAndSet(false, true)) {
            this.lastUpdateTime = now;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SlowDiskTracker.this.slowDisksReport = SlowDiskTracker.this.getSlowDisks(SlowDiskTracker.this.diskIDLatencyMap, SlowDiskTracker.this.maxDisksToReport, now);
                    SlowDiskTracker.this.cleanUpOldReports(now);
                    SlowDiskTracker.this.isUpdateInProgress.set(false);
                }
            }).start();
        }
    }

    private ArrayList<DiskLatency> getSlowDisks(Map<String, DiskLatency> reports, int numDisks, long now) {
        if (reports.isEmpty()) {
            return new ArrayList<DiskLatency>((Collection<DiskLatency>)ImmutableList.of());
        }
        PriorityQueue<DiskLatency> topNReports = new PriorityQueue<DiskLatency>(reports.size(), new Comparator<DiskLatency>(){

            @Override
            public int compare(DiskLatency o1, DiskLatency o2) {
                return Doubles.compare((double)o1.getMaxLatency(), (double)o2.getMaxLatency());
            }
        });
        ArrayList oldSlowDiskIDs = Lists.newArrayList();
        for (Map.Entry<String, DiskLatency> entry : reports.entrySet()) {
            DiskLatency diskLatency = entry.getValue();
            if (now - diskLatency.timestamp < this.reportValidityMs) {
                if (topNReports.size() < numDisks) {
                    topNReports.add(diskLatency);
                    continue;
                }
                if (!(topNReports.peek().getMaxLatency() < diskLatency.getMaxLatency())) continue;
                topNReports.poll();
                topNReports.add(diskLatency);
                continue;
            }
            oldSlowDiskIDs.add(diskLatency);
        }
        this.oldSlowDisksCheck = oldSlowDiskIDs;
        return Lists.newArrayList(topNReports);
    }

    public String getSlowDiskReportAsJsonString() {
        try {
            if (this.slowDisksReport.isEmpty()) {
                return null;
            }
            return WRITER.writeValueAsString(this.slowDisksReport);
        }
        catch (JsonProcessingException e) {
            LOG.debug("Failed to serialize statistics" + e);
            return null;
        }
    }

    private void cleanUpOldReports(long now) {
        if (this.oldSlowDisksCheck != null) {
            for (DiskLatency oldDiskLatency : this.oldSlowDisksCheck) {
                this.diskIDLatencyMap.remove(oldDiskLatency.getSlowDiskID(), oldDiskLatency);
            }
        }
        this.oldSlowDisksCheck = null;
    }

    @VisibleForTesting
    ArrayList<DiskLatency> getSlowDisksReport() {
        return this.slowDisksReport;
    }

    @VisibleForTesting
    long getReportValidityMs() {
        return this.reportValidityMs;
    }

    @VisibleForTesting
    void setReportValidityMs(long reportValidityMs) {
        this.reportValidityMs = reportValidityMs;
    }

    public static class DiskLatency {
        @JsonProperty(value="SlowDiskID")
        private final String slowDiskID;
        @JsonProperty(value="Latencies")
        private final Map<SlowDiskReports.DiskOp, Double> latencyMap;
        @JsonIgnore
        private long timestamp;

        public DiskLatency(@JsonProperty(value="SlowDiskID") String slowDiskID, @JsonProperty(value="Latencies") Map<SlowDiskReports.DiskOp, Double> latencyMap) {
            this.slowDiskID = slowDiskID;
            this.latencyMap = latencyMap;
        }

        public DiskLatency(String slowDiskID, Map<SlowDiskReports.DiskOp, Double> latencyMap, long timestamp) {
            this.slowDiskID = slowDiskID;
            this.latencyMap = latencyMap;
            this.timestamp = timestamp;
        }

        String getSlowDiskID() {
            return this.slowDiskID;
        }

        double getMaxLatency() {
            double maxLatency = 0.0;
            for (double latency : this.latencyMap.values()) {
                if (!(latency > maxLatency)) continue;
                maxLatency = latency;
            }
            return maxLatency;
        }

        Double getLatency(SlowDiskReports.DiskOp op) {
            return this.latencyMap.get(op);
        }
    }
}

