/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import java.util.Collections;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.server.balancer.Balancer;
import org.apache.hadoop.hdfs.server.balancer.BalancingPolicy;

@InterfaceAudience.Private
final class BalancerParameters {
    private final BalancingPolicy policy;
    private final double threshold;
    private final int maxIdleIteration;
    private final long hotBlockTimeInterval;
    private final Set<String> excludedNodes;
    private final Set<String> includedNodes;
    private final Set<String> sourceNodes;
    private final Set<String> excludedSourceNodes;
    private final Set<String> targetNodes;
    private final Set<String> excludedTargetNodes;
    private final Set<String> blockpools;
    private final boolean runDuringUpgrade;
    private final boolean runAsService;
    private final boolean sortTopNodes;
    private final int limitOverUtilizedNum;
    static final BalancerParameters DEFAULT = new BalancerParameters();

    private BalancerParameters() {
        this(new Builder());
    }

    private BalancerParameters(Builder builder) {
        this.policy = builder.policy;
        this.threshold = builder.threshold;
        this.maxIdleIteration = builder.maxIdleIteration;
        this.excludedNodes = builder.excludedNodes;
        this.includedNodes = builder.includedNodes;
        this.sourceNodes = builder.sourceNodes;
        this.excludedSourceNodes = builder.excludedSourceNodes;
        this.targetNodes = builder.targetNodes;
        this.excludedTargetNodes = builder.excludedTargetNodes;
        this.blockpools = builder.blockpools;
        this.runDuringUpgrade = builder.runDuringUpgrade;
        this.runAsService = builder.runAsService;
        this.sortTopNodes = builder.sortTopNodes;
        this.limitOverUtilizedNum = builder.limitOverUtilizedNum;
        this.hotBlockTimeInterval = builder.hotBlockTimeInterval;
    }

    BalancingPolicy getBalancingPolicy() {
        return this.policy;
    }

    double getThreshold() {
        return this.threshold;
    }

    int getMaxIdleIteration() {
        return this.maxIdleIteration;
    }

    Set<String> getExcludedNodes() {
        return this.excludedNodes;
    }

    Set<String> getIncludedNodes() {
        return this.includedNodes;
    }

    Set<String> getSourceNodes() {
        return this.sourceNodes;
    }

    Set<String> getExcludedSourceNodes() {
        return this.excludedSourceNodes;
    }

    Set<String> getTargetNodes() {
        return this.targetNodes;
    }

    Set<String> getExcludedTargetNodes() {
        return this.excludedTargetNodes;
    }

    Set<String> getBlockPools() {
        return this.blockpools;
    }

    boolean getRunDuringUpgrade() {
        return this.runDuringUpgrade;
    }

    boolean getRunAsService() {
        return this.runAsService;
    }

    boolean getSortTopNodes() {
        return this.sortTopNodes;
    }

    int getLimitOverUtilizedNum() {
        return this.limitOverUtilizedNum;
    }

    long getHotBlockTimeInterval() {
        return this.hotBlockTimeInterval;
    }

    public String toString() {
        return String.format("%s.%s [%s, threshold = %s, max idle iteration = %s, #excluded nodes = %s, #included nodes = %s, #source nodes = %s, #excluded source nodes = %s, #target nodes = %s, #excluded target nodes = %s, #blockpools = %s, run during upgrade = %s, sort top nodes = %s, limit overUtilized nodes num = %s, hot block time interval = %s]", Balancer.class.getSimpleName(), this.getClass().getSimpleName(), this.policy, this.threshold, this.maxIdleIteration, this.excludedNodes.size(), this.includedNodes.size(), this.sourceNodes.size(), this.excludedSourceNodes.size(), this.targetNodes.size(), this.excludedTargetNodes.size(), this.blockpools.size(), this.runDuringUpgrade, this.sortTopNodes, this.limitOverUtilizedNum, this.hotBlockTimeInterval);
    }

    static class Builder {
        private BalancingPolicy policy = BalancingPolicy.Node.INSTANCE;
        private double threshold = 10.0;
        private int maxIdleIteration = 5;
        private Set<String> excludedNodes = Collections.emptySet();
        private Set<String> includedNodes = Collections.emptySet();
        private Set<String> sourceNodes = Collections.emptySet();
        private Set<String> excludedSourceNodes = Collections.emptySet();
        private Set<String> targetNodes = Collections.emptySet();
        private Set<String> excludedTargetNodes = Collections.emptySet();
        private Set<String> blockpools = Collections.emptySet();
        private boolean runDuringUpgrade = false;
        private boolean runAsService = false;
        private boolean sortTopNodes = false;
        private int limitOverUtilizedNum = Integer.MAX_VALUE;
        private long hotBlockTimeInterval = 0L;

        Builder() {
        }

        Builder setBalancingPolicy(BalancingPolicy p) {
            this.policy = p;
            return this;
        }

        Builder setThreshold(double t) {
            this.threshold = t;
            return this;
        }

        Builder setMaxIdleIteration(int m) {
            this.maxIdleIteration = m;
            return this;
        }

        Builder setHotBlockTimeInterval(long t) {
            this.hotBlockTimeInterval = t;
            return this;
        }

        Builder setExcludedNodes(Set<String> nodes) {
            this.excludedNodes = nodes;
            return this;
        }

        Builder setIncludedNodes(Set<String> nodes) {
            this.includedNodes = nodes;
            return this;
        }

        Builder setSourceNodes(Set<String> nodes) {
            this.sourceNodes = nodes;
            return this;
        }

        Builder setExcludedSourceNodes(Set<String> nodes) {
            this.excludedSourceNodes = nodes;
            return this;
        }

        Builder setTargetNodes(Set<String> nodes) {
            this.targetNodes = nodes;
            return this;
        }

        Builder setExcludedTargetNodes(Set<String> nodes) {
            this.excludedTargetNodes = nodes;
            return this;
        }

        Builder setBlockpools(Set<String> pools) {
            this.blockpools = pools;
            return this;
        }

        Builder setRunDuringUpgrade(boolean run) {
            this.runDuringUpgrade = run;
            return this;
        }

        Builder setRunAsService(boolean asService) {
            this.runAsService = asService;
            return this;
        }

        Builder setSortTopNodes(boolean shouldSortTopNodes) {
            this.sortTopNodes = shouldSortTopNodes;
            return this;
        }

        Builder setLimitOverUtilizedNum(int overUtilizedNum) {
            this.limitOverUtilizedNum = overUtilizedNum;
            return this;
        }

        BalancerParameters build() {
            return new BalancerParameters(this);
        }
    }
}

