/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class LayoutVersion {
    public static final int BUGFIX_HDFS_2991_VERSION = -40;

    public static void updateMap(Map<Integer, SortedSet<LayoutFeature>> map, LayoutFeature[] features) {
        TreeSet<LayoutFeature> existingFeatures = new TreeSet<LayoutFeature>(new LayoutFeatureComparator());
        for (SortedSet<LayoutFeature> s : map.values()) {
            existingFeatures.addAll(s);
        }
        LayoutFeature prevF = existingFeatures.isEmpty() ? null : (LayoutFeature)existingFeatures.first();
        for (LayoutFeature f : features) {
            FeatureInfo info = f.getInfo();
            int minCompatLV = info.getMinimumCompatibleLayoutVersion();
            if (prevF != null && minCompatLV > prevF.getInfo().getMinimumCompatibleLayoutVersion()) {
                throw new AssertionError((Object)String.format("Features must be listed in order of minimum compatible layout version.  Check features %s and %s.", prevF, f));
            }
            prevF = f;
            SortedSet<LayoutFeature> ancestorSet = map.get(info.getAncestorLayoutVersion());
            if (ancestorSet == null) {
                ancestorSet = new TreeSet<LayoutFeature>(new LayoutFeatureComparator());
                map.put(info.getAncestorLayoutVersion(), ancestorSet);
            }
            TreeSet<LayoutFeature> featureSet = new TreeSet<LayoutFeature>(ancestorSet);
            if (info.getSpecialFeatures() != null) {
                for (LayoutFeature specialFeature : info.getSpecialFeatures()) {
                    featureSet.add(specialFeature);
                }
            }
            featureSet.add(f);
            map.put(info.getLayoutVersion(), featureSet);
        }
    }

    public String getString(Map<Integer, SortedSet<LayoutFeature>> map, LayoutFeature[] values) {
        FeatureInfo info;
        StringBuilder buf = new StringBuilder();
        buf.append("Feature List:\n");
        for (LayoutFeature f : values) {
            info = f.getInfo();
            buf.append(f).append(" introduced in layout version ").append(info.getLayoutVersion()).append(" (").append(info.getDescription()).append(")\n");
        }
        buf.append("\n\nLayoutVersion and supported features:\n");
        for (LayoutFeature f : values) {
            info = f.getInfo();
            buf.append(info.getLayoutVersion()).append(": ").append(map.get(info.getLayoutVersion())).append("\n");
        }
        return buf.toString();
    }

    public static boolean supports(Map<Integer, SortedSet<LayoutFeature>> map, LayoutFeature f, int lv) {
        SortedSet<LayoutFeature> set = map.get(lv);
        return set != null && set.contains(f);
    }

    public static int getCurrentLayoutVersion(LayoutFeature[] features) {
        return LayoutVersion.getLastNonReservedFeature(features).getInfo().getLayoutVersion();
    }

    public static int getMinimumCompatibleLayoutVersion(LayoutFeature[] features) {
        return LayoutVersion.getLastNonReservedFeature(features).getInfo().getMinimumCompatibleLayoutVersion();
    }

    static LayoutFeature getLastNonReservedFeature(LayoutFeature[] features) {
        for (int i = features.length - 1; i >= 0; --i) {
            FeatureInfo info = features[i].getInfo();
            if (info.isReservedForOldRelease()) continue;
            return features[i];
        }
        throw new AssertionError((Object)"All layout versions are reserved.");
    }

    static class LayoutFeatureComparator
    implements Comparator<LayoutFeature> {
        LayoutFeatureComparator() {
        }

        @Override
        public int compare(LayoutFeature arg0, LayoutFeature arg1) {
            return arg0.getInfo().getLayoutVersion() - arg1.getInfo().getLayoutVersion();
        }
    }

    public static interface LayoutFeature {
        public FeatureInfo getInfo();
    }

    public static class FeatureInfo {
        private final int lv;
        private final int ancestorLV;
        private final Integer minCompatLV;
        private final String description;
        private final boolean reserved;
        private final LayoutFeature[] specialFeatures;

        public FeatureInfo(int lv, int ancestorLV, String description, boolean reserved, LayoutFeature ... specialFeatures) {
            this(lv, ancestorLV, null, description, reserved, specialFeatures);
        }

        public FeatureInfo(int lv, int ancestorLV, Integer minCompatLV, String description, boolean reserved, LayoutFeature ... specialFeatures) {
            this.lv = lv;
            this.ancestorLV = ancestorLV;
            this.minCompatLV = minCompatLV;
            this.description = description;
            this.reserved = reserved;
            this.specialFeatures = specialFeatures;
        }

        public int getLayoutVersion() {
            return this.lv;
        }

        public int getAncestorLayoutVersion() {
            return this.ancestorLV;
        }

        public int getMinimumCompatibleLayoutVersion() {
            return this.minCompatLV != null ? this.minCompatLV : this.lv;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isReservedForOldRelease() {
            return this.reserved;
        }

        public LayoutFeature[] getSpecialFeatures() {
            return this.specialFeatures;
        }
    }

    public static enum Feature implements LayoutFeature
    {
        NAMESPACE_QUOTA(-16, "Support for namespace quotas"),
        FILE_ACCESS_TIME(-17, "Support for access time on files"),
        DISKSPACE_QUOTA(-18, "Support for disk space quotas"),
        STICKY_BIT(-19, "Support for sticky bits"),
        APPEND_RBW_DIR(-20, "Datanode has \"rbw\" subdirectory for append"),
        ATOMIC_RENAME(-21, "Support for atomic rename"),
        CONCAT(-22, "Support for concat operation"),
        SYMLINKS(-23, "Support for symbolic links"),
        DELEGATION_TOKEN(-24, "Support for delegation tokens for security"),
        FSIMAGE_COMPRESSION(-25, "Support for fsimage compression"),
        FSIMAGE_CHECKSUM(-26, "Support checksum for fsimage"),
        REMOVE_REL13_DISK_LAYOUT_SUPPORT(-27, "Remove support for 0.13 disk layout"),
        EDITS_CHECKSUM(-28, "Support checksum for editlog"),
        UNUSED(-29, "Skipped version"),
        FSIMAGE_NAME_OPTIMIZATION(-30, "Store only last part of path in fsimage"),
        RESERVED_REL20_203(-31, -19, "Reserved for release 0.20.203", true, DELEGATION_TOKEN),
        RESERVED_REL20_204(-32, -31, "Reserved for release 0.20.204", true, new Feature[0]),
        RESERVED_REL22(-33, -27, "Reserved for release 0.22", true, new Feature[0]),
        RESERVED_REL23(-34, -30, "Reserved for release 0.23", true, new Feature[0]),
        FEDERATION(-35, "Support for namenode federation"),
        LEASE_REASSIGNMENT(-36, "Support for persisting lease holder reassignment"),
        STORED_TXIDS(-37, "Transaction IDs are stored in edits log and image files"),
        TXID_BASED_LAYOUT(-38, "File names in NN Storage are based on transaction IDs"),
        EDITLOG_OP_OPTIMIZATION(-39, "Use LongWritable and ShortWritable directly instead of ArrayWritable of UTF8"),
        OPTIMIZE_PERSIST_BLOCKS(-40, "Serialize block lists with delta-encoded variable length ints, add OP_UPDATE_BLOCKS"),
        RESERVED_REL1_2_0(-41, -32, "Reserved for release 1.2.0", true, CONCAT),
        ADD_INODE_ID(-42, -40, "Assign a unique inode id for each inode", false, new Feature[0]),
        SNAPSHOT(-43, "Support for snapshot feature"),
        RESERVED_REL1_3_0(-44, -41, "Reserved for release 1.3.0", true, ADD_INODE_ID, SNAPSHOT, FSIMAGE_NAME_OPTIMIZATION),
        OPTIMIZE_SNAPSHOT_INODES(-45, -43, "Reduce snapshot inode memory footprint", false, new Feature[0]),
        SEQUENTIAL_BLOCK_ID(-46, "Allocate block IDs sequentially and store block IDs in the edits log and image files"),
        EDITLOG_SUPPORT_RETRYCACHE(-47, "Record ClientId and CallId in editlog to enable rebuilding retry cache in case of HA failover"),
        EDITLOG_ADD_BLOCK(-48, "Add new editlog that only records allocation of the new block instead of the entire block list"),
        ADD_DATANODE_AND_STORAGE_UUIDS(-49, "Replace StorageID with DatanodeUuid. Use distinct StorageUuid per storage directory."),
        ADD_LAYOUT_FLAGS(-50, "Add support for layout flags."),
        CACHING(-51, "Support for cache pools and path-based caching"),
        PROTOBUF_FORMAT(-52, "Use protobuf to serialize FSImage"),
        EXTENDED_ACL(-53, "Extended ACL"),
        RESERVED_REL2_4_0(-54, -51, "Reserved for release 2.4.0", true, PROTOBUF_FORMAT, EXTENDED_ACL);

        private final FeatureInfo info;

        private Feature(int lv, String description) {
            this(lv, lv + 1, description, false, new Feature[0]);
        }

        private Feature(int lv, int ancestorLV, String description, boolean reserved, Feature ... features) {
            this.info = new FeatureInfo(lv, ancestorLV, description, reserved, features);
        }

        @Override
        public FeatureInfo getInfo() {
            return this.info;
        }
    }
}

