/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.RoundRobinVolumeChoosingPolicy;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.VolumeChoosingPolicy;
import org.apache.hadoop.net.Node;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNamenodeStorageDirectives {
    public static final Logger LOG = LoggerFactory.getLogger(TestNamenodeStorageDirectives.class);
    private static final int BLOCK_SIZE = 512;
    private MiniDFSCluster cluster;

    @After
    public void tearDown() {
        this.shutdown();
    }

    private void startDFSCluster(int numNameNodes, int numDataNodes, int storagePerDataNode, StorageType[][] storageTypes) throws IOException {
        this.startDFSCluster(numNameNodes, numDataNodes, storagePerDataNode, storageTypes, RoundRobinVolumeChoosingPolicy.class, BlockPlacementPolicyDefault.class);
    }

    private void startDFSCluster(int numNameNodes, int numDataNodes, int storagePerDataNode, StorageType[][] storageTypes, Class<? extends VolumeChoosingPolicy> volumeChoosingPolicy, Class<? extends BlockPlacementPolicy> blockPlacementPolicy) throws IOException {
        this.shutdown();
        Configuration conf = new Configuration();
        conf.setLong("dfs.blocksize", 512L);
        conf.setInt("dfs.heartbeat.interval", 1);
        conf.setInt("dfs.df.interval", 1000);
        conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        conf.setTimeDuration("dfs.datanode.disk.check.min.gap", 0L, TimeUnit.MILLISECONDS);
        conf.setClass("dfs.datanode.fsdataset.volume.choosing.policy", volumeChoosingPolicy, VolumeChoosingPolicy.class);
        conf.setClass("dfs.block.replicator.classname", blockPlacementPolicy, BlockPlacementPolicy.class);
        MiniDFSNNTopology nnTopology = MiniDFSNNTopology.simpleFederatedTopology(numNameNodes);
        this.cluster = new MiniDFSCluster.Builder(conf).nnTopology(nnTopology).numDataNodes(numDataNodes).storagesPerDatanode(storagePerDataNode).storageTypes(storageTypes).build();
        this.cluster.waitActive();
    }

    private void shutdown() {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    private void createFile(Path path, int numBlocks, short replicateFactor) throws IOException, InterruptedException, TimeoutException {
        this.createFile(0, path, numBlocks, replicateFactor);
    }

    private void createFile(int fsIdx, Path path, int numBlocks, short replicateFactor) throws IOException, TimeoutException, InterruptedException {
        boolean seed = false;
        DistributedFileSystem fs = this.cluster.getFileSystem(fsIdx);
        DFSTestUtil.createFile((FileSystem)fs, path, 512 * numBlocks, replicateFactor, 0L);
        DFSTestUtil.waitReplication((FileSystem)fs, path, replicateFactor);
    }

    private boolean verifyFileReplicasOnStorageType(Path path, int numBlocks, StorageType storageType) throws IOException {
        MiniDFSCluster.NameNodeInfo info = this.cluster.getNameNodeInfos()[0];
        InetSocketAddress addr = info.nameNode.getServiceRpcAddress();
        assert (addr.getPort() != 0);
        DFSClient client = new DFSClient(addr, this.cluster.getConfiguration(0));
        DistributedFileSystem fs = this.cluster.getFileSystem();
        if (!fs.exists(path)) {
            LOG.info("verifyFileReplicasOnStorageType: file {} does not exist", (Object)path);
            return false;
        }
        long fileLength = client.getFileInfo(path.toString()).getLen();
        int foundBlocks = 0;
        LocatedBlocks locatedBlocks = client.getLocatedBlocks(path.toString(), 0L, fileLength);
        for (LocatedBlock locatedBlock : locatedBlocks.getLocatedBlocks()) {
            for (StorageType st : locatedBlock.getStorageTypes()) {
                if (st != storageType) continue;
                ++foundBlocks;
            }
        }
        LOG.info("Found {}/{} blocks on StorageType {}", new Object[]{foundBlocks, numBlocks, storageType});
        boolean isValid = foundBlocks >= numBlocks;
        return isValid;
    }

    private void testStorageTypes(StorageType[][] storageTypes, String storagePolicy, StorageType[] expectedStorageTypes, StorageType[] unexpectedStorageTypes) throws ReconfigurationException, InterruptedException, TimeoutException, IOException {
        int numDataNodes = storageTypes.length;
        int storagePerDataNode = storageTypes[0].length;
        this.startDFSCluster(1, numDataNodes, storagePerDataNode, storageTypes);
        this.cluster.getFileSystem(0).setStoragePolicy(new Path("/"), storagePolicy);
        Path testFile = new Path("/test");
        int replFactor = 2;
        int numBlocks = 10;
        this.createFile(testFile, 10, (short)2);
        for (StorageType storageType : expectedStorageTypes) {
            Assert.assertTrue((boolean)this.verifyFileReplicasOnStorageType(testFile, 10, storageType));
        }
        for (StorageType storageType : unexpectedStorageTypes) {
            Assert.assertFalse((boolean)this.verifyFileReplicasOnStorageType(testFile, 10, storageType));
        }
    }

    @Test(timeout=120000L)
    public void testTargetStorageTypes() throws ReconfigurationException, InterruptedException, TimeoutException, IOException {
        this.testStorageTypes(new StorageType[][]{{StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}}, "ONE_SSD", new StorageType[]{StorageType.SSD, StorageType.DISK}, new StorageType[]{StorageType.RAM_DISK, StorageType.ARCHIVE, StorageType.NVDIMM});
        this.testStorageTypes(new StorageType[][]{{StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}}, "ALL_SSD", new StorageType[]{StorageType.SSD}, new StorageType[]{StorageType.RAM_DISK, StorageType.DISK, StorageType.ARCHIVE, StorageType.NVDIMM});
        this.testStorageTypes(new StorageType[][]{{StorageType.SSD, StorageType.DISK, StorageType.DISK}, {StorageType.SSD, StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK, StorageType.DISK}}, "ALL_SSD", new StorageType[]{StorageType.SSD}, new StorageType[]{StorageType.RAM_DISK, StorageType.DISK, StorageType.ARCHIVE, StorageType.NVDIMM});
        this.testStorageTypes(new StorageType[][]{{StorageType.RAM_DISK, StorageType.SSD}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}}, "HOT", new StorageType[]{StorageType.DISK}, new StorageType[]{StorageType.RAM_DISK, StorageType.SSD, StorageType.ARCHIVE, StorageType.NVDIMM});
        this.testStorageTypes(new StorageType[][]{{StorageType.RAM_DISK, StorageType.SSD}, {StorageType.SSD, StorageType.DISK}, {StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}}, "WARM", new StorageType[]{StorageType.DISK, StorageType.ARCHIVE}, new StorageType[]{StorageType.RAM_DISK, StorageType.SSD, StorageType.NVDIMM});
        this.testStorageTypes(new StorageType[][]{{StorageType.RAM_DISK, StorageType.SSD}, {StorageType.SSD, StorageType.DISK}, {StorageType.ARCHIVE, StorageType.ARCHIVE}, {StorageType.ARCHIVE, StorageType.ARCHIVE}}, "COLD", new StorageType[]{StorageType.ARCHIVE}, new StorageType[]{StorageType.RAM_DISK, StorageType.SSD, StorageType.DISK, StorageType.NVDIMM});
        this.testStorageTypes(new StorageType[][]{{StorageType.RAM_DISK, StorageType.SSD}, {StorageType.SSD, StorageType.DISK}, {StorageType.SSD, StorageType.DISK}}, "LAZY_PERSIST", new StorageType[]{StorageType.DISK}, new StorageType[]{StorageType.RAM_DISK, StorageType.SSD, StorageType.ARCHIVE, StorageType.NVDIMM});
        this.testStorageTypes(new StorageType[][]{{StorageType.NVDIMM, StorageType.DISK, StorageType.SSD}, {StorageType.NVDIMM, StorageType.DISK, StorageType.SSD}}, "ALL_NVDIMM", new StorageType[]{StorageType.NVDIMM}, new StorageType[]{StorageType.RAM_DISK, StorageType.SSD, StorageType.DISK, StorageType.ARCHIVE});
    }

    private DatanodeStorageInfo getDatanodeStorageInfo(int dnIndex) throws UnregisteredNodeException {
        if (this.cluster == null) {
            return null;
        }
        DatanodeID dnId = this.cluster.getDataNodes().get(dnIndex).getDatanodeId();
        DatanodeManager dnManager = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        return dnManager.getDatanode(dnId).getStorageInfos()[0];
    }

    @Test(timeout=60000L)
    public void testStorageIDBlockPlacementSpecific() throws ReconfigurationException, InterruptedException, TimeoutException, IOException {
        StorageType[][] storageTypes = new StorageType[][]{{StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}, {StorageType.DISK, StorageType.DISK}};
        int numDataNodes = storageTypes.length;
        int storagePerDataNode = storageTypes[0].length;
        this.startDFSCluster(1, numDataNodes, storagePerDataNode, storageTypes, TestVolumeChoosingPolicy.class, TestBlockPlacementPolicy.class);
        Path testFile = new Path("/test");
        boolean replFactor = true;
        int numBlocks = 10;
        DatanodeStorageInfo dnInfoToUse = this.getDatanodeStorageInfo(0);
        TestBlockPlacementPolicy.dnStorageInfosToReturn = new DatanodeStorageInfo[]{dnInfoToUse};
        TestVolumeChoosingPolicy.expectedStorageId = dnInfoToUse.getStorageID();
        this.createFile(testFile, 10, (short)1);
    }

    private static class TestVolumeChoosingPolicy<V extends FsVolumeSpi>
    extends RoundRobinVolumeChoosingPolicy<V> {
        static String expectedStorageId;

        private TestVolumeChoosingPolicy() {
        }

        public V chooseVolume(List<V> volumes, long replicaSize, String storageId) throws IOException {
            Assert.assertEquals((Object)expectedStorageId, (Object)storageId);
            return (V)super.chooseVolume(volumes, replicaSize, storageId);
        }
    }

    private static class TestBlockPlacementPolicy
    extends BlockPlacementPolicyDefault {
        static DatanodeStorageInfo[] dnStorageInfosToReturn;

        private TestBlockPlacementPolicy() {
        }

        public DatanodeStorageInfo[] chooseTarget(String srcPath, int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosenNodes, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, BlockStoragePolicy storagePolicy, EnumSet<AddBlockFlag> flags) {
            return dnStorageInfosToReturn;
        }
    }
}

