/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclEntryType;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.DFSInotifyEventInputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfoContiguous;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.namenode.AclTestHelpers;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileInputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogFileOutputStream;
import org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogLoader;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import org.apache.hadoop.hdfs.server.namenode.FSEditLogOpCodes;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSImageTestUtil;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.JournalSet;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.namenode.StreamLimiter;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.util.XMLUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.test.PathUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class TestEditLog {
    private static boolean useAsyncEditLog;
    static final Logger LOG;
    static final int NUM_DATA_NODES = 0;
    static final int NUM_TRANSACTIONS = 100;
    static final int NUM_THREADS = 100;
    static final File TEST_DIR;
    static final byte[] HADOOP20_SOME_EDITS;
    static final byte TRAILER_BYTE;
    private static final int CHECKPOINT_ON_STARTUP_MIN_TXNS = 100;
    static final int TXNS_PER_ROLL = 10;
    static final int TXNS_PER_FAIL = 2;
    static byte[][] invalidSequenecs;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        params.add(new Object[]{Boolean.FALSE});
        params.add(new Object[]{Boolean.TRUE});
        return params;
    }

    public TestEditLog(Boolean async) {
        useAsyncEditLog = async;
    }

    public static Configuration getConf() {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.edits.asynclogging", useAsyncEditLog);
        return conf;
    }

    private static FSEditLog getFSEditLog(NNStorage storage) throws IOException {
        Configuration conf = TestEditLog.getConf();
        conf.set("dfs.namenode.edits.dir", StringUtils.join((CharSequence)",", (Iterable)storage.getEditsDirectories()));
        FSEditLog log = FSEditLog.newInstance((Configuration)conf, (NNStorage)storage, (List)FSNamesystem.getNamespaceEditsDirs((Configuration)conf));
        return log;
    }

    @Test
    public void testPreTxIdEditLogNoEdits() throws Exception {
        FSNamesystem namesys = (FSNamesystem)Mockito.mock(FSNamesystem.class);
        namesys.dir = (FSDirectory)Mockito.mock(FSDirectory.class);
        long numEdits = this.testLoad(StringUtils.hexStringToByte((String)"ffffffed"), namesys);
        Assert.assertEquals((long)0L, (long)numEdits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPreTxidEditLogWithEdits() throws Exception {
        Configuration conf = TestEditLog.getConf();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            FSNamesystem namesystem = cluster.getNamesystem();
            long numEdits = this.testLoad(HADOOP20_SOME_EDITS, namesystem);
            Assert.assertEquals((long)3L, (long)numEdits);
            HdfsFileStatus fileInfo = namesystem.getFileInfo("/myfile", false, false, false);
            Assert.assertEquals((Object)"supergroup", (Object)fileInfo.getGroup());
            Assert.assertEquals((long)3L, (long)fileInfo.getReplication());
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private long testLoad(byte[] data, FSNamesystem namesys) throws IOException {
        FSEditLogLoader loader = new FSEditLogLoader(namesys, 0L);
        return loader.loadFSEdits((EditLogInputStream)new EditLogByteInputStream(data), 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiStreamsLoadEditWithConfMaxTxns() throws IOException {
        Configuration conf = TestEditLog.getConf();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSystem = null;
        FSImage writeFsImage = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            fileSystem = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            writeFsImage = namesystem.getFSImage();
            Iterator<URI> it = cluster.getNameDirs(0).iterator();
            while (it.hasNext()) {
                File dir = new File(it.next().getPath());
                System.out.println(dir);
            }
            long originalLastInodeId = namesystem.dir.getLastInodeId();
            Transactions trans = new Transactions(namesystem, 100, 50);
            trans.run();
            writeFsImage.rollEditLog(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            Transactions trans1 = new Transactions(namesystem, 100, 50);
            trans1.run();
            writeFsImage.rollEditLog(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            namesystem.dir.resetLastInodeIdWithoutChecking(originalLastInodeId);
            Iterator it2 = writeFsImage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
            while (it2.hasNext()) {
                long expectedTxns = 202L;
                File editFile = NNStorage.getFinalizedEditsFile((Storage.StorageDirectory)((Storage.StorageDirectory)it2.next()), (long)1L, (long)expectedTxns);
                File editFile1 = NNStorage.getFinalizedEditsFile((Storage.StorageDirectory)((Storage.StorageDirectory)it2.next()), (long)203L, (long)404L);
                Assert.assertTrue((String)("Expect " + editFile + " exists"), (boolean)editFile.exists());
                Assert.assertTrue((String)("Expect " + editFile1 + " exists"), (boolean)editFile1.exists());
                EditLogFileInputStream editLogFileInputStream1 = new EditLogFileInputStream(editFile, 1L, 202L, false);
                EditLogFileInputStream editLogFileInputStream2 = new EditLogFileInputStream(editFile1, 203L, 404L, false);
                ArrayList editStreams = Lists.newArrayList();
                editStreams.add(editLogFileInputStream1);
                editStreams.add(editLogFileInputStream2);
                FSImage readFsImage = new FSImage(conf);
                try {
                    readFsImage.loadEdits((Iterable)editStreams, namesystem, 100L, null, null);
                }
                catch (Exception e) {
                    LOG.error("There appears to be an out-of-order edit in the edit log", (Throwable)e);
                    Assert.fail((String)"no exception should be thrown");
                }
                finally {
                    if (readFsImage == null) continue;
                    readFsImage.close();
                }
            }
        }
        finally {
            try {
                if (fileSystem != null) {
                    fileSystem.close();
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
                if (writeFsImage != null) {
                    writeFsImage.close();
                }
            }
            catch (Throwable t) {
                LOG.error("Couldn't shut down cleanly", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleEditLog() throws IOException {
        Configuration conf = TestEditLog.getConf();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            this.assertExistsInStorageDirs(cluster, NNStorage.NameNodeDirType.EDITS, NNStorage.getInProgressEditsFileName((long)1L));
            editLog.logSetReplication("fakefile", (short)1);
            editLog.logSync();
            editLog.rollEditLog(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            this.assertExistsInStorageDirs(cluster, NNStorage.NameNodeDirType.EDITS, NNStorage.getFinalizedEditsFileName((long)1L, (long)3L));
            this.assertExistsInStorageDirs(cluster, NNStorage.NameNodeDirType.EDITS, NNStorage.getInProgressEditsFileName((long)4L));
            editLog.logSetReplication("fakefile", (short)2);
            editLog.logSync();
            editLog.close();
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testMultiThreadedEditLog() throws IOException {
        this.testEditLog(2048);
        this.testEditLog(1);
    }

    private void assertExistsInStorageDirs(MiniDFSCluster cluster, NNStorage.NameNodeDirType dirType, String filename) {
        NNStorage storage = cluster.getNamesystem().getFSImage().getStorage();
        for (Storage.StorageDirectory sd : storage.dirIterable((Storage.StorageDirType)dirType)) {
            File f = new File(sd.getCurrentDir(), filename);
            Assert.assertTrue((String)("Expect that " + f + " exists"), (boolean)f.exists());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEditLog(int initialSize) throws IOException {
        Configuration conf = TestEditLog.getConf();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        try {
            int i;
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            Iterator<URI> it = cluster.getNameDirs(0).iterator();
            while (it.hasNext()) {
                File dir = new File(it.next().getPath());
                System.out.println(dir);
            }
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            editLog.setOutputBufferCapacity(initialSize);
            fsimage.rollEditLog(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            long originalLastInodeId = namesystem.dir.getLastInodeId();
            Thread[] threadId = new Thread[100];
            for (i = 0; i < 100; ++i) {
                Transactions trans = new Transactions(namesystem, 100, i * 100);
                threadId[i] = new Thread((Runnable)trans, "TransactionThread-" + i);
                threadId[i].start();
            }
            for (i = 0; i < 100; ++i) {
                try {
                    threadId[i].join();
                    continue;
                }
                catch (InterruptedException e) {
                    --i;
                }
            }
            Transactions trans = new Transactions(namesystem, 100, 50);
            trans.run();
            fsimage.rollEditLog(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            long expectedTxns = 20202L;
            namesystem.dir.resetLastInodeIdWithoutChecking(originalLastInodeId);
            Iterator it2 = fsimage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
            while (it2.hasNext()) {
                FSEditLogLoader loader = new FSEditLogLoader(namesystem, 0L);
                File editFile = NNStorage.getFinalizedEditsFile((Storage.StorageDirectory)((Storage.StorageDirectory)it2.next()), (long)3L, (long)(3L + expectedTxns - 1L));
                Assert.assertTrue((String)("Expect " + editFile + " exists"), (boolean)editFile.exists());
                System.out.println("Verifying file: " + editFile);
                long numEdits = loader.loadFSEdits((EditLogInputStream)new EditLogFileInputStream(editFile), 3L);
                int numLeases = namesystem.leaseManager.countLease();
                System.out.println("Number of outstanding leases " + numLeases);
                Assert.assertEquals((long)0L, (long)numLeases);
                Assert.assertTrue((String)("Verification for " + editFile + " failed. Expected " + expectedTxns + " transactions. Found " + numEdits + " transactions."), (numEdits == expectedTxns ? 1 : 0) != 0);
            }
        }
        finally {
            try {
                if (fileSys != null) {
                    fileSys.close();
                }
                if (cluster != null) {
                    cluster.shutdown();
                }
            }
            catch (Throwable t) {
                LOG.error("Couldn't shut down cleanly", t);
            }
        }
    }

    private void doLogEdit(ExecutorService exec, final FSEditLog log, final String filename) throws Exception {
        exec.submit(new Callable<Void>(){

            @Override
            public Void call() {
                log.logSetReplication(filename, (short)1);
                return null;
            }
        }).get();
    }

    private void doCallLogSync(ExecutorService exec, final FSEditLog log) throws Exception {
        exec.submit(new Callable<Void>(){

            @Override
            public Void call() {
                log.logSync();
                return null;
            }
        }).get();
    }

    private void doCallLogSyncAll(ExecutorService exec, final FSEditLog log) throws Exception {
        exec.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                log.logSyncAll();
                return null;
            }
        }).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncBatching() throws Exception {
        if (useAsyncEditLog) {
            return;
        }
        Configuration conf = TestEditLog.getConf();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        ExecutorService threadA = Executors.newSingleThreadExecutor();
        ExecutorService threadB = Executors.newSingleThreadExecutor();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            Assert.assertEquals((String)"should start with only the BEGIN_LOG_SEGMENT txn synced", (long)1L, (long)editLog.getSyncTxId());
            this.doLogEdit(threadA, editLog, "thread-a 1");
            Assert.assertEquals((String)"logging edit without syncing should do not affect txid", (long)1L, (long)editLog.getSyncTxId());
            this.doLogEdit(threadB, editLog, "thread-b 1");
            Assert.assertEquals((String)"logging edit without syncing should do not affect txid", (long)1L, (long)editLog.getSyncTxId());
            this.doCallLogSync(threadB, editLog);
            Assert.assertEquals((String)"logSync from second thread should bump txid up to 3", (long)3L, (long)editLog.getSyncTxId());
            this.doCallLogSync(threadA, editLog);
            Assert.assertEquals((String)"logSync from first thread shouldn't change txid", (long)3L, (long)editLog.getSyncTxId());
            MetricsAsserts.assertCounter((String)"TransactionsBatchedInSync", (long)1L, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)"NameNodeActivity"));
        }
        finally {
            threadA.shutdown();
            threadB.shutdown();
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBatchedSyncWithClosedLogs() throws Exception {
        Configuration conf = TestEditLog.getConf();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        ExecutorService threadA = Executors.newSingleThreadExecutor();
        ExecutorService threadB = Executors.newSingleThreadExecutor();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            this.doLogEdit(threadA, editLog, "thread-a 1");
            if (!useAsyncEditLog) {
                Assert.assertEquals((String)"logging edit without syncing should do not affect txid", (long)1L, (long)editLog.getSyncTxId());
            }
            this.doCallLogSyncAll(threadB, editLog);
            Assert.assertEquals((String)"logSyncAll should sync thread A's transaction", (long)2L, (long)editLog.getSyncTxId());
            editLog.close();
            this.doCallLogSync(threadA, editLog);
        }
        finally {
            threadA.shutdown();
            threadB.shutdown();
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testEditChecksum() throws Exception {
        Configuration conf = TestEditLog.getConf();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.waitActive();
        fileSys = cluster.getFileSystem();
        FSNamesystem namesystem = cluster.getNamesystem();
        FSImage fsimage = namesystem.getFSImage();
        FSEditLog editLog = fsimage.getEditLog();
        fileSys.mkdirs(new Path("/tmp"));
        Iterator iter = fsimage.getStorage().dirIterator((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
        LinkedList<Storage.StorageDirectory> sds = new LinkedList<Storage.StorageDirectory>();
        while (iter.hasNext()) {
            sds.add((Storage.StorageDirectory)iter.next());
        }
        editLog.close();
        cluster.shutdown();
        for (Storage.StorageDirectory sd : sds) {
            File editFile = NNStorage.getFinalizedEditsFile((Storage.StorageDirectory)sd, (long)1L, (long)3L);
            Assert.assertTrue((boolean)editFile.exists());
            long fileLen = editFile.length();
            LOG.debug("Corrupting Log File: " + editFile + " len: " + fileLen);
            RandomAccessFile rwf = new RandomAccessFile(editFile, "rw");
            rwf.seek(fileLen - 4L);
            int b = rwf.readInt();
            rwf.seek(fileLen - 4L);
            rwf.writeInt(b + 1);
            rwf.close();
        }
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).format(false).build();
            Assert.fail((String)"should not be able to start");
        }
        catch (IOException e) {
            Assert.assertNotNull((String)"Cause of exception should be ChecksumException", (Object)e.getCause());
            Assert.assertEquals((String)"Cause of exception should be ChecksumException", ChecksumException.class, e.getCause().getClass());
        }
    }

    @Test
    public void testCrashRecoveryNoTransactions() throws Exception {
        this.testCrashRecovery(0);
    }

    @Test
    public void testCrashRecoveryWithTransactions() throws Exception {
        this.testCrashRecovery(150);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCrashRecovery(int numTransactions) throws Exception {
        MiniDFSCluster cluster = null;
        Configuration conf = TestEditLog.getConf();
        conf.setInt("dfs.namenode.checkpoint.txns", 100);
        try {
            LOG.info("\n===========================================\nStarting empty cluster");
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).format(true).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            for (int i = 0; i < numTransactions; ++i) {
                fs.mkdirs(new Path("/test" + i));
            }
            File nameDir = new File(cluster.getNameDirs(0).iterator().next().getPath());
            File dfsDir = nameDir.getParentFile();
            Assert.assertEquals((Object)dfsDir.getName(), (Object)"dfs");
            LOG.info("Copying data directory aside to a hot backup");
            File backupDir = new File(dfsDir.getParentFile(), "dfs.backup-while-running");
            FileUtils.copyDirectory((File)dfsDir, (File)backupDir);
            LOG.info("Shutting down cluster #1");
            cluster.shutdown();
            cluster = null;
            FileUtil.fullyDeleteContents((File)dfsDir);
            dfsDir.delete();
            backupDir.renameTo(dfsDir);
            File currentDir = new File(nameDir, "current");
            File editsFile = new File(currentDir, NNStorage.getInProgressEditsFileName((long)1L));
            Assert.assertTrue((String)("Edits file " + editsFile + " should exist"), (boolean)editsFile.exists());
            File imageFile = FSImageTestUtil.findNewestImageFile(currentDir.getAbsolutePath());
            Assert.assertNotNull((String)("No image found in " + nameDir), (Object)imageFile);
            Assert.assertEquals((Object)NNStorage.getImageFileName((long)0L), (Object)imageFile.getName());
            LOG.info("\n===========================================\nStarting same cluster after simulated crash");
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).format(false).build();
            cluster.waitActive();
            fs = cluster.getFileSystem();
            for (int i = 0; i < numTransactions; ++i) {
                Assert.assertTrue((boolean)fs.exists(new Path("/test" + i)));
            }
            long expectedTxId = numTransactions > 100 ? (long)(numTransactions + 1) : 0L;
            imageFile = FSImageTestUtil.findNewestImageFile(currentDir.getAbsolutePath());
            Assert.assertNotNull((String)("No image found in " + nameDir), (Object)imageFile);
            Assert.assertEquals((Object)NNStorage.getImageFileName((long)expectedTxId), (Object)imageFile.getName());
            cluster.shutdown();
            cluster = null;
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).format(false).build();
            cluster.waitActive();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testCrashRecoveryEmptyLogOneDir() throws Exception {
        this.doTestCrashRecoveryEmptyLog(false, true, true);
    }

    @Test
    public void testCrashRecoveryEmptyLogBothDirs() throws Exception {
        this.doTestCrashRecoveryEmptyLog(true, true, false);
    }

    @Test
    public void testCrashRecoveryEmptyLogOneDirNoUpdateSeenTxId() throws Exception {
        this.doTestCrashRecoveryEmptyLog(false, false, true);
    }

    @Test
    public void testCrashRecoveryEmptyLogBothDirsNoUpdateSeenTxId() throws Exception {
        this.doTestCrashRecoveryEmptyLog(true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestCrashRecoveryEmptyLog(boolean inBothDirs, boolean updateTransactionIdFile, boolean shouldSucceed) throws Exception {
        Configuration conf = TestEditLog.getConf();
        MiniDFSCluster cluster = null;
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
        cluster.shutdown();
        Collection<URI> editsDirs = cluster.getNameEditsDirs(0);
        for (URI uri : editsDirs) {
            File dir = new File(uri.getPath());
            File currentDir = new File(dir, "current");
            GenericTestUtils.assertGlobEquals((File)currentDir, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)2L)});
            File log = new File(currentDir, NNStorage.getInProgressEditsFileName((long)3L));
            try (EditLogFileOutputStream stream = new EditLogFileOutputStream(conf, log, 1024);){
                stream.create(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
                if (!inBothDirs) break;
                NNStorage storage = new NNStorage(conf, Collections.emptyList(), (Collection)Lists.newArrayList((Object[])new URI[]{uri}));
                if (updateTransactionIdFile) {
                    storage.writeTransactionIdFileToStorage(3L);
                }
                storage.close();
            }
        }
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).format(false).build();
            if (!shouldSucceed) {
                Assert.fail((String)"Should not have succeeded in startin cluster");
            }
        }
        catch (IOException ioe) {
            if (shouldSucceed) {
                LOG.info("Should have succeeded in starting cluster, but failed", (Throwable)ioe);
                throw ioe;
            }
            GenericTestUtils.assertExceptionContains((String)"Gap in transactions. Expected to be able to read up until at least txid 3 but unable to find any edit logs containing txid 3", (Throwable)ioe);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedOpen() throws Exception {
        File logDir = new File(TEST_DIR, "testFailedOpen");
        logDir.mkdirs();
        ExitUtil.disableSystemExit();
        FSEditLog log = FSImageTestUtil.createStandaloneEditLog(logDir);
        try {
            FileUtil.setWritable((File)logDir, (boolean)false);
            log.openForWrite(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            Assert.fail((String)"Did no throw exception on only having a bad dir");
        }
        catch (ExitUtil.ExitException ee) {
            GenericTestUtils.assertExceptionContains((String)"too few journals successfully started", (Throwable)ee);
        }
        finally {
            FileUtil.setWritable((File)logDir, (boolean)true);
            log.close();
            ExitUtil.resetFirstExitException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAutoSync() throws Exception {
        File logDir = new File(TEST_DIR, "testAutoSync");
        logDir.mkdirs();
        String oneKB = StringUtils.byteToHexString((byte[])new byte[500]);
        try (FSEditLog log = FSImageTestUtil.createStandaloneEditLog(logDir);){
            int i;
            log.openForWrite(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            NameNodeMetrics mockMetrics = (NameNodeMetrics)Mockito.mock(NameNodeMetrics.class);
            log.setMetricsForTests(mockMetrics);
            for (i = 0; i < 400; ++i) {
                log.logDelete(oneKB, 1L, false);
            }
            ((NameNodeMetrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.times((int)0))).addSync(Mockito.anyLong());
            for (i = 0; i < 400; ++i) {
                log.logDelete(oneKB, 1L, false);
            }
            ((NameNodeMetrics)Mockito.verify((Object)mockMetrics, (VerificationMode)Mockito.times((int)1))).addSync(Mockito.anyLong());
        }
    }

    @Test
    public void testEditLogManifestMocks() throws IOException {
        NNStorage storage = this.mockStorageWithEdits("[1,100]|[101,200]|[201,]", "[1,100]|[101,200]|[201,]");
        FSEditLog log = TestEditLog.getFSEditLog(storage);
        log.initJournalsForWrite();
        Assert.assertEquals((Object)"[[1,100], [101,200]] CommittedTxId: 200", (Object)log.getEditLogManifest(1L).toString());
        Assert.assertEquals((Object)"[[101,200]] CommittedTxId: 200", (Object)log.getEditLogManifest(101L).toString());
        storage = this.mockStorageWithEdits("[1,100]|[101,200]", "[1,100]|[201,300]|[301,400]");
        log = TestEditLog.getFSEditLog(storage);
        log.initJournalsForWrite();
        Assert.assertEquals((Object)"[[1,100], [101,200], [201,300], [301,400]] CommittedTxId: 400", (Object)log.getEditLogManifest(1L).toString());
        storage = this.mockStorageWithEdits("[1,100]|[301,400]", "[301,400]|[401,500]");
        log = TestEditLog.getFSEditLog(storage);
        log.initJournalsForWrite();
        Assert.assertEquals((Object)"[[301,400], [401,500]] CommittedTxId: 500", (Object)log.getEditLogManifest(1L).toString());
        storage = this.mockStorageWithEdits("[1,100]|[101,150]", "[1,50]|[101,200]");
        log = TestEditLog.getFSEditLog(storage);
        log.initJournalsForWrite();
        Assert.assertEquals((Object)"[[1,100], [101,200]] CommittedTxId: 200", (Object)log.getEditLogManifest(1L).toString());
        Assert.assertEquals((Object)"[[101,200]] CommittedTxId: 200", (Object)log.getEditLogManifest(101L).toString());
        storage = this.mockStorageWithEdits("[1,100]|[101,]", "[1,100]|[101,200]");
        log = TestEditLog.getFSEditLog(storage);
        log.initJournalsForWrite();
        Assert.assertEquals((Object)"[[1,100], [101,200]] CommittedTxId: 200", (Object)log.getEditLogManifest(1L).toString());
        Assert.assertEquals((Object)"[[101,200]] CommittedTxId: 200", (Object)log.getEditLogManifest(101L).toString());
    }

    private NNStorage mockStorageWithEdits(String ... editsDirSpecs) throws IOException {
        ArrayList sds = Lists.newArrayList();
        ArrayList uris = Lists.newArrayList();
        NNStorage storage = (NNStorage)Mockito.mock(NNStorage.class);
        for (String dirSpec : editsDirSpecs) {
            String[] logSpecs;
            ArrayList files = Lists.newArrayList();
            for (String logSpec : logSpecs = dirSpec.split("\\|")) {
                Matcher m = Pattern.compile("\\[(\\d+),(\\d+)?\\]").matcher(logSpec);
                Assert.assertTrue((String)("bad spec: " + logSpec), (boolean)m.matches());
                if (m.group(2) == null) {
                    files.add(NNStorage.getInProgressEditsFileName((long)Long.parseLong(m.group(1))));
                    continue;
                }
                files.add(NNStorage.getFinalizedEditsFileName((long)Long.parseLong(m.group(1)), (long)Long.parseLong(m.group(2))));
            }
            Storage.StorageDirectory sd = FSImageTestUtil.mockStorageDirectory((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS, false, files.toArray(new String[0]));
            sds.add(sd);
            URI u = URI.create("file:///storage" + Math.random());
            ((NNStorage)Mockito.doReturn((Object)sd).when((Object)storage)).getStorageDirectory(u);
            uris.add(u);
        }
        ((NNStorage)Mockito.doReturn((Object)sds).when((Object)storage)).dirIterable((Storage.StorageDirType)NNStorage.NameNodeDirType.EDITS);
        ((NNStorage)Mockito.doReturn((Object)uris).when((Object)storage)).getEditsDirectories();
        return storage;
    }

    public static NNStorage setupEdits(List<URI> editUris, int numrolls, boolean closeOnFinish, AbortSpec ... abortAtRolls) throws IOException {
        int i;
        ArrayList<AbortSpec> aborts = new ArrayList<AbortSpec>(Arrays.asList(abortAtRolls));
        NNStorage storage = new NNStorage(TestEditLog.getConf(), Collections.emptyList(), editUris);
        storage.format(new NamespaceInfo());
        LocalFileSystem fs = LocalFileSystem.getLocal((Configuration)TestEditLog.getConf());
        for (URI uri : editUris) {
            String currDir = uri.getPath() + "/current";
            FileStatus fileStatus = fs.getFileLinkStatus(new Path(currDir));
            FsPermission permission = fileStatus.getPermission();
            Assert.assertEquals((long)TestEditLog.getConf().getInt("dfs.journalnode.edits.dir.perm", 700), (long)permission.toOctal());
        }
        FSEditLog editlog = TestEditLog.getFSEditLog(storage);
        editlog.initJournalsForWrite();
        editlog.openForWrite(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
        for (i = 2; i < 10; ++i) {
            editlog.logGenerationStamp(0L);
        }
        editlog.logSync();
        for (i = 0; i < numrolls; ++i) {
            editlog.rollEditLog(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            editlog.logGenerationStamp((long)i);
            editlog.logSync();
            while (aborts.size() > 0 && ((AbortSpec)aborts.get((int)0)).roll == i + 1) {
                AbortSpec spec = (AbortSpec)aborts.remove(0);
                ((JournalSet.JournalAndStream)editlog.getJournals().get(spec.logindex)).abort();
            }
            for (int j = 3; j < 10; ++j) {
                editlog.logGenerationStamp((long)i);
            }
            editlog.logSync();
        }
        if (closeOnFinish) {
            editlog.close();
        }
        FSImageTestUtil.logStorageContents(LOG, storage);
        return storage;
    }

    public static NNStorage setupEdits(List<URI> editUris, int numrolls, AbortSpec ... abortAtRolls) throws IOException {
        return TestEditLog.setupEdits(editUris, numrolls, true, abortAtRolls);
    }

    @Test
    public void testAlternatingJournalFailure() throws IOException {
        File f1 = new File(TEST_DIR + "/alternatingjournaltest0");
        File f2 = new File(TEST_DIR + "/alternatingjournaltest1");
        ImmutableList editUris = ImmutableList.of((Object)f1.toURI(), (Object)f2.toURI());
        NNStorage storage = TestEditLog.setupEdits((List<URI>)editUris, 10, new AbortSpec(1, 0), new AbortSpec(2, 1), new AbortSpec(3, 0), new AbortSpec(4, 1), new AbortSpec(5, 0), new AbortSpec(6, 1), new AbortSpec(7, 0), new AbortSpec(8, 1), new AbortSpec(9, 0), new AbortSpec(10, 1));
        long totaltxnread = 0L;
        FSEditLog editlog = TestEditLog.getFSEditLog(storage);
        editlog.initJournalsForWrite();
        long startTxId = 1L;
        Collection editStreams = editlog.selectInputStreams(startTxId, 110L);
        for (EditLogInputStream edits : editStreams) {
            FSEditLogLoader.EditLogValidation val = FSEditLogLoader.scanEditLog((EditLogInputStream)edits, (long)Long.MAX_VALUE);
            long read = val.getEndTxId() - edits.getFirstTxId() + 1L;
            LOG.info("Loading edits " + edits + " read " + read);
            Assert.assertEquals((long)startTxId, (long)edits.getFirstTxId());
            startTxId += read;
            totaltxnread += read;
        }
        editlog.close();
        storage.close();
        Assert.assertEquals((long)110L, (long)totaltxnread);
    }

    @Test
    public void testLoadingWithGaps() throws IOException {
        File f1 = new File(TEST_DIR + "/gaptest0");
        ImmutableList editUris = ImmutableList.of((Object)f1.toURI());
        NNStorage storage = TestEditLog.setupEdits((List<URI>)editUris, 3, new AbortSpec[0]);
        long startGapTxId = 11L;
        long endGapTxId = 20L;
        File[] files = new File(f1, "current").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NNStorage.getFinalizedEditsFileName((long)11L, (long)20L));
            }
        });
        Assert.assertEquals((long)1L, (long)files.length);
        Assert.assertTrue((boolean)files[0].delete());
        FSEditLog editlog = TestEditLog.getFSEditLog(storage);
        editlog.initJournalsForWrite();
        long startTxId = 1L;
        try {
            editlog.selectInputStreams(startTxId, 40L);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"Gap in transactions. Expected to be able to read up until at least txid 40 but unable to find any edit logs containing txid 11", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validateNoCrash(byte[] garbage) throws IOException {
        File TEST_LOG_NAME = new File(TEST_DIR, "test_edit_log");
        EditLogFileOutputStream elfos = null;
        EditLogFileInputStream elfis = null;
        try {
            elfos = new EditLogFileOutputStream(TestEditLog.getConf(), TEST_LOG_NAME, 0);
            elfos.create(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
            elfos.writeRaw(garbage, 0, garbage.length);
            elfos.setReadyToFlush();
            elfos.flushAndSync(true);
            elfos.close();
            elfos = null;
            elfis = new EditLogFileInputStream(TEST_LOG_NAME);
            try {
                FSEditLogOp op;
                while ((op = elfis.readOp()) != null) {
                }
            }
            catch (IOException op) {
            }
            catch (Throwable t) {
                Assert.fail((String)("Caught non-IOException throwable " + StringUtils.stringifyException((Throwable)t)));
            }
        }
        finally {
            if (elfos != null && elfos.isOpen()) {
                elfos.close();
            }
            if (elfis != null) {
                elfis.close();
            }
        }
    }

    @Test
    public void testFuzzSequences() throws IOException {
        int MAX_GARBAGE_LENGTH = 512;
        int MAX_INVALID_SEQ = 5000;
        int RANDOM_SEED = 123;
        Random r = new Random(123L);
        for (int i = 0; i < 5000; ++i) {
            byte[] garbage = new byte[r.nextInt(512)];
            r.nextBytes(garbage);
            TestEditLog.validateNoCrash(garbage);
        }
    }

    private static long readAllEdits(Collection<EditLogInputStream> streams, long startTxId) throws IOException {
        long nextTxId = startTxId;
        long numTx = 0L;
        for (EditLogInputStream s : streams) {
            FSEditLogOp op;
            while ((op = s.readOp()) != null) {
                if (op.getTransactionId() != nextTxId) {
                    throw new IOException("out of order transaction ID!  expected " + nextTxId + " but got " + op.getTransactionId() + " when reading " + s.getName());
                }
                ++numTx;
                nextTxId = op.getTransactionId() + 1L;
            }
        }
        return numTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditLogFailOverFromMissing() throws IOException {
        File f1 = new File(TEST_DIR + "/failover0");
        File f2 = new File(TEST_DIR + "/failover1");
        ImmutableList editUris = ImmutableList.of((Object)f1.toURI(), (Object)f2.toURI());
        NNStorage storage = TestEditLog.setupEdits((List<URI>)editUris, 3, new AbortSpec[0]);
        long startErrorTxId = 11L;
        long endErrorTxId = 20L;
        File[] files = new File(f1, "current").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NNStorage.getFinalizedEditsFileName((long)11L, (long)20L));
            }
        });
        Assert.assertEquals((long)1L, (long)files.length);
        Assert.assertTrue((boolean)files[0].delete());
        FSEditLog editlog = TestEditLog.getFSEditLog(storage);
        editlog.initJournalsForWrite();
        long startTxId = 1L;
        Collection streams = null;
        try {
            streams = editlog.selectInputStreams(startTxId, 40L);
            TestEditLog.readAllEdits(streams, startTxId);
        }
        catch (IOException e) {
            LOG.error("edit log failover didn't work", (Throwable)e);
            Assert.fail((String)"Edit log failover didn't work");
        }
        finally {
            IOUtils.cleanupWithLogger(null, (Closeable[])((Closeable[])streams.toArray(new EditLogInputStream[0])));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEditLogFailOverFromCorrupt() throws IOException {
        File f1 = new File(TEST_DIR + "/failover0");
        File f2 = new File(TEST_DIR + "/failover1");
        ImmutableList editUris = ImmutableList.of((Object)f1.toURI(), (Object)f2.toURI());
        NNStorage storage = TestEditLog.setupEdits((List<URI>)editUris, 3, new AbortSpec[0]);
        long startErrorTxId = 11L;
        long endErrorTxId = 20L;
        File[] files = new File(f1, "current").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(NNStorage.getFinalizedEditsFileName((long)11L, (long)20L));
            }
        });
        Assert.assertEquals((long)1L, (long)files.length);
        long fileLen = files[0].length();
        LOG.debug("Corrupting Log File: " + files[0] + " len: " + fileLen);
        RandomAccessFile rwf = new RandomAccessFile(files[0], "rw");
        rwf.seek(fileLen - 4L);
        int b = rwf.readInt();
        rwf.seek(fileLen - 4L);
        rwf.writeInt(b + 1);
        rwf.close();
        FSEditLog editlog = TestEditLog.getFSEditLog(storage);
        editlog.initJournalsForWrite();
        long startTxId = 1L;
        Collection streams = null;
        try {
            streams = editlog.selectInputStreams(startTxId, 40L);
            TestEditLog.readAllEdits(streams, startTxId);
        }
        catch (IOException e) {
            LOG.error("edit log failover didn't work", (Throwable)e);
            Assert.fail((String)"Edit log failover didn't work");
        }
        finally {
            IOUtils.cleanupWithLogger(null, (Closeable[])((Closeable[])streams.toArray(new EditLogInputStream[0])));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManyEditLogSegments() throws IOException {
        int NUM_EDIT_LOG_ROLLS = 1000;
        Configuration conf = TestEditLog.getConf();
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            FSNamesystem namesystem = cluster.getNamesystem();
            FSImage fsimage = namesystem.getFSImage();
            FSEditLog editLog = fsimage.getEditLog();
            for (int i = 0; i < 1000; ++i) {
                editLog.logSetReplication("fakefile" + i, (short)(i % 3));
                this.assertExistsInStorageDirs(cluster, NNStorage.NameNodeDirType.EDITS, NNStorage.getInProgressEditsFileName((long)(i * 3 + 1)));
                editLog.logSync();
                editLog.rollEditLog(NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION);
                this.assertExistsInStorageDirs(cluster, NNStorage.NameNodeDirType.EDITS, NNStorage.getFinalizedEditsFileName((long)(i * 3 + 1), (long)(i * 3 + 3)));
            }
            editLog.close();
        }
        finally {
            if (fileSys != null) {
                fileSys.close();
            }
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        long startTime = Time.now();
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(0).build();
            cluster.waitActive();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
        long endTime = Time.now();
        double delta = (double)(endTime - startTime) / 1000.0;
        LOG.info(String.format("loaded %d edit log segments in %.2f seconds", 1000, delta));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResetThreadLocalCachedOps() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setInt("dfs.namenode.handler.count", 1);
        MiniDFSCluster cluster = null;
        DistributedFileSystem fileSys = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            fileSys = cluster.getFileSystem();
            Path dir1 = new Path("/dir1");
            fileSys.mkdirs(dir1);
            ArrayList aclSpec = Lists.newArrayList((Object[])new AclEntry[]{AclTestHelpers.aclEntry(AclEntryScope.DEFAULT, AclEntryType.USER, "foo", FsAction.READ_EXECUTE)});
            fileSys.modifyAclEntries(dir1, (List)aclSpec);
            Path dir2 = new Path("/dir1/dir2");
            fileSys.mkdirs(dir2);
            Path file1 = new Path("/dir1/file1");
            fileSys.create(file1).close();
            Path dir3 = new Path("/dir3");
            fileSys.mkdirs(dir3);
            Path file2 = new Path("/file2");
            fileSys.create(file2).close();
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fileSys});
            cluster.restartNameNode(new String[0]);
            fileSys = cluster.getFileSystem();
            Assert.assertFalse((boolean)fileSys.getAclStatus(dir1).getEntries().isEmpty());
            Assert.assertFalse((boolean)fileSys.getAclStatus(dir2).getEntries().isEmpty());
            Assert.assertFalse((boolean)fileSys.getAclStatus(file1).getEntries().isEmpty());
            Assert.assertTrue((boolean)fileSys.getAclStatus(dir3).getEntries().isEmpty());
            Assert.assertTrue((boolean)fileSys.getAclStatus(file2).getEntries().isEmpty());
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fileSys});
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{fileSys});
        if (cluster != null) {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadActivelyUpdatedLog() throws Exception {
        TestAppender appender = new TestAppender();
        LogManager.getRootLogger().addAppender((Appender)appender);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean("dfs.namenode.acls.enabled", true);
        conf.setInt("dfs.namenode.handler.count", 1);
        MiniDFSCluster cluster = null;
        try {
            FSEditLogOp op;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
            cluster.waitActive();
            FSImage fsimage = cluster.getNamesystem().getFSImage();
            Storage.StorageDirectory sd = fsimage.getStorage().getStorageDir(0);
            DistributedFileSystem fileSys = cluster.getFileSystem();
            DFSInotifyEventInputStream events = fileSys.getInotifyEventStream();
            fileSys.mkdirs(new Path("/test"));
            fileSys.mkdirs(new Path("/test/dir1"));
            fileSys.delete(new Path("/test/dir1"), true);
            fsimage.getEditLog().logSync();
            fileSys.mkdirs(new Path("/test/dir2"));
            File inProgressEdit = NNStorage.getInProgressEditsFile((Storage.StorageDirectory)sd, (long)1L);
            Assert.assertTrue((boolean)inProgressEdit.exists());
            EditLogFileInputStream elis = new EditLogFileInputStream(inProgressEdit);
            long pos = 0L;
            while ((op = elis.readOp()) != null && op.opCode != FSEditLogOpCodes.OP_INVALID) {
                pos = elis.getPosition();
            }
            elis.close();
            Assert.assertTrue((pos > 0L ? 1 : 0) != 0);
            RandomAccessFile rwf = new RandomAccessFile(inProgressEdit, "rw");
            rwf.seek(pos);
            Assert.assertEquals((long)rwf.readByte(), (long)-1L);
            rwf.seek(pos + 1L);
            rwf.writeByte(2);
            rwf.close();
            events.poll();
            String pattern = "Caught exception after reading (.*) ops";
            Pattern r = Pattern.compile(pattern);
            List<LoggingEvent> log = appender.getLog();
            for (LoggingEvent event : log) {
                Matcher m = r.matcher(event.getRenderedMessage());
                if (!m.find()) continue;
                Assert.fail((String)"Should not try to read past latest syned edit log op");
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            LogManager.getRootLogger().removeAppender((Appender)appender);
        }
    }

    @Test
    public void testEditLogWithoutErasureCodingSupported() throws IOException {
        Configuration conf = TestEditLog.getConf();
        MiniDFSCluster cluster = null;
        int logVersion = -61;
        Assert.assertFalse((boolean)NameNodeLayoutVersion.supports((LayoutVersion.LayoutFeature)NameNodeLayoutVersion.Feature.ERASURE_CODING, (int)logVersion));
        cluster = new MiniDFSCluster.Builder(conf).numDataNodes(1).build();
        cluster.waitActive();
        FSNamesystem namesystem = cluster.getNamesystem();
        FSImage fsimage = namesystem.getFSImage();
        DistributedFileSystem fileSys = cluster.getFileSystem();
        FSEditLog editLog = fsimage.getEditLog();
        editLog.editLogStream.setCurrentLogVersion(logVersion);
        long txid = editLog.rollEditLog(logVersion);
        String testDir = "/test";
        String testFile = "testfile_001";
        String testFilePath = testDir + "/" + testFile;
        fileSys.mkdirs(new Path(testDir), new FsPermission("755"));
        Path p = new Path(testFilePath);
        DFSTestUtil.createFile((FileSystem)fileSys, p, 0L, (short)1, 1L);
        long blkId = 1L;
        long blkNumBytes = 1024L;
        long timestamp = 1426222918L;
        BlockInfoContiguous blockInfo = new BlockInfoContiguous(new Block(blkId, blkNumBytes, timestamp), 1);
        INodeFile file = (INodeFile)namesystem.getFSDirectory().getINode(testFilePath);
        file.addBlock((BlockInfo)blockInfo);
        file.toUnderConstruction("testClient", "testMachine");
        editLog.logAddBlock(testFilePath, file);
        editLog.rollEditLog(logVersion);
        Collection editStreams = editLog.selectInputStreams(txid, txid + 1L);
        EditLogInputStream inputStream = null;
        for (EditLogInputStream s : editStreams) {
            if (s.getFirstTxId() != txid) continue;
            inputStream = s;
            break;
        }
        Assert.assertNotNull(inputStream);
        int readLogVersion = inputStream.getVersion(false);
        Assert.assertEquals((long)logVersion, (long)readLogVersion);
        FSEditLogLoader loader = new FSEditLogLoader(namesystem, 0L);
        long records = loader.loadFSEdits(inputStream, txid);
        Assert.assertTrue((records > 0L ? 1 : 0) != 0);
        editLog.close();
        cluster.shutdown();
    }

    static {
        GenericTestUtils.setLogLevel((Logger)FSEditLog.LOG, (Level)Level.TRACE);
        LOG = LoggerFactory.getLogger(TestEditLog.class);
        TEST_DIR = PathUtils.getTestDir(TestEditLog.class);
        HADOOP20_SOME_EDITS = StringUtils.hexStringToByte((String)"ffff ffed 0a00 0000 0000 03fa e100 00000005 0007 2f6d 7966 696c 6500 0133 000d3132 3932 3331 3634 3034 3138 3400 0d313239 3233 3136 3430 3431 3834 0009 31333432 3137 3732 3800 0000 0004 746f 64640a73 7570 6572 6772 6f75 7001 a400 15444653 436c 6965 6e74 5f2d 3136 3136 35353738 3931 000b 3137 322e 3239 2e35 2e333209 0000 0005 0007 2f6d 7966 696c 65000133 000d 3132 3932 3331 3634 3034 31383400 0d31 3239 3233 3136 3430 3431 38340009 3133 3432 3137 3732 3800 0000 0004746f 6464 0a73 7570 6572 6772 6f75 7001a4ff 0000 0000 0000 0000 0000 0000 0000".replace(" ", ""));
        EditLogFileOutputStream.setShouldSkipFsyncForTesting((boolean)true);
        TRAILER_BYTE = FSEditLogOpCodes.OP_INVALID.getOpCode();
        invalidSequenecs = null;
    }

    private static class EditLogByteInputStream
    extends EditLogInputStream {
        private final InputStream input;
        private final long len;
        private int version;
        private FSEditLogOp.Reader reader = null;
        private FSEditLogLoader.PositionTrackingInputStream tracker = null;

        public EditLogByteInputStream(byte[] data) throws IOException {
            this.len = data.length;
            this.input = new ByteArrayInputStream(data);
            BufferedInputStream bin = new BufferedInputStream(this.input);
            DataInputStream in = new DataInputStream(bin);
            this.version = EditLogFileInputStream.readLogVersion((DataInputStream)in, (boolean)true);
            this.tracker = new FSEditLogLoader.PositionTrackingInputStream((InputStream)in);
            in = new DataInputStream((InputStream)this.tracker);
            this.reader = FSEditLogOp.Reader.create((DataInputStream)in, (StreamLimiter)this.tracker, (int)this.version);
        }

        public long getFirstTxId() {
            return -12345L;
        }

        public long getLastTxId() {
            return -12345L;
        }

        public long length() throws IOException {
            return this.len;
        }

        public long getPosition() {
            return this.tracker.getPos();
        }

        protected FSEditLogOp nextOp() throws IOException {
            return this.reader.readOp(false);
        }

        public int getVersion(boolean verifyVersion) throws IOException {
            return this.version;
        }

        public void close() throws IOException {
            this.input.close();
        }

        public String getName() {
            return "AnonEditLogByteInputStream";
        }

        public boolean isInProgress() {
            return true;
        }

        public void setMaxOpSize(int maxOpSize) {
            this.reader.setMaxOpSize(maxOpSize);
        }

        public boolean isLocalLog() {
            return true;
        }
    }

    static class Transactions
    implements Runnable {
        final FSNamesystem namesystem;
        final int numTransactions;
        final short replication = (short)3;
        final long blockSize = 64L;
        final int startIndex;

        Transactions(FSNamesystem ns, int numTx, int startIdx) {
            this.namesystem = ns;
            this.numTransactions = numTx;
            this.startIndex = startIdx;
        }

        @Override
        public void run() {
            PermissionStatus p = this.namesystem.createFsOwnerPermissions(new FsPermission(511));
            FSEditLog editLog = this.namesystem.getEditLog();
            for (int i = 0; i < this.numTransactions; ++i) {
                INodeFile inode = new INodeFile(this.namesystem.dir.allocateNewInodeId(), null, p, 0L, 0L, BlockInfo.EMPTY_ARRAY, 3, 64L);
                inode.toUnderConstruction("", "");
                editLog.logOpenFile("/filename" + (this.startIndex + i), inode, false, false);
                editLog.logCloseFile("/filename" + (this.startIndex + i), inode);
                editLog.logSync();
            }
        }
    }

    static class AbortSpec {
        final int roll;
        final int logindex;

        AbortSpec(int roll, int logindex) {
            this.roll = roll;
            this.logindex = logindex;
        }
    }

    class TestAppender
    extends AppenderSkeleton {
        private final List<LoggingEvent> log = new ArrayList<LoggingEvent>();

        TestAppender() {
        }

        public boolean requiresLayout() {
            return false;
        }

        protected void append(LoggingEvent loggingEvent) {
            this.log.add(loggingEvent);
        }

        public void close() {
        }

        public List<LoggingEvent> getLog() {
            return new ArrayList<LoggingEvent>(this.log);
        }
    }

    public static class GarbageMkdirOp
    extends FSEditLogOp {
        public GarbageMkdirOp() {
            super(FSEditLogOpCodes.OP_MKDIR);
        }

        void resetSubFields() {
        }

        void readFields(DataInputStream in, int logVersion) throws IOException {
            throw new IOException("cannot decode GarbageMkdirOp");
        }

        public void writeFields(DataOutputStream out) throws IOException {
            Random random = new Random();
            byte[] content = new byte[random.nextInt(16) + 1];
            random.nextBytes(content);
            out.write(content);
        }

        protected void toXml(ContentHandler contentHandler) throws SAXException {
            throw new UnsupportedOperationException("Not supported for GarbageMkdirOp");
        }

        void fromXml(XMLUtils.Stanza st) throws XMLUtils.InvalidXmlException {
            throw new UnsupportedOperationException("Not supported for GarbageMkdirOp");
        }
    }
}

