/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.jcip.annotations.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.client.HdfsClientConfigKeys;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.BlockSender;
import org.apache.hadoop.hdfs.server.datanode.CachingStrategy;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.SimulatedFSDataset;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.TemporarySocketDirectory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class TestDataNodeMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataNodeMetrics.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        SimulatedFSDataset.setFactory((Configuration)conf);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            long LONG_FILE_LEN = 0x80000000L;
            DFSTestUtil.createFile((FileSystem)fs, new Path("/tmp.txt"), 0x80000000L, (short)1, 1L);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            MetricsAsserts.assertCounter((String)"BytesWritten", (long)0x80000000L, (MetricsRecordBuilder)rb);
            Assert.assertTrue((String)"Expected non-zero number of incremental block reports", (MetricsAsserts.getLongCounter((String)"IncrementalBlockReportsNumOps", (MetricsRecordBuilder)rb) > 0L ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSendDataPacketMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean interval = true;
        conf.set("dfs.metrics.percentiles.intervals", "1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            Path tmpfile = new Path("/tmp.txt");
            DFSTestUtil.createFile((FileSystem)fs, tmpfile, 1L, (short)1, 1L);
            DFSTestUtil.readFile((FileSystem)fs, tmpfile);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            MetricsAsserts.assertCounter((String)"SendDataPacketTransferNanosNumOps", (long)2L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounter((String)"SendDataPacketBlockedOnNetworkNanosNumOps", (long)2L, (MetricsRecordBuilder)rb);
            Thread.sleep(2000L);
            String sec = "1s";
            MetricsAsserts.assertQuantileGauges((String)("SendDataPacketBlockedOnNetworkNanos" + sec), (MetricsRecordBuilder)rb);
            MetricsAsserts.assertQuantileGauges((String)("SendDataPacketTransferNanos" + sec), (MetricsRecordBuilder)rb);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceivePacketMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean interval = true;
        conf.set("dfs.metrics.percentiles.intervals", "1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/testFlushNanosMetric.txt");
            FSDataOutputStream fout = fs.create(testFile);
            fout.write(new byte[1]);
            fout.hsync();
            fout.close();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            MetricsAsserts.assertCounter((String)"FlushNanosNumOps", (long)2L, (MetricsRecordBuilder)dnMetrics);
            MetricsAsserts.assertCounter((String)"FsyncNanosNumOps", (long)2L, (MetricsRecordBuilder)dnMetrics);
            Thread.sleep(2000L);
            String sec = "1s";
            MetricsAsserts.assertQuantileGauges((String)("FlushNanos" + sec), (MetricsRecordBuilder)dnMetrics);
            MetricsAsserts.assertQuantileGauges((String)("FsyncNanos" + sec), (MetricsRecordBuilder)dnMetrics);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReceivePacketSlowMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        boolean interval = true;
        conf.setInt("dfs.metrics.percentiles.intervals", 1);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DataNodeFaultInjector oldInjector = DataNodeFaultInjector.get();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DataNodeFaultInjector injector = (DataNodeFaultInjector)Mockito.mock(DataNodeFaultInjector.class);
            Answer answer = new Answer(){

                public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                    Thread.sleep(1000L);
                    return null;
                }
            };
            ((DataNodeFaultInjector)Mockito.doAnswer((Answer)answer).when((Object)injector)).stopSendingPacketDownstream(Mockito.anyString());
            ((DataNodeFaultInjector)Mockito.doAnswer((Answer)answer).when((Object)injector)).delayWriteToOsCache();
            ((DataNodeFaultInjector)Mockito.doAnswer((Answer)answer).when((Object)injector)).delayWriteToDisk();
            DataNodeFaultInjector.set((DataNodeFaultInjector)injector);
            Path testFile = new Path("/testFlushNanosMetric.txt");
            FSDataOutputStream fout = fs.create(testFile);
            DFSOutputStream dout = (DFSOutputStream)fout.getWrappedStream();
            fout.write(new byte[1]);
            fout.hsync();
            DatanodeInfo[] pipeline = dout.getPipeline();
            fout.close();
            dout.close();
            DatanodeInfo headDatanodeInfo = pipeline[0];
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DataNode headNode = datanodes.stream().filter(d -> d.getDatanodeId().equals((Object)headDatanodeInfo)).findFirst().orElseGet(null);
            Assert.assertNotNull((String)"Could not find the head of the datanode write pipeline", (Object)headNode);
            MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics((String)headNode.getMetrics().name());
            Assert.assertTrue((String)"More than 1 packet received", (MetricsAsserts.getLongCounter((String)"PacketsReceived", (MetricsRecordBuilder)dnMetrics) > 1L ? 1 : 0) != 0);
            Assert.assertTrue((String)"More than 1 slow packet to mirror", (MetricsAsserts.getLongCounter((String)"PacketsSlowWriteToMirror", (MetricsRecordBuilder)dnMetrics) > 1L ? 1 : 0) != 0);
            MetricsAsserts.assertCounter((String)"PacketsSlowWriteToDisk", (long)1L, (MetricsRecordBuilder)dnMetrics);
            MetricsAsserts.assertCounter((String)"PacketsSlowWriteToOsCache", (long)0L, (MetricsRecordBuilder)dnMetrics);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldInjector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsDatasetMetrics() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            cluster.waitActive();
            String bpid = cluster.getNameNode().getNamesystem().getBlockPoolId();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            MetricsAsserts.assertCounter((String)"CreateRbwOpNumOps", (long)0L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounter((String)"CreateTemporaryOpNumOps", (long)0L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounter((String)"FinalizeBlockOpNumOps", (long)0L, (MetricsRecordBuilder)rb);
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/testBlockMetrics.txt");
            FSDataOutputStream fout = fs.create(testFile);
            fout.write(new byte[1]);
            fout.hsync();
            fout.close();
            ExtendedBlock block = new ExtendedBlock(bpid, 1L, 1L, 2001L);
            datanode.data.createTemporary(StorageType.DEFAULT, null, block, false);
            rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            MetricsAsserts.assertCounter((String)"CreateRbwOpNumOps", (long)1L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounter((String)"CreateTemporaryOpNumOps", (long)1L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounter((String)"FinalizeBlockOpNumOps", (long)1L, (MetricsRecordBuilder)rb);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoundTripAckMetric() throws Exception {
        int datanodeCount = 2;
        boolean interval = true;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.metrics.percentiles.intervals", "1");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/testRoundTripAckMetric.txt");
            FSDataOutputStream fsout = fs.create(testFile, (short)2);
            DFSOutputStream dout = (DFSOutputStream)fsout.getWrappedStream();
            dout.setChunksPerPacket(5);
            dout.setArtificialSlowdown(3000L);
            fsout.write(new byte[10000]);
            DatanodeInfo[] pipeline = null;
            for (int count = 0; pipeline == null && count < 5; ++count) {
                pipeline = dout.getPipeline();
                System.out.println("Waiting for pipeline to be created.");
                Thread.sleep(1000L);
            }
            void headInfo = pipeline[0];
            DataNode headNode = null;
            for (DataNode datanode : cluster.getDataNodes()) {
                if (!datanode.getDatanodeId().equals((Object)headInfo)) continue;
                headNode = datanode;
                break;
            }
            Assert.assertNotNull((String)"Could not find the head of the datanode write pipeline", headNode);
            Thread.sleep(2000L);
            MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics((String)headNode.getMetrics().name());
            Assert.assertTrue((String)"Expected non-zero number of acks", (MetricsAsserts.getLongCounter((String)"PacketAckRoundTripTimeNanosNumOps", (MetricsRecordBuilder)dnMetrics) > 0L ? 1 : 0) != 0);
            MetricsAsserts.assertQuantileGauges((String)"PacketAckRoundTripTimeNanos1s", (MetricsRecordBuilder)dnMetrics);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testTimeoutMetric() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        Path path = new Path("/test");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        ArrayList streams = Lists.newArrayList();
        DataNodeFaultInjector oldInjector = DataNodeFaultInjector.get();
        try {
            FSDataOutputStream out = cluster.getFileSystem().create(path, (short)2);
            DataNodeFaultInjector injector = (DataNodeFaultInjector)Mockito.mock(DataNodeFaultInjector.class);
            ((DataNodeFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("mock IOException")}).when((Object)injector)).writeBlockAfterFlush();
            DataNodeFaultInjector.set((DataNodeFaultInjector)injector);
            streams.add(out);
            out.writeBytes("old gs data\n");
            out.hflush();
            MetricsRecordBuilder dnMetrics = MetricsAsserts.getMetrics((String)cluster.getDataNodes().get(0).getMetrics().name());
            MetricsAsserts.assertCounter((String)"DatanodeNetworkErrors", (long)1L, (MetricsRecordBuilder)dnMetrics);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=DataNode,name=DataNodeInfo");
            Object dnc = mbs.getAttribute(mxbeanName, "DatanodeNetworkCounts");
            String allDnc = dnc.toString();
            Assert.assertTrue((String)"expected to see loopback address", (allDnc.indexOf("127.0.0.1") >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((String)"expected to see networkErrors", (allDnc.indexOf("networkErrors") >= 0 ? 1 : 0) != 0);
        }
        finally {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])streams.toArray(new Closeable[0]));
            if (cluster != null) {
                cluster.shutdown();
            }
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldInjector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=120000L)
    public void testDataNodeTimeSpend() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.metrics.percentiles.intervals", "60");
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            long LONG_FILE_LEN = 0xA00000L;
            long startWriteValue = MetricsAsserts.getLongCounter((String)"TotalWriteTime", (MetricsRecordBuilder)rb);
            long startReadValue = MetricsAsserts.getLongCounter((String)"TotalReadTime", (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounter((String)"ReadTransferRateNumOps", (long)0L, (MetricsRecordBuilder)rb);
            final AtomicInteger x = new AtomicInteger(0);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){
                final /* synthetic */ FileSystem val$fs;
                final /* synthetic */ DataNode val$datanode;
                final /* synthetic */ long val$startWriteValue;
                final /* synthetic */ long val$startReadValue;
                {
                    this.val$fs = fileSystem;
                    this.val$datanode = dataNode;
                    this.val$startWriteValue = l;
                    this.val$startReadValue = l2;
                }

                @Override
                public Boolean get() {
                    x.getAndIncrement();
                    try {
                        DFSTestUtil.createFile(this.val$fs, new Path("/time.txt." + x.get()), 0xA00000L, (short)1, Time.monotonicNow());
                        DFSTestUtil.readFile(this.val$fs, new Path("/time.txt." + x.get()));
                        this.val$fs.delete(new Path("/time.txt." + x.get()), true);
                    }
                    catch (IOException ioe) {
                        LOG.error("Caught IOException while ingesting DN metrics", (Throwable)ioe);
                        return false;
                    }
                    MetricsRecordBuilder rbNew = MetricsAsserts.getMetrics((String)this.val$datanode.getMetrics().name());
                    long endWriteValue = MetricsAsserts.getLongCounter((String)"TotalWriteTime", (MetricsRecordBuilder)rbNew);
                    long endReadValue = MetricsAsserts.getLongCounter((String)"TotalReadTime", (MetricsRecordBuilder)rbNew);
                    MetricsAsserts.assertCounter((String)"ReadTransferRateNumOps", (long)1L, (MetricsRecordBuilder)rbNew);
                    MetricsAsserts.assertInverseQuantileGauges((String)"ReadTransferRate60s", (MetricsRecordBuilder)rbNew, (String)"Rate");
                    return endWriteValue > this.val$startWriteValue && endReadValue > this.val$startReadValue;
                }
            }, (long)30L, (long)60000L);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatanodeBlocksReplicatedMetric() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            long blocksReplicated = MetricsAsserts.getLongCounter((String)"BlocksReplicated", (MetricsRecordBuilder)rb);
            Assert.assertEquals((String)"No blocks replicated yet", (long)0L, (long)blocksReplicated);
            Path path = new Path("/counter.txt");
            DFSTestUtil.createFile((FileSystem)fs, path, 1024L, (short)2, Time.monotonicNow());
            cluster.startDataNodes((Configuration)conf, 1, true, HdfsServerConstants.StartupOption.REGULAR, null);
            ExtendedBlock firstBlock = DFSTestUtil.getFirstBlock((FileSystem)fs, path);
            DFSTestUtil.waitForReplication(cluster, firstBlock, 1, 2, 0);
            MetricsRecordBuilder rbNew = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            blocksReplicated = MetricsAsserts.getLongCounter((String)"BlocksReplicated", (MetricsRecordBuilder)rbNew);
            Assert.assertEquals((String)"blocks replicated counter incremented", (long)1L, (long)blocksReplicated);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDatanodeActiveXceiversCount() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        try {
            DistributedFileSystem fs = cluster.getFileSystem();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)1L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            long dataNodeActiveXceiversCount = MetricsAsserts.getIntGauge((String)"DataNodeActiveXceiversCount", (MetricsRecordBuilder)rb);
            Assert.assertEquals((long)dataNodeActiveXceiversCount, (long)0L);
            Path path = new Path("/counter.txt");
            DFSTestUtil.createFile((FileSystem)fs, path, 204800000L, (short)3, Time.monotonicNow());
            MetricsRecordBuilder rbNew = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            dataNodeActiveXceiversCount = MetricsAsserts.getIntGauge((String)"DataNodeActiveXceiversCount", (MetricsRecordBuilder)rbNew);
            Assert.assertTrue((dataNodeActiveXceiversCount >= 0L ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataNodeMXBeanActiveThreadCount() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path p = new Path("/testfile");
        try {
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)1L, (long)datanodes.size());
            DataNode datanode = (DataNode)datanodes.get(0);
            FSDataOutputStream os = fs.create(p);
            for (int i = 0; i < 1024; ++i) {
                os.write("testdatastr".getBytes());
            }
            os.hsync();
            FSDataInputStream is = fs.open(p);
            is.read(new byte[16], 0, 4);
            int threadCount = datanode.threadGroup.activeCount();
            Assert.assertTrue((threadCount > 0 ? 1 : 0) != 0);
            Thread[] threads = new Thread[threadCount];
            datanode.threadGroup.enumerate(threads);
            int xceiverCount = 0;
            int responderCount = 0;
            int recoveryWorkerCount = 0;
            for (Thread t : threads) {
                if (t.getName().contains("DataXceiver for client")) {
                    ++xceiverCount;
                    continue;
                }
                if (!t.getName().contains("PacketResponder")) continue;
                ++responderCount;
            }
            Assert.assertEquals((long)2L, (long)xceiverCount);
            Assert.assertEquals((long)1L, (long)responderCount);
            Assert.assertEquals((long)0L, (long)recoveryWorkerCount);
            Assert.assertEquals((long)xceiverCount, (long)datanode.getXceiverCount());
            Assert.assertEquals((long)(xceiverCount + responderCount + recoveryWorkerCount), (long)datanode.getActiveTransferThreadCount());
            is.close();
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDNShouldNotDeleteBlockONTooManyOpenFiles() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.heartbeat.interval", 1L);
        conf.setLong("dfs.client.retry.window.base", 1L);
        DataNodeFaultInjector oldInjector = DataNodeFaultInjector.get();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        DataNodeFaultInjector injector = (DataNodeFaultInjector)Mockito.mock(DataNodeFaultInjector.class);
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path p = new Path("/testShouldThrowTMP");
            DFSTestUtil.writeFile((FileSystem)fs, p, "testdata");
            this.verifyBlockLocations(fs, p, 1);
            ((DataNodeFaultInjector)Mockito.doThrow((Throwable[])new Throwable[]{new FileNotFoundException("Too many open files")}).when((Object)injector)).throwTooManyOpenFiles();
            DataNodeFaultInjector.set((DataNodeFaultInjector)injector);
            ExtendedBlock b = fs.getClient().getLocatedBlocks(p.toString(), 0L).get(0).getBlock();
            try {
                new BlockSender(b, 0L, -1L, false, true, true, cluster.getDataNodes().get(0), null, CachingStrategy.newDefaultStrategy());
                Assert.fail((String)"Must throw FileNotFoundException");
            }
            catch (FileNotFoundException fe) {
                Assert.assertTrue((String)"Should throw too many open files", (boolean)fe.getMessage().contains("Too many open files"));
            }
            cluster.triggerHeartbeats();
            Assert.assertTrue((boolean)cluster.getDataNodes().get(0).getFSDataset().isValidBlock(b));
            this.verifyBlockLocations(fs, p, 1);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldInjector);
        }
    }

    private void verifyBlockLocations(DistributedFileSystem fs, Path p, final int expected) throws IOException, TimeoutException, InterruptedException {
        final LocatedBlock lb = fs.getClient().getLocatedBlocks(p.toString(), 0L).get(0);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return lb.getLocations().length == expected;
            }
        }, (long)1000L, (long)6000L);
    }

    @Test
    public void testNNRpcMetricsWithNonHA() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setTimeDuration("dfs.heartbeat.interval", 1L, TimeUnit.HOURS);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        cluster.waitActive();
        DataNode dn = cluster.getDataNodes().get(0);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
        MetricsAsserts.assertCounter((String)"HeartbeatsNumOps", (long)1L, (MetricsRecordBuilder)rb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testSlowMetrics() throws Exception {
        DataNodeFaultInjector dnFaultInjector = new DataNodeFaultInjector(){

            public void delay() {
                try {
                    Thread.sleep(310L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        DataNodeFaultInjector oldDnInjector = DataNodeFaultInjector.get();
        DataNodeFaultInjector.set((DataNodeFaultInjector)dnFaultInjector);
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            DistributedFileSystem fs = cluster.getFileSystem();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)datanodes.size(), (long)3L);
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            long longFileLen = 10L;
            long startFlushOrSyncValue = MetricsAsserts.getLongCounter((String)"SlowFlushOrSyncCount", (MetricsRecordBuilder)rb);
            long startAckToUpstreamValue = MetricsAsserts.getLongCounter((String)"SlowAckToUpstreamCount", (MetricsRecordBuilder)rb);
            final AtomicInteger x = new AtomicInteger(0);
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){
                final /* synthetic */ FileSystem val$fs;
                final /* synthetic */ DataNode val$datanode;
                final /* synthetic */ long val$startFlushOrSyncValue;
                final /* synthetic */ long val$startAckToUpstreamValue;
                {
                    this.val$fs = fileSystem;
                    this.val$datanode = dataNode;
                    this.val$startFlushOrSyncValue = l;
                    this.val$startAckToUpstreamValue = l2;
                }

                @Override
                public Boolean get() {
                    x.getAndIncrement();
                    try {
                        DFSTestUtil.createFile(this.val$fs, new Path("/time.txt." + x.get()), 10L, (short)3, Time.monotonicNow());
                    }
                    catch (IOException ioe) {
                        LOG.error("Caught IOException while ingesting DN metrics", (Throwable)ioe);
                        return false;
                    }
                    MetricsRecordBuilder rbNew = MetricsAsserts.getMetrics((String)this.val$datanode.getMetrics().name());
                    long endFlushOrSyncValue = MetricsAsserts.getLongCounter((String)"SlowFlushOrSyncCount", (MetricsRecordBuilder)rbNew);
                    long endAckToUpstreamValue = MetricsAsserts.getLongCounter((String)"SlowAckToUpstreamCount", (MetricsRecordBuilder)rbNew);
                    return endFlushOrSyncValue > this.val$startFlushOrSyncValue && endAckToUpstreamValue > this.val$startAckToUpstreamValue;
                }
            }, (long)30L, (long)30000L);
        }
        finally {
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldDnInjector);
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testNNRpcMetricsWithHA() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setTimeDuration("dfs.heartbeat.interval", 1L, TimeUnit.HOURS);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHATopology()).build();
        cluster.waitActive();
        DataNode dn = cluster.getDataNodes().get(0);
        cluster.transitionToActive(0);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
        MetricsAsserts.assertCounter((String)"HeartbeatsForminidfs-ns-nn1NumOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"HeartbeatsForminidfs-ns-nn2NumOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"HeartbeatsNumOps", (long)2L, (MetricsRecordBuilder)rb);
    }

    @Test
    public void testNNRpcMetricsWithFederation() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setTimeDuration("dfs.heartbeat.interval", 1L, TimeUnit.HOURS);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleFederatedTopology("ns1,ns2")).build();
        cluster.waitActive();
        DataNode dn = cluster.getDataNodes().get(0);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
        MetricsAsserts.assertCounter((String)"HeartbeatsForns1NumOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"HeartbeatsForns2NumOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"HeartbeatsNumOps", (long)2L, (MetricsRecordBuilder)rb);
    }

    @Test
    public void testNNRpcMetricsWithFederationAndHA() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setTimeDuration("dfs.heartbeat.interval", 1L, TimeUnit.HOURS);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).nnTopology(MiniDFSNNTopology.simpleHAFederatedTopology(2)).build();
        cluster.waitActive();
        DataNode dn = cluster.getDataNodes().get(0);
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)dn.getMetrics().name());
        MetricsAsserts.assertCounter((String)"HeartbeatsForns0-nn0NumOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"HeartbeatsForns0-nn1NumOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"HeartbeatsForns1-nn0NumOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"HeartbeatsForns1-nn1NumOps", (long)1L, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"HeartbeatsNumOps", (long)4L, (MetricsRecordBuilder)rb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNodeLocalMetrics() throws Exception {
        Assume.assumeTrue((null == DomainSocket.getLoadingFailureReason() ? 1 : 0) != 0);
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setBoolean(HdfsClientConfigKeys.Read.ShortCircuit.KEY, true);
        TemporarySocketDirectory sockDir = new TemporarySocketDirectory();
        DomainSocket.disableBindPathValidation();
        conf.set("dfs.domain.socket.path", new File(sockDir.getDir(), "testNodeLocalMetrics._PORT.sock").getAbsolutePath());
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path testFile = new Path("/testNodeLocalMetrics.txt");
            DFSTestUtil.createFile((FileSystem)fs, testFile, 10L, (short)1, 1L);
            DFSTestUtil.readFile((FileSystem)fs, testFile);
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)1L, (long)datanodes.size());
            DataNode datanode = (DataNode)datanodes.get(0);
            MetricsRecordBuilder rb = MetricsAsserts.getMetrics((String)datanode.getMetrics().name());
            MetricsAsserts.assertCounter((String)"WritesFromLocalClient", (long)1L, (MetricsRecordBuilder)rb);
            MetricsAsserts.assertCounter((String)"ReadsFromLocalClient", (long)1L, (MetricsRecordBuilder)rb);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testDataNodeReadWriteXceiversCount() throws Exception {
        try (MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)new HdfsConfiguration()).build();){
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            ArrayList<DataNode> datanodes = cluster.getDataNodes();
            Assert.assertEquals((long)1L, (long)datanodes.size());
            final DataNode datanode = (DataNode)datanodes.get(0);
            long writeXceiversCount = MetricsAsserts.getIntGauge((String)"DataNodeWriteActiveXceiversCount", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)datanode.getMetrics().name()));
            Assert.assertEquals((long)0L, (long)writeXceiversCount);
            Path path = new Path("/testDataNodeReadWriteXceiversCount.txt");
            try (FSDataOutputStream output = fs.create(path);){
                output.write(new byte[1024]);
                output.hsync();
                GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                    @Override
                    public Boolean get() {
                        int writeXceiversCount = MetricsAsserts.getIntGauge((String)"DataNodeWriteActiveXceiversCount", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)datanode.getMetrics().name()));
                        return writeXceiversCount == 1;
                    }
                }, (long)100L, (long)10000L);
            }
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    int writeXceiversCount = MetricsAsserts.getIntGauge((String)"DataNodeWriteActiveXceiversCount", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)datanode.getMetrics().name()));
                    return writeXceiversCount == 0;
                }
            }, (long)100L, (long)10000L);
            long readXceiversCount = MetricsAsserts.getIntGauge((String)"DataNodeReadActiveXceiversCount", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)datanode.getMetrics().name()));
            Assert.assertEquals((long)0L, (long)readXceiversCount);
            try (FSDataInputStream input = fs.open(path);){
                byte[] byteArray = new byte[1024];
                input.read(byteArray);
                GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                    @Override
                    public Boolean get() {
                        int readXceiversCount = MetricsAsserts.getIntGauge((String)"DataNodeReadActiveXceiversCount", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)datanode.getMetrics().name()));
                        return readXceiversCount == 1;
                    }
                }, (long)100L, (long)10000L);
            }
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    int readXceiversCount = MetricsAsserts.getIntGauge((String)"DataNodeReadActiveXceiversCount", (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)datanode.getMetrics().name()));
                    return readXceiversCount == 0;
                }
            }, (long)100L, (long)10000L);
        }
    }
}

