/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PathUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDataNodeFaultInjector {
    private static final Logger LOG = LoggerFactory.getLogger(TestDataNodeFaultInjector.class);

    @Test(timeout=60000L)
    public void testDelaySendingAckToUpstream() throws Exception {
        MetricsDataNodeFaultInjector mdnFaultInjector = new MetricsDataNodeFaultInjector(){

            public void delaySendingAckToUpstream(String upstreamAddr) throws IOException {
                this.delayOnce();
            }

            public void logDelaySendingAckToUpstream(String upstreamAddr, long delayMs) throws IOException {
                this.logDelay(delayMs);
            }
        };
        this.verifyFaultInjectionDelayPipeline(mdnFaultInjector);
    }

    @Test(timeout=60000L)
    public void testDelaySendingPacketDownstream() throws Exception {
        MetricsDataNodeFaultInjector mdnFaultInjector = new MetricsDataNodeFaultInjector(){

            public void stopSendingPacketDownstream(String mirrAddr) throws IOException {
                this.delayOnce();
            }

            public void logDelaySendingPacketDownstream(String mirrAddr, long delayMs) throws IOException {
                this.logDelay(delayMs);
            }
        };
        this.verifyFaultInjectionDelayPipeline(mdnFaultInjector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFaultInjectionDelayPipeline(MetricsDataNodeFaultInjector mdnFaultInjector) throws Exception {
        Path baseDir = new Path(PathUtils.getTestDir(this.getClass()).getPath(), GenericTestUtils.getMethodName());
        DataNodeFaultInjector oldDnInjector = DataNodeFaultInjector.get();
        DataNodeFaultInjector.set((DataNodeFaultInjector)mdnFaultInjector);
        HdfsConfiguration conf = new HdfsConfiguration();
        long datanodeSlowLogThresholdMs = 1000L;
        conf.setLong("dfs.datanode.slow.io.warning.threshold.ms", 1000L);
        conf.set("hdfs.minidfs.basedir", baseDir.toString());
        conf.setLong("dfs.client.socket-timeout", 4000L);
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", true);
        conf.set("dfs.client.block.write.replace-datanode-on-failure.policy", "ALWAYS");
        MiniDFSCluster cluster = null;
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            try (FSDataOutputStream out = fs.create(new Path(baseDir, "test.data"), (short)2);){
                out.write(49);
                out.hflush();
                out.hsync();
            }
            LOG.info("delay info: " + mdnFaultInjector.getDelayMs() + ":1000");
            Assert.assertTrue((String)"Injected delay should be longer than the configured one", (mdnFaultInjector.getDelayMs() > 1000L ? 1 : 0) != 0);
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldDnInjector);
        }
    }

    private static class MetricsDataNodeFaultInjector
    extends DataNodeFaultInjector {
        public static final long DELAY = 2000L;
        private long delayMs = 0L;
        private final String err = "Interrupted while sleeping. Bailing out.";
        private long delayTries = 1L;

        private MetricsDataNodeFaultInjector() {
        }

        void delayOnce() throws IOException {
            if (this.delayTries > 0L) {
                --this.delayTries;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    throw new IOException("Interrupted while sleeping. Bailing out.");
                }
            }
        }

        long getDelayMs() {
            return this.delayMs;
        }

        void logDelay(long duration) {
            if (duration >= 2000L) {
                this.delayMs = duration;
            }
        }
    }
}

