/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCrcCorruption {
    public static final Logger LOG = LoggerFactory.getLogger(TestCrcCorruption.class);
    private DFSClientFaultInjector faultInjector;

    @Before
    public void setUp() throws IOException {
        this.faultInjector = (DFSClientFaultInjector)Mockito.mock(DFSClientFaultInjector.class);
        DFSClientFaultInjector.set((DFSClientFaultInjector)this.faultInjector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=50000L)
    public void testCorruptionDuringWrt() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setInt("dfs.client.retry.window.base", 10);
        MiniDFSCluster cluster = null;
        try {
            int c;
            int i;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(10).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            Path file = new Path("/test_corruption_file");
            FSDataOutputStream out = fs.create(file, true, 8192, (short)3, 0x8000000L);
            byte[] data = new byte[65536];
            for (i = 0; i < 65536; ++i) {
                data[i] = (byte)(i % 256);
            }
            for (i = 0; i < 5; ++i) {
                out.write(data, 0, 65535);
            }
            out.hflush();
            Mockito.when((Object)this.faultInjector.corruptPacket()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when((Object)this.faultInjector.uncorruptPacket()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            for (i = 0; i < 5; ++i) {
                out.write(data, 0, 65535);
            }
            out.close();
            FSDataInputStream in = fs.open(file);
            while ((c = in.read()) != -1) {
            }
            in.close();
            out = fs.create(file, true, 8192, (short)3, 0x8000000L);
            Mockito.when((Object)this.faultInjector.corruptPacket()).thenReturn((Object)true, (Object[])new Boolean[]{false});
            Mockito.when((Object)this.faultInjector.uncorruptPacket()).thenReturn((Object)false);
            try {
                for (int i2 = 0; i2 < 5; ++i2) {
                    out.write(data, 0, 65535);
                }
                out.close();
                Assert.fail((String)"Write did not fail");
            }
            catch (IOException ioe) {
                DFSClient.LOG.info("Got expected exception", (Throwable)ioe);
            }
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
            Mockito.when((Object)this.faultInjector.corruptPacket()).thenReturn((Object)false);
            Mockito.when((Object)this.faultInjector.uncorruptPacket()).thenReturn((Object)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void thistest(Configuration conf, DFSTestUtil util) throws Exception {
        MiniDFSCluster cluster = null;
        int numDataNodes = 2;
        short replFactor = 2;
        Random random = new Random();
        conf.setInt("dfs.client.retry.window.base", 10);
        try {
            cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDataNodes).build();
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            util.createFiles((FileSystem)fs, "/srcdat", replFactor);
            util.waitReplication((FileSystem)fs, "/srcdat", (short)2);
            boolean dnIdx = false;
            DataNode dn = cluster.getDataNodes().get(0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            List replicas = dn.getFSDataset().getFinalizedBlocks(bpid);
            Assert.assertTrue((String)"Replicas do not exist", (!replicas.isEmpty() ? 1 : 0) != 0);
            for (int idx = 0; idx < replicas.size(); ++idx) {
                ReplicaInfo replica = (ReplicaInfo)replicas.get(idx);
                ExtendedBlock eb = new ExtendedBlock(bpid, (Block)replica);
                if (idx % 3 == 0) {
                    LOG.info("Deliberately removing meta for block " + eb);
                    cluster.deleteMeta(0, eb);
                    continue;
                }
                if (idx % 3 == 1) {
                    int newSize = 2;
                    LOG.info("Deliberately truncating meta file for block " + eb + " to size 2 bytes.");
                    cluster.truncateMeta(0, eb, 2);
                    continue;
                }
                cluster.corruptMeta(0, eb);
            }
            Assert.assertTrue((String)"Corrupted replicas not handled properly.", (boolean)util.checkFiles((FileSystem)fs, "/srcdat"));
            LOG.info("All File still have a valid replica");
            util.setReplication((FileSystem)fs, "/srcdat", (short)1);
            LOG.info("The excess-corrupted-replica test is disabled  pending HADOOP-1557");
            util.cleanup((FileSystem)fs, "/srcdat");
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testCrcCorruption() throws Exception {
        System.out.println("TestCrcCorruption with default parameters");
        HdfsConfiguration conf1 = new HdfsConfiguration();
        conf1.setInt("dfs.blockreport.intervalMsec", 3000);
        DFSTestUtil util1 = new DFSTestUtil.Builder().setName("TestCrcCorruption").setNumFiles(40).build();
        this.thistest((Configuration)conf1, util1);
        System.out.println("TestCrcCorruption with specific parameters");
        HdfsConfiguration conf2 = new HdfsConfiguration();
        conf2.setInt("dfs.bytes-per-checksum", 17);
        conf2.setInt("dfs.blocksize", 34);
        DFSTestUtil util2 = new DFSTestUtil.Builder().setName("TestCrcCorruption").setNumFiles(40).setMaxSize(400).build();
        this.thistest((Configuration)conf2, util2);
    }

    @Test(timeout=300000L)
    public void testEntirelyCorruptFileOneNode() throws Exception {
        this.doTestEntirelyCorruptFile(1);
    }

    @Test(timeout=300000L)
    public void testEntirelyCorruptFileThreeNodes() throws Exception {
        this.doTestEntirelyCorruptFile(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestEntirelyCorruptFile(int numDataNodes) throws Exception {
        long fileSize = 4096L;
        Path file = new Path("/testFile");
        short replFactor = (short)numDataNodes;
        Configuration conf = new Configuration();
        conf.setInt("dfs.replication", numDataNodes);
        conf.setInt("dfs.client.retry.window.base", 10);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).numDataNodes(numDataNodes).build();
        try {
            cluster.waitActive();
            DistributedFileSystem fs = cluster.getFileSystem();
            DFSTestUtil.createFile((FileSystem)fs, file, fileSize, replFactor, 12345L);
            DFSTestUtil.waitReplication((FileSystem)fs, file, replFactor);
            ExtendedBlock block = DFSTestUtil.getFirstBlock((FileSystem)fs, file);
            int blockFilesCorrupted = cluster.corruptBlockOnDataNodes(block);
            Assert.assertEquals((String)"All replicas not corrupted", (long)replFactor, (long)blockFilesCorrupted);
            try {
                IOUtils.copyBytes((InputStream)fs.open(file), (OutputStream)new IOUtils.NullOutputStream(), (Configuration)conf, (boolean)true);
                Assert.fail((String)"Didn't get exception");
            }
            catch (IOException ioe) {
                DFSClient.LOG.info("Got expected exception", (Throwable)ioe);
            }
        }
        finally {
            cluster.shutdown();
        }
    }
}

