/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.visitor;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.hadoop.hdfs.server.namenode.DirectoryWithQuotaFeature;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.INodeFile;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;
import org.apache.hadoop.hdfs.server.namenode.INodeSymlink;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.DirectoryWithSnapshotFeature;
import org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import org.apache.hadoop.hdfs.server.namenode.visitor.NamespaceVisitor;

public final class NamespacePrintVisitor
implements NamespaceVisitor {
    static final String NON_LAST_ITEM = "+-";
    static final String LAST_ITEM = "\\-";
    private final PrintWriter out;
    private final StringBuilder prefix = new StringBuilder();

    public static String print2Sting(FSNamesystem ns) {
        return NamespacePrintVisitor.print2Sting(ns.getFSDirectory().getRoot());
    }

    public static String print2Sting(INode root) {
        StringWriter out = new StringWriter();
        new NamespacePrintVisitor(new PrintWriter(out)).print(root);
        return out.getBuffer().toString();
    }

    private NamespacePrintVisitor(PrintWriter out) {
        this.out = out;
    }

    private void print(INode root) {
        root.accept(this, 0x7FFFFFFE);
    }

    private void printINode(INode iNode, int snapshot) {
        iNode.dumpINode(this.out, this.prefix, snapshot);
    }

    @Override
    public void visitFile(INodeFile file, int snapshot) {
        file.dumpINodeFile(this.out, this.prefix, snapshot);
    }

    @Override
    public void visitSymlink(INodeSymlink symlink, int snapshot) {
        this.printINode(symlink, snapshot);
        this.out.print(" ~> ");
        this.out.println(symlink.getSymlinkString());
    }

    @Override
    public void visitReference(INodeReference ref, int snapshot) {
        this.printINode(ref, snapshot);
        if (ref instanceof INodeReference.DstReference) {
            this.out.print(", dstSnapshotId=" + ref.getDstSnapshotId());
        } else if (ref instanceof INodeReference.WithCount) {
            this.out.print(", " + ((INodeReference.WithCount)ref).getCountDetails());
        }
        this.out.println();
    }

    @Override
    public void preVisitReferred(INode referred) {
        this.prefix.setLength(this.prefix.length() - 2);
        this.prefix.append("  ->");
    }

    @Override
    public void postVisitReferred(INode referred) {
        this.prefix.setLength(this.prefix.length() - 2);
    }

    @Override
    public void visitDirectory(INodeDirectory dir, int snapshot) {
        DirectoryWithSnapshotFeature snapshotFeature;
        this.printINode(dir, snapshot);
        this.out.print(", childrenSize=" + dir.getChildrenList(snapshot).size());
        DirectoryWithQuotaFeature q = dir.getDirectoryWithQuotaFeature();
        if (q != null) {
            this.out.print(", " + q);
        }
        if (dir instanceof Snapshot.Root) {
            this.out.print(", snapshotId=" + snapshot);
        }
        this.out.println();
        if (this.prefix.length() >= 2) {
            this.prefix.setLength(this.prefix.length() - 2);
            this.prefix.append("  ");
        }
        if ((snapshotFeature = dir.getDirectoryWithSnapshotFeature()) != null) {
            this.out.print(this.prefix);
            this.out.print(snapshotFeature);
        }
        this.out.println();
    }

    @Override
    public void visitSnapshottable(INodeDirectory dir, DirectorySnapshottableFeature snapshottable) {
        this.out.println();
        this.out.print(this.prefix);
        this.out.print("Snapshot of ");
        String name = dir.getLocalName();
        this.out.print(name != null && name.isEmpty() ? "/" : name);
        this.out.print(": quota=");
        this.out.print(snapshottable.getSnapshotQuota());
        int n = 0;
        for (DirectoryWithSnapshotFeature.DirectoryDiff diff : snapshottable.getDiffs()) {
            if (!diff.isSnapshotRoot()) continue;
            ++n;
        }
        int numSnapshots = snapshottable.getNumSnapshots();
        Preconditions.checkState((n == numSnapshots ? 1 : 0) != 0, (Object)("numSnapshots = " + numSnapshots + " != " + n));
        this.out.print(", #snapshot=");
        this.out.println(n);
    }

    @Override
    public void preVisitSub(NamespaceVisitor.Element sub, int index, boolean isLast) {
        this.prefix.append(isLast ? LAST_ITEM : NON_LAST_ITEM);
    }

    @Override
    public void postVisitSub(NamespaceVisitor.Element sub, int index, boolean isLast) {
        this.prefix.setLength(this.prefix.length() - 2);
    }
}

