/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.metrics;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.metrics2.source.JvmMetrics;

@Metrics(name="NameNodeActivity", about="NameNode metrics", context="dfs")
public class NameNodeMetrics {
    final MetricsRegistry registry = new MetricsRegistry("namenode");
    @Metric
    MutableCounterLong createFileOps;
    @Metric
    MutableCounterLong filesCreated;
    @Metric
    MutableCounterLong filesAppended;
    @Metric
    MutableCounterLong getBlockLocations;
    @Metric
    MutableCounterLong filesRenamed;
    @Metric
    MutableCounterLong filesTruncated;
    @Metric
    MutableCounterLong getListingOps;
    @Metric
    MutableCounterLong deleteFileOps;
    @Metric(value={"Number of files/dirs deleted by delete or rename operations"})
    MutableCounterLong filesDeleted;
    @Metric
    MutableCounterLong fileInfoOps;
    @Metric
    MutableCounterLong addBlockOps;
    @Metric
    MutableCounterLong getAdditionalDatanodeOps;
    @Metric
    MutableCounterLong createSymlinkOps;
    @Metric
    MutableCounterLong getLinkTargetOps;
    @Metric
    MutableCounterLong filesInGetListingOps;
    @Metric(value={"Number of successful re-replications"})
    MutableCounterLong successfulReReplications;
    @Metric(value={"Number of times we failed to schedule a block re-replication."})
    MutableCounterLong numTimesReReplicationNotScheduled;
    @Metric(value={"Number of timed out block re-replications"})
    MutableCounterLong timeoutReReplications;
    @Metric(value={"Number of allowSnapshot operations"})
    MutableCounterLong allowSnapshotOps;
    @Metric(value={"Number of disallowSnapshot operations"})
    MutableCounterLong disallowSnapshotOps;
    @Metric(value={"Number of createSnapshot operations"})
    MutableCounterLong createSnapshotOps;
    @Metric(value={"Number of deleteSnapshot operations"})
    MutableCounterLong deleteSnapshotOps;
    @Metric(value={"Number of renameSnapshot operations"})
    MutableCounterLong renameSnapshotOps;
    @Metric(value={"Number of listSnapshottableDirectory operations"})
    MutableCounterLong listSnapshottableDirOps;
    @Metric(value={"Number of listSnapshots operations"})
    MutableCounterLong listSnapshotOps;
    @Metric(value={"Number of snapshotDiffReport operations"})
    MutableCounterLong snapshotDiffReportOps;
    @Metric(value={"Number of blockReceivedAndDeleted calls"})
    MutableCounterLong blockReceivedAndDeletedOps;
    @Metric(value={"Number of blockReports and blockReceivedAndDeleted queued"})
    MutableGaugeInt blockOpsQueued;
    @Metric(value={"Number of blockReports and blockReceivedAndDeleted batch processed"})
    MutableCounterLong blockOpsBatched;
    @Metric(value={"Journal transactions"})
    MutableRate transactions;
    @Metric(value={"Journal syncs"})
    MutableRate syncs;
    final MutableQuantiles[] syncsQuantiles;
    @Metric(value={"Journal transactions batched in sync"})
    MutableCounterLong transactionsBatchedInSync;
    @Metric(value={"Journal transactions batched in sync"})
    final MutableQuantiles[] numTransactionsBatchedInSync;
    @Metric(value={"Number of blockReports from individual storages"})
    MutableRate storageBlockReport;
    final MutableQuantiles[] storageBlockReportQuantiles;
    @Metric(value={"Cache report"})
    MutableRate cacheReport;
    final MutableQuantiles[] cacheReportQuantiles;
    @Metric(value={"Generate EDEK time"})
    private MutableRate generateEDEKTime;
    private final MutableQuantiles[] generateEDEKTimeQuantiles;
    @Metric(value={"Warm-up EDEK time"})
    private MutableRate warmUpEDEKTime;
    private final MutableQuantiles[] warmUpEDEKTimeQuantiles;
    @Metric(value={"Resource check time"})
    private MutableRate resourceCheckTime;
    private final MutableQuantiles[] resourceCheckTimeQuantiles;
    @Metric(value={"Duration in SafeMode at startup in msec"})
    MutableGaugeInt safeModeTime;
    @Metric(value={"Time loading FS Image at startup in msec"})
    MutableGaugeInt fsImageLoadTime;
    @Metric(value={"Time tailing edit logs in msec"})
    MutableRate editLogTailTime;
    private final MutableQuantiles[] editLogTailTimeQuantiles;
    @Metric
    MutableRate editLogFetchTime;
    private final MutableQuantiles[] editLogFetchTimeQuantiles;
    @Metric(value={"Number of edits loaded"}, valueName="Count")
    MutableStat numEditLogLoaded;
    private final MutableQuantiles[] numEditLogLoadedQuantiles;
    @Metric(value={"Time between edit log tailing in msec"})
    MutableRate editLogTailInterval;
    private final MutableQuantiles[] editLogTailIntervalQuantiles;
    @Metric(value={"GetImageServlet getEdit"})
    MutableRate getEdit;
    @Metric(value={"GetImageServlet getImage"})
    MutableRate getImage;
    @Metric(value={"GetImageServlet putImage"})
    MutableRate putImage;
    JvmMetrics jvmMetrics = null;

    @Metric(value={"Number of file system operations"})
    public long totalFileOps() {
        return this.getBlockLocations.value() + this.createFileOps.value() + this.filesAppended.value() + this.addBlockOps.value() + this.getAdditionalDatanodeOps.value() + this.filesRenamed.value() + this.filesTruncated.value() + this.deleteFileOps.value() + this.getListingOps.value() + this.fileInfoOps.value() + this.getLinkTargetOps.value() + this.createSnapshotOps.value() + this.deleteSnapshotOps.value() + this.allowSnapshotOps.value() + this.disallowSnapshotOps.value() + this.renameSnapshotOps.value() + this.listSnapshottableDirOps.value() + this.listSnapshotOps.value() + this.createSymlinkOps.value() + this.snapshotDiffReportOps.value();
    }

    NameNodeMetrics(String processName, String sessionId, int[] intervals, JvmMetrics jvmMetrics) {
        this.jvmMetrics = jvmMetrics;
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, processName).tag((MetricsInfo)MsInfo.SessionId, sessionId);
        int len = intervals.length;
        this.syncsQuantiles = new MutableQuantiles[len];
        this.numTransactionsBatchedInSync = new MutableQuantiles[len];
        this.storageBlockReportQuantiles = new MutableQuantiles[len];
        this.cacheReportQuantiles = new MutableQuantiles[len];
        this.generateEDEKTimeQuantiles = new MutableQuantiles[len];
        this.warmUpEDEKTimeQuantiles = new MutableQuantiles[len];
        this.resourceCheckTimeQuantiles = new MutableQuantiles[len];
        this.editLogTailTimeQuantiles = new MutableQuantiles[len];
        this.editLogFetchTimeQuantiles = new MutableQuantiles[len];
        this.numEditLogLoadedQuantiles = new MutableQuantiles[len];
        this.editLogTailIntervalQuantiles = new MutableQuantiles[len];
        for (int i = 0; i < len; ++i) {
            int interval = intervals[i];
            this.syncsQuantiles[i] = this.registry.newQuantiles("syncs" + interval + "s", "Journal syncs", "ops", "latency", interval);
            this.numTransactionsBatchedInSync[i] = this.registry.newQuantiles("numTransactionsBatchedInSync" + interval + "s", "Number of Transactions batched in sync", "ops", "count", interval);
            this.storageBlockReportQuantiles[i] = this.registry.newQuantiles("storageBlockReport" + interval + "s", "Storage block report", "ops", "latency", interval);
            this.cacheReportQuantiles[i] = this.registry.newQuantiles("cacheReport" + interval + "s", "Cache report", "ops", "latency", interval);
            this.generateEDEKTimeQuantiles[i] = this.registry.newQuantiles("generateEDEKTime" + interval + "s", "Generate EDEK time", "ops", "latency", interval);
            this.warmUpEDEKTimeQuantiles[i] = this.registry.newQuantiles("warmupEDEKTime" + interval + "s", "Warm up EDEK time", "ops", "latency", interval);
            this.resourceCheckTimeQuantiles[i] = this.registry.newQuantiles("resourceCheckTime" + interval + "s", "resource check time", "ops", "latency", interval);
            this.editLogTailTimeQuantiles[i] = this.registry.newQuantiles("editLogTailTime" + interval + "s", "Edit log tailing time", "ops", "latency", interval);
            this.editLogFetchTimeQuantiles[i] = this.registry.newQuantiles("editLogFetchTime" + interval + "s", "Edit log fetch time", "ops", "latency", interval);
            this.numEditLogLoadedQuantiles[i] = this.registry.newQuantiles("numEditLogLoaded" + interval + "s", "Number of edits loaded", "ops", "count", interval);
            this.editLogTailIntervalQuantiles[i] = this.registry.newQuantiles("editLogTailInterval" + interval + "s", "Edit log tailing interval", "ops", "latency", interval);
        }
    }

    public static NameNodeMetrics create(Configuration conf, HdfsServerConstants.NamenodeRole r) {
        String sessionId = conf.get("dfs.metrics.session-id");
        String processName = r.toString();
        MetricsSystem ms = DefaultMetricsSystem.instance();
        JvmMetrics jm = JvmMetrics.create((String)processName, (String)sessionId, (MetricsSystem)ms);
        int[] intervals = conf.getInts("dfs.metrics.percentiles.intervals");
        return (NameNodeMetrics)ms.register((Object)new NameNodeMetrics(processName, sessionId, intervals, jm));
    }

    public JvmMetrics getJvmMetrics() {
        return this.jvmMetrics;
    }

    public void shutdown() {
        DefaultMetricsSystem.shutdown();
    }

    public void incrGetBlockLocations() {
        this.getBlockLocations.incr();
    }

    public void incrFilesCreated() {
        this.filesCreated.incr();
    }

    public void incrCreateFileOps() {
        this.createFileOps.incr();
    }

    public void incrFilesAppended() {
        this.filesAppended.incr();
    }

    public void incrAddBlockOps() {
        this.addBlockOps.incr();
    }

    public void incrGetAdditionalDatanodeOps() {
        this.getAdditionalDatanodeOps.incr();
    }

    public void incrFilesRenamed() {
        this.filesRenamed.incr();
    }

    public void incrFilesTruncated() {
        this.filesTruncated.incr();
    }

    public void incrFilesDeleted(long delta) {
        this.filesDeleted.incr(delta);
    }

    public void incrDeleteFileOps() {
        this.deleteFileOps.incr();
    }

    public void incrGetListingOps() {
        this.getListingOps.incr();
    }

    public void incrFilesInGetListingOps(int delta) {
        this.filesInGetListingOps.incr((long)delta);
    }

    public void incrFileInfoOps() {
        this.fileInfoOps.incr();
    }

    public void incrCreateSymlinkOps() {
        this.createSymlinkOps.incr();
    }

    public void incrGetLinkTargetOps() {
        this.getLinkTargetOps.incr();
    }

    public void incrAllowSnapshotOps() {
        this.allowSnapshotOps.incr();
    }

    public void incrDisAllowSnapshotOps() {
        this.disallowSnapshotOps.incr();
    }

    public void incrCreateSnapshotOps() {
        this.createSnapshotOps.incr();
    }

    public void incrDeleteSnapshotOps() {
        this.deleteSnapshotOps.incr();
    }

    public void incrRenameSnapshotOps() {
        this.renameSnapshotOps.incr();
    }

    public void incrListSnapshottableDirOps() {
        this.listSnapshottableDirOps.incr();
    }

    public void incrListSnapshotsOps() {
        this.listSnapshotOps.incr();
    }

    public void incrSnapshotDiffReportOps() {
        this.snapshotDiffReportOps.incr();
    }

    public void incrBlockReceivedAndDeletedOps() {
        this.blockReceivedAndDeletedOps.incr();
    }

    public void setBlockOpsQueued(int size) {
        this.blockOpsQueued.set(size);
    }

    public void addBlockOpsBatched(int count) {
        this.blockOpsBatched.incr((long)count);
    }

    public void addTransaction(long latency) {
        this.transactions.add(latency);
    }

    public void incrTransactionsBatchedInSync(long count) {
        this.transactionsBatchedInSync.incr(count);
        for (MutableQuantiles q : this.numTransactionsBatchedInSync) {
            q.add(count);
        }
    }

    public void incSuccessfulReReplications() {
        this.successfulReReplications.incr();
    }

    public void incNumTimesReReplicationNotScheduled() {
        this.numTimesReReplicationNotScheduled.incr();
    }

    public void incTimeoutReReplications() {
        this.timeoutReReplications.incr();
    }

    public void addSync(long elapsed) {
        this.syncs.add(elapsed);
        for (MutableQuantiles q : this.syncsQuantiles) {
            q.add(elapsed);
        }
    }

    public void setFsImageLoadTime(long elapsed) {
        this.fsImageLoadTime.set((int)elapsed);
    }

    public void addStorageBlockReport(long latency) {
        this.storageBlockReport.add(latency);
        for (MutableQuantiles q : this.storageBlockReportQuantiles) {
            q.add(latency);
        }
    }

    public void addCacheBlockReport(long latency) {
        this.cacheReport.add(latency);
        for (MutableQuantiles q : this.cacheReportQuantiles) {
            q.add(latency);
        }
    }

    public void setSafeModeTime(long elapsed) {
        this.safeModeTime.set((int)elapsed);
    }

    public void addGetEdit(long latency) {
        this.getEdit.add(latency);
    }

    public void addGetImage(long latency) {
        this.getImage.add(latency);
    }

    public void addPutImage(long latency) {
        this.putImage.add(latency);
    }

    public void addGenerateEDEKTime(long latency) {
        this.generateEDEKTime.add(latency);
        for (MutableQuantiles q : this.generateEDEKTimeQuantiles) {
            q.add(latency);
        }
    }

    public void addWarmUpEDEKTime(long latency) {
        this.warmUpEDEKTime.add(latency);
        for (MutableQuantiles q : this.warmUpEDEKTimeQuantiles) {
            q.add(latency);
        }
    }

    public void addResourceCheckTime(long latency) {
        this.resourceCheckTime.add(latency);
        for (MutableQuantiles q : this.resourceCheckTimeQuantiles) {
            q.add(latency);
        }
    }

    public void addEditLogTailTime(long elapsed) {
        this.editLogTailTime.add(elapsed);
        for (MutableQuantiles q : this.editLogTailTimeQuantiles) {
            q.add(elapsed);
        }
    }

    public void addEditLogFetchTime(long elapsed) {
        this.editLogFetchTime.add(elapsed);
        for (MutableQuantiles q : this.editLogFetchTimeQuantiles) {
            q.add(elapsed);
        }
    }

    public void addNumEditLogLoaded(long loaded) {
        this.numEditLogLoaded.add(loaded);
        for (MutableQuantiles q : this.numEditLogLoadedQuantiles) {
            q.add(loaded);
        }
    }

    public void addEditLogTailInterval(long elapsed) {
        this.editLogTailInterval.add(elapsed);
        for (MutableQuantiles q : this.editLogTailIntervalQuantiles) {
            q.add(elapsed);
        }
    }
}

