/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Objects;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.util.StringUtils;

public class QuotaByStorageTypeEntry {
    private StorageType type;
    private long quota;

    public StorageType getStorageType() {
        return this.type;
    }

    public long getQuota() {
        return this.quota;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        QuotaByStorageTypeEntry other = (QuotaByStorageTypeEntry)o;
        return Objects.equal((Object)this.type, (Object)other.type) && Objects.equal((Object)this.quota, (Object)other.quota);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.quota});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        assert (this.type != null);
        sb.append(StringUtils.toLowerCase((String)this.type.toString())).append(':').append(this.quota);
        return sb.toString();
    }

    private QuotaByStorageTypeEntry(StorageType type, long quota) {
        this.type = type;
        this.quota = quota;
    }

    public static class Builder {
        private StorageType type;
        private long quota;

        public Builder setStorageType(StorageType type) {
            this.type = type;
            return this;
        }

        public Builder setQuota(long quota) {
            this.quota = quota;
            return this;
        }

        public QuotaByStorageTypeEntry build() {
            return new QuotaByStorageTypeEntry(this.type, this.quota);
        }
    }
}

