/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.command;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.server.diskbalancer.DiskBalancerException;
import org.apache.hadoop.hdfs.server.diskbalancer.command.Command;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.apache.hadoop.hdfs.tools.DiskBalancerCLI;

public class ExecuteCommand
extends Command {
    public ExecuteCommand(Configuration conf) {
        super(conf);
        this.addValidCommandParameters("execute", "Executes a given plan.");
    }

    @Override
    public void execute(CommandLine cmd) throws Exception {
        LOG.info("Executing \"execute plan\" command");
        Preconditions.checkState((boolean)cmd.hasOption("execute"));
        this.verifyCommandOptions("execute", cmd);
        String planFile = cmd.getOptionValue("execute");
        Preconditions.checkArgument((planFile != null && !planFile.isEmpty() ? 1 : 0) != 0, (Object)"Invalid plan file specified.");
        String planData = null;
        try (FSDataInputStream plan = this.open(planFile);){
            planData = IOUtils.toString((InputStream)plan);
        }
        this.submitPlan(planFile, planData);
    }

    private void submitPlan(String planFile, String planData) throws IOException {
        Preconditions.checkNotNull((Object)planData);
        NodePlan plan = NodePlan.parseJson(planData);
        String dataNodeAddress = plan.getNodeName() + ":" + plan.getPort();
        Preconditions.checkNotNull((Object)dataNodeAddress);
        ClientDatanodeProtocol dataNode = this.getDataNodeProxy(dataNodeAddress);
        String planHash = DigestUtils.shaHex((String)planData);
        try {
            dataNode.submitDiskBalancerPlan(planHash, 1L, planFile, planData, false);
        }
        catch (DiskBalancerException ex) {
            LOG.error("Submitting plan on  {} failed. Result: {}, Message: {}", new Object[]{plan.getNodeName(), ex.getResult().toString(), ex.getMessage()});
            throw ex;
        }
    }

    @Override
    public void printHelp() {
        String header = "Execute command runs a submits a plan for execution on the given data node.\n\n";
        String footer = "\nExecute command submits the job to data node and returns immediately. The state of job can be monitored via query command. ";
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("hdfs diskbalancer -execute <planfile>", header, DiskBalancerCLI.getExecuteOptions(), footer);
    }
}

